;;; company-coq-abbrev.el --- List of tactics, auto-generated from RefMan

;; Copyright (C) 2015  Clément Pit--Claudel
;; Author: Clément Pit--Claudel <clement.pitclaudel@live.com>
;; URL: https://github.com/cpitclaudel/company-coq

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

(defconst company-coq--refman-ltac-abbrevs
  (list
    '("abstract @{expr}" . ("9t" . 897))
    '("abstract @{expr} using @{ident}" . ("9t" . 901))
    '("appcontext @{ident} [@{cpattern}]" . ("9t" . 884))
    '("context @{ident} [@{cpattern}]" . ("9t" . 883))
    '("context @{ident} [@{expr}]" . ("9t" . 887))
    '("do @{num} @{expr}" . ("9t" . 856))
    '("eval @{redexpr} in @{term}" . ("9t" . 890))
    '("exactly_once @{expr}" . ("9t" . 864))
    '("fresh @{component+}" . ("9t" . 889))
    '("fun @{ident+} => @{expr}" . ("9t" . 880))
    '("guard @{test}" . ("9t" . 895))
    '("numgoals" . ("9t" . 894))
    '("once @{expr}" . ("9t" . 863))
    '("progress @{expr}" . ("9t" . 859))
    '("repeat @{expr}" . ("9t" . 857))
    '("solve [@{expr|+}]" . ("9t" . 866))
    '("time @{string} @{expr}" . ("9t" . 879))
    '("timeout @{num} @{expr}" . ("9t" . 878))
    '("try @{expr}" . ("9t" . 858))
    '("tryif @{expr} then @{expr} else @{expr}" . ("9t" . 862))
    '("type of @{term}" . ("9t" . 891))
    '("type_term @{term}" . ("9t" . 893))
    '("uconstr : @{term}" . ("9t" . 892))))

(defconst company-coq--refman-tactic-abbrevs
  (list
    '("discrR" . ("30" . 164))
    '("split_Rabs" . ("30" . 165))
    '("split_Rmult" . ("30" . 166))
    '("exact @{term}" . ("6p" . 378))
    '("eexact @{term}" . ("6p" . 380))
    '("assumption" . ("6q" . 381))
    '("eassumption" . ("6q" . 383))
    '("refine @{term}" . ("6r" . 384))
    '("simple refine @{term}" . ("6r" . 387))
    '("apply @{term}" . ("6s" . 388))
    '("apply @{term} with @{term+}" . ("6s" . 391))
    '("apply @{term} with (@{ref&} := @{term&})" . ("6s" . 393))
    '("apply @{term,+}" . ("6s" . 394))
    '("eapply @{term}" . ("6s" . 395))
    '("simple apply @{term}" . ("6s" . 396))
    '("lapply @{term}" . ("6s" . 397))
    '("apply @{term} in @{ident}" . ("6t" . 399))
    '("apply @{term,+} in @{ident}" . ("6t" . 402))
    '("apply @{term,&} with @{bindings_list,&} in @{ident}" . ("6t" . 403))
    '("eapply @{term,&} with @{bindings_list,&} in @{ident}" . ("6t" . 404))
    '("apply @{term,&} with @{bindings_list,&} in @{ident} as @{intro_pattern}" . ("6t" . 405))
    '("eapply @{term,&} with @{bindings_list,&} in @{ident} as @{intro_pattern}" . ("6t" . 406))
    '("simple apply @{term} in @{ident}" . ("6t" . 407))
    '("apply @{term,&} in @{ident} as @{intro_pattern}" . ("6t" . 408))
    '("simple apply @{term,&} in @{ident}" . ("6t" . 408))
    '("simple apply @{term,&} in @{ident} as @{intro_pattern}" . ("6t" . 408))
    '("simple apply @{term,&} with @{bindings_list,&} in @{ident}" . ("6t" . 408))
    '("simple apply @{term,&} with @{bindings_list,&} in @{ident} as @{intro_pattern}" . ("6t" . 408))
    '("constructor" . ("6u" . 412))
    '("split" . ("6u" . 415))
    '("left" . ("6u" . 420))
    '("right" . ("6u" . 421))
    '("econstructor" . ("6u" . 426))
    '("eexists" . ("6u" . 427))
    '("esplit" . ("6u" . 428))
    '("eleft" . ("6u" . 429))
    '("eright" . ("6u" . 430))
    '("constructor @{num}" . ("6u" . 409))
    '("constructor @{num} with @{bindings_list}" . ("6u" . 413))
    '("constructor @{tactic}" . ("6u" . 414))
    '("exists @{bindings_list}" . ("6u" . 417))
    '("exists @{bindings_list,+}" . ("6u" . 419))
    '("left with @{bindings_list}" . ("6u" . 423))
    '("right with @{bindings_list}" . ("6u" . 424))
    '("split with @{bindings_list}" . ("6u" . 425))
    '("intro" . ("6w" . 431))
    '("intros" . ("6w" . 434))
    '("intro at top" . ("6w" . 444))
    '("intro at bottom" . ("6w" . 445))
    '("intro @{ident}" . ("6w" . 435))
    '("intros @{ident+}" . ("6w" . 437))
    '("intros until @{ident}" . ("6w" . 438))
    '("intros until @{num}" . ("6w" . 440))
    '("intro after @{ident}" . ("6w" . 442))
    '("intro before @{ident}" . ("6w" . 443))
    '("intro @{ident} after @{ident}" . ("6w" . 447))
    '("intro @{ident} before @{ident}" . ("6w" . 448))
    '("intro @{ident} at top" . ("6w" . 449))
    '("intro @{ident} at bottom" . ("6w" . 450))
    '("intros @{intro_pattern_list}" . ("6y" . 451))
    '("clear" . ("6z" . 461))
    '("clear @{ident}" . ("6z" . 453))
    '("clear @{ident+}" . ("6z" . 457))
    '("clearbody @{ident}" . ("6z" . 458))
    '("clear - @{ident+}" . ("6z" . 460))
    '("clear dependent @{ident}" . ("6z" . 462))
    '("revert @{ident+}" . ("70" . 463))
    '("revert dependent @{ident}" . ("70" . 466))
    '("move @{ident} after @{ident}" . ("71" . 467))
    '("move @{ident} before @{ident}" . ("71" . 468))
    '("move @{ident} at top" . ("71" . 469))
    '("move @{ident} at bottom" . ("71" . 470))
    '("rename @{ident} into @{ident}" . ("72" . 474))
    '("rename @{ident,&} into @{ident,&}" . ("72" . 475))
    '("set (@{ident} := @{term})" . ("73" . 478))
    '("set (@{ident} := @{term}) in @{goal_occurrences}" . ("73" . 480))
    '("set (@{ident} @{binder+} := @{term})" . ("73" . 481))
    '("set @{term}" . ("73" . 482))
    '("set (@{ident} @{binder+} := @{term}) in @{goal_occurrences}" . ("73" . 483))
    '("set @{term} in @{goal_occurrences}" . ("73" . 484))
    '("remember @{term} as @{ident}" . ("73" . 485))
    '("remember @{term}" . ("73" . 486))
    '("remember @{term} as @{ident} eqn:@{ident}" . ("73" . 487))
    '("remember @{term} as @{ident} in @{goal_occurrences}" . ("73" . 488))
    '("pose (@{ident} := @{term})" . ("73" . 489))
    '("pose (@{ident} @{binder+} := @{term})" . ("73" . 490))
    '("pose @{term}" . ("73" . 491))
    '("decompose [@{qualid+}] @{term}" . ("74" . 492))
    '("decompose sum @{term}" . ("74" . 493))
    '("decompose record @{term}" . ("74" . 494))
    '("assert (@{ident} : @{form})" . ("76" . 495))
    '("assert @{form}" . ("76" . 497))
    '("assert @{form} by @{tactic}" . ("76" . 498))
    '("assert @{form} as @{intro_pattern}" . ("76" . 500))
    '("assert @{form} as @{intro_pattern} by @{tactic}" . ("76" . 501))
    '("assert (@{ident} := @{term})" . ("76" . 502))
    '("pose proof @{term} as @{intro_pattern}" . ("76" . 504))
    '("enough (@{ident} : @{form})" . ("76" . 505))
    '("enough @{form}" . ("76" . 506))
    '("enough @{form} as @{intro_pattern}" . ("76" . 507))
    '("enough (@{ident} : @{form}) by @{tactic}" . ("76" . 508))
    '("enough @{form} by @{tactic}" . ("76" . 509))
    '("enough @{form} as @{intro_pattern} by @{tactic}" . ("76" . 510))
    '("cut @{form}" . ("76" . 511))
    '("specialize (@{ident} @{term+})" . ("76" . 512))
    '("specialize @{ident} with @{bindings_list}" . ("76" . 513))
    '("generalize @{term}" . ("78" . 516))
    '("generalize @{term,+}" . ("78" . 517))
    '("generalize @{term} at @{num+}" . ("78" . 518))
    '("generalize @{term} as @{ident}" . ("78" . 519))
    '("generalize @{term,&} at @{num+,&} as @{ident,&}" . ("78" . 520))
    '("generalize dependent @{term}" . ("78" . 521))
    '("evar (@{ident} : @{term})" . ("79" . 522))
    '("instantiate" . ("7a" . 527))
    '("instantiate (@{num} := @{term})" . ("7a" . 523))
    '("instantiate (@{num} := @{term}) in @{ident}" . ("7a" . 524))
    '("instantiate (@{num} := @{term}) in (Value of @{ident})" . ("7a" . 525))
    '("instantiate (@{num} := @{term}) in (Type of @{ident})" . ("7a" . 526))
    '("admit" . ("7b" . 528))
    '("absurd @{term}" . ("7c" . 529))
    '("contradiction" . ("7d" . 530))
    '("contradiction @{ident}" . ("7d" . 532))
    '("contradict @{ident}" . ("7e" . 533))
    '("exfalso" . ("7f" . 534))
    '("destruct @{term}" . ("7h" . 535))
    '("destruct @{term,+}" . ("7h" . 536))
    '("destruct @{term} as @{disj_conj_intro_pattern}" . ("7h" . 537))
    '("destruct @{term} eqn:@{naming_intro_pattern}" . ("7h" . 538))
    '("destruct @{term} with @{bindings_list}" . ("7h" . 539))
    '("edestruct @{term}" . ("7h" . 540))
    '("destruct @{term} using @{term}" . ("7h" . 541))
    '("destruct @{term} using @{term} with @{bindings_list}" . ("7h" . 542))
    '("destruct @{term} in @{goal_occurrences}" . ("7h" . 543))
    '("destruct @{term} with @{bindings_list} as @{disj_conj_intro_pattern} eqn:@{naming_intro_pattern} using @{term} with @{bindings_list} in @{goal_occurrences}" . ("7h" . 544))
    '("edestruct @{term} with @{bindings_list} as @{disj_conj_intro_pattern} eqn:@{naming_intro_pattern} using @{term} with @{bindings_list} in @{goal_occurrences}" . ("7h" . 545))
    '("case @{term}" . ("7h" . 546))
    '("case @{term} with @{bindings_list}" . ("7h" . 547))
    '("ecase @{term}" . ("7h" . 548))
    '("ecase @{term} with @{bindings_list}" . ("7h" . 549))
    '("simple destruct @{ident}" . ("7h" . 550))
    '("simple destruct @{num}" . ("7h" . 551))
    '("case_eq @{term}" . ("7h" . 552))
    '("induction @{term}" . ("7i" . 553))
    '("induction @{term} as @{disj_conj_intro_pattern}" . ("7i" . 556))
    '("induction @{term} with @{bindings_list}" . ("7i" . 557))
    '("einduction @{term}" . ("7i" . 558))
    '("induction @{term} using @{term}" . ("7i" . 559))
    '("induction @{term} using @{term} with @{bindings_list}" . ("7i" . 560))
    '("induction @{term,+} using @{qualid}" . ("7i" . 561))
    '("induction @{term} in @{goal_occurrences}" . ("7i" . 562))
    '("induction @{term} with @{bindings_list} as @{disj_conj_intro_pattern} using @{term} with @{bindings_list} in @{goal_occurrences}" . ("7i" . 563))
    '("einduction @{term} with @{bindings_list} as @{disj_conj_intro_pattern} using @{term} with @{bindings_list} in @{goal_occurrences}" . ("7i" . 564))
    '("elim @{term}" . ("7i" . 565))
    '("elim @{term} with @{bindings_list}" . ("7i" . 566))
    '("eelim @{term}" . ("7i" . 567))
    '("elim @{term} using @{term}" . ("7i" . 568))
    '("elim @{term} using @{term} with @{bindings_list}" . ("7i" . 569))
    '("elim @{term} with @{bindings_list} using @{term} with @{bindings_list}" . ("7i" . 570))
    '("eelim @{term} with @{bindings_list} using @{term} with @{bindings_list}" . ("7i" . 571))
    '("elimtype @{form}" . ("7i" . 572))
    '("simple induction @{ident}" . ("7i" . 573))
    '("simple induction @{num}" . ("7i" . 574))
    '("double induction @{ident} @{ident}" . ("7j" . 575))
    '("double induction @{num} @{num}" . ("7j" . 576))
    '("dependent induction @{ident}" . ("7k" . 577))
    '("dependent induction @{ident} generalizing @{ident+}" . ("7k" . 578))
    '("dependent destruction @{ident}" . ("7k" . 579))
    '("functional induction (@{qualid} @{term+})" . ("7l" . 580))
    '("functional induction (@{qualid} @{term+}) as @{disj_conj_intro_pattern} using @{term} with @{bindings_list}" . ("7l" . 583))
    '("discriminate" . ("7m" . 591))
    '("discriminate @{term}" . ("7m" . 584))
    '("discriminate @{num}" . ("7m" . 587))
    '("discriminate @{term} with @{bindings_list}" . ("7m" . 588))
    '("ediscriminate @{num}" . ("7m" . 589))
    '("ediscriminate @{term}" . ("7m" . 590))
    '("ediscriminate @{term} with @{bindings_list}" . ("7m" . 590))
    '("injection" . ("7o" . 601))
    '("injection @{term}" . ("7o" . 593))
    '("injection @{num}" . ("7o" . 597))
    '("injection @{term} with @{bindings_list}" . ("7o" . 598))
    '("einjection @{num}" . ("7o" . 599))
    '("einjection @{term}" . ("7o" . 600))
    '("einjection @{term} with @{bindings_list}" . ("7o" . 600))
    '("injection @{term} as @{intro_pattern+}" . ("7o" . 603))
    '("injection @{term} with @{bindings_list} as @{intro_pattern+}" . ("7o" . 603))
    '("injection @{num} as @{intro_pattern+}" . ("7o" . 604))
    '("injection as @{intro_pattern+}" . ("7o" . 605))
    '("einjection @{term} as @{intro_pattern+}" . ("7o" . 606))
    '("einjection @{term} with @{bindings_list} as @{intro_pattern+}" . ("7o" . 606))
    '("einjection @{num} as @{intro_pattern+}" . ("7o" . 607))
    '("einjection as @{intro_pattern+}" . ("7o" . 608))
    '("inversion @{ident}" . ("7p" . 609))
    '("inversion @{num}" . ("7p" . 610))
    '("inversion_clear @{ident}" . ("7p" . 611))
    '("inversion @{ident} as @{intro_pattern}" . ("7p" . 612))
    '("inversion @{num} as @{intro_pattern}" . ("7p" . 613))
    '("inversion_clear @{ident} as @{intro_pattern}" . ("7p" . 614))
    '("inversion @{ident} in @{ident+}" . ("7p" . 615))
    '("inversion @{ident} as @{intro_pattern} in @{ident+}" . ("7p" . 616))
    '("inversion_clear @{ident} in @{ident+}" . ("7p" . 617))
    '("inversion_clear @{ident} as @{intro_pattern} in @{ident+}" . ("7p" . 618))
    '("dependent inversion @{ident}" . ("7p" . 619))
    '("dependent inversion @{ident} as @{intro_pattern}" . ("7p" . 620))
    '("dependent inversion_clear @{ident}" . ("7p" . 621))
    '("dependent inversion_clear @{ident} as @{intro_pattern}" . ("7p" . 622))
    '("dependent inversion @{ident} with @{term}" . ("7p" . 623))
    '("dependent inversion @{ident} as @{intro_pattern} with @{term}" . ("7p" . 624))
    '("dependent inversion_clear @{ident} with @{term}" . ("7p" . 626))
    '("dependent inversion_clear @{ident} as @{intro_pattern} with @{term}" . ("7p" . 627))
    '("simple inversion @{ident}" . ("7p" . 628))
    '("simple inversion @{ident} as @{intro_pattern}" . ("7p" . 629))
    '("inversion @{ident} using @{ident'}" . ("7p" . 630))
    '("inversion @{ident} using @{ident'} in @{ident+}" . ("7p" . 631))
    '("fix @{ident} @{num}" . ("7q" . 632))
    '("fix @{ident} @{num} with (@{ident&} @{binder+&} : @{type&})" . ("7q" . 633))
    '("fix @{ident} @{num} with (@{ident&} @{binder+&} {struct @{ident'&}} : @{type&})" . ("7q" . 633))
    '("cofix @{ident}" . ("7r" . 634))
    '("cofix @{ident} with (@{ident&} @{binder+&} : @{type&})" . ("7r" . 635))
    '("rewrite @{term}" . ("7t" . 636))
    '("rewrite -> @{term}" . ("7t" . 639))
    '("rewrite <- @{term}" . ("7t" . 640))
    '("rewrite @{term} in @{clause}" . ("7t" . 641))
    '("rewrite @{term} at @{occurrences}" . ("7t" . 642))
    '("rewrite @{term} by @{tactic}" . ("7t" . 643))
    '("rewrite @{term,+}" . ("7t" . 644))
    '("erewrite @{term}" . ("7t" . 645))
    '("replace @{term} with @{term}" . ("7u" . 646))
    '("replace @{term} with @{term} by @{tactic}" . ("7u" . 648))
    '("replace @{term}" . ("7u" . 649))
    '("replace -> @{term}" . ("7u" . 650))
    '("replace <- @{term}" . ("7u" . 651))
    '("replace @{term} with @{term} in @{clause}" . ("7u" . 652))
    '("replace @{term} with @{term} in @{clause} by @{tactic}" . ("7u" . 653))
    '("replace @{term} in @{clause}" . ("7u" . 654))
    '("replace -> @{term} in @{clause}" . ("7u" . 655))
    '("replace <- @{term} in @{clause}" . ("7u" . 656))
    '("cutrewrite <- (@{term} = @{term})" . ("7u" . 657))
    '("cutrewrite -> (@{term} = @{term})" . ("7u" . 658))
    '("subst @{ident}" . ("7v" . 659))
    '("subst @{ident+}" . ("7v" . 660))
    '("stepl @{term}" . ("7w" . 661))
    '("stepl @{term} by @{tactic}" . ("7w" . 662))
    '("stepr @{term}" . ("7w" . 663))
    '("stepr @{term} by @{tactic}" . ("7w" . 664))
    '("change @{term}" . ("7x" . 666))
    '("change @{term} with @{term}" . ("7x" . 668))
    '("change @{term} at @{num+} with @{term}" . ("7x" . 669))
    '("change @{term} in @{ident}" . ("7x" . 670))
    '("change @{term} with @{term} in @{ident}" . ("7x" . 671))
    '("change @{term} at @{num+} with @{term} in @{ident}" . ("7x" . 672))
    '("compute" . ("7z" . 675))
    '("cbv" . ("7z" . 677))
    '("lazy" . ("7z" . 678))
    '("vm_compute" . ("7z" . 685))
    '("native_compute" . ("7z" . 686))
    '("cbv @{flag+}" . ("7z" . 673))
    '("lazy @{flag+}" . ("7z" . 674))
    '("compute [@{qualid+}]" . ("7z" . 679))
    '("cbv [@{qualid+}]" . ("7z" . 680))
    '("compute -[@{qualid+}]" . ("7z" . 681))
    '("cbv -[@{qualid+}]" . ("7z" . 682))
    '("lazy [@{qualid+}]" . ("7z" . 683))
    '("lazy -[@{qualid+}]" . ("7z" . 684))
    '("red" . ("80" . 687))
    '("hnf" . ("81" . 689))
    '("cbn" . ("82" . 690))
    '("simpl" . ("82" . 691))
    '("cbn [@{qualid+}]" . ("82" . 696))
    '("cbn -[@{qualid+}]" . ("82" . 697))
    '("simpl @{pattern}" . ("82" . 698))
    '("simpl @{pattern} at @{num+}" . ("82" . 699))
    '("simpl @{qualid}" . ("82" . 700))
    '("simpl @{string}" . ("82" . 701))
    '("simpl @{qualid} at @{num+}" . ("82" . 702))
    '("simpl @{string} at @{num+}" . ("82" . 703))
    '("unfold @{qualid}" . ("83" . 704))
    '("unfold @{qualid,+}" . ("83" . 706))
    '("unfold @{qualid,&} at @{num,+,&}" . ("83" . 707))
    '("unfold @{string}" . ("83" . 708))
    '("unfold @{string}%@{key}" . ("83" . 709))
    '("unfold @{qualid_or_string,&} at @{num,+,&}" . ("83" . 710))
    '("fold" . ("84" . 712))
    '("fold @{term}" . ("84" . 711))
    '("pattern" . ("85" . 718))
    '("pattern @{term}" . ("85" . 713))
    '("pattern @{term} at @{num+}" . ("85" . 714))
    '("pattern @{term} at - @{num+}" . ("85" . 715))
    '("pattern @{term,+}" . ("85" . 716))
    '("pattern @{term,&} at @{num+,&}" . ("85" . 717))
    '("auto" . ("88" . 720))
    '("auto with *" . ("88" . 723))
    '("trivial" . ("88" . 726))
    '("trivial with *" . ("88" . 728))
    '("auto @{num}" . ("88" . 721))
    '("auto with @{ident+}" . ("88" . 722))
    '("auto using @{lemma,+}" . ("88" . 724))
    '("auto using @{lemma,+} with @{ident+}" . ("88" . 725))
    '("trivial with @{ident+}" . ("88" . 727))
    '("eauto" . ("89" . 729))
    '("autounfold with *" . ("8a" . 732))
    '("autounfold with @{ident+}" . ("8a" . 730))
    '("autounfold with @{ident+} in @{clause}" . ("8a" . 731))
    '("autorewrite with @{ident+}" . ("8b" . 733))
    '("autorewrite with @{ident+} using @{tactic}" . ("8b" . 734))
    '("autorewrite with @{ident+} in @{qualid}" . ("8b" . 735))
    '("autorewrite with @{ident+} in @{qualid} using @{tactic}" . ("8b" . 736))
    '("autorewrite with @{ident+} in @{clause}" . ("8b" . 737))
    '("tauto" . ("8m" . 778))
    '("intuition" . ("8n" . 781))
    '("dintuition" . ("8n" . 782))
    '("intuition @{tactic}" . ("8n" . 780))
    '("rtauto" . ("8o" . 787))
    '("firstorder" . ("8p" . 788))
    '("firstorder @{tactic}" . ("8p" . 791))
    '("firstorder with @{ident+}" . ("8p" . 792))
    '("firstorder using @{qualid,+}" . ("8p" . 793))
    '("firstorder using @{qualid,+} with @{ident+}" . ("8p" . 794))
    '("congruence" . ("8q" . 796))
    '("congruence @{n}" . ("8q" . 797))
    '("congruence with @{term+}" . ("8q" . 798))
    '("constr_eq @{term} @{term}" . ("8s" . 801))
    '("unify @{term} @{term}" . ("8t" . 803))
    '("unify @{term} @{term} with @{ident}" . ("8t" . 805))
    '("is_evar @{term}" . ("8u" . 806))
    '("has_evar @{term}" . ("8v" . 808))
    '("is_var @{term}" . ("8w" . 810))
    '("f_equal" . ("8y" . 812))
    '("reflexivity" . ("8z" . 813))
    '("symmetry" . ("90" . 816))
    '("symmetry in @{ident}" . ("90" . 817))
    '("transitivity @{term}" . ("91" . 818))
    '("decide equality" . ("93" . 819))
    '("compare @{term} @{term}" . ("94" . 820))
    '("simplify_eq" . ("95" . 823))
    '("simplify_eq @{term}" . ("95" . 821))
    '("simplify_eq @{num}" . ("95" . 822))
    '("esimplify_eq @{num}" . ("95" . 824))
    '("esimplify_eq @{term}" . ("95" . 825))
    '("esimplify_eq @{term} with @{bindings_list}" . ("95" . 825))
    '("dependent rewrite -> @{ident}" . ("96" . 827))
    '("dependent rewrite <- @{ident}" . ("96" . 828))
    '("functional inversion @{ident}" . ("98" . 829))
    '("functional inversion @{num}" . ("98" . 832))
    '("functional inversion @{ident} @{qualid}" . ("98" . 833))
    '("quote @{ident}" . ("99" . 834))
    '("quote @{ident} [@{ident+}]" . ("99" . 836))
    '("classical_left" . ("9b" . 837))
    '("classical_right" . ("9b" . 838))
    '("btauto" . ("9d" . 839))
    '("omega" . ("9e" . 840))
    '("ring" . ("9f" . 841))
    '("ring_simplify @{term+}" . ("9f" . 842))
    '("field" . ("9g" . 844))
    '("field_simplify_eq" . ("9g" . 846))
    '("field_simplify @{term+}" . ("9g" . 845))
    '("fourier" . ("9h" . 848))
    '("cycle @{num}" . ("9j" . 849))
    '("swap @{num} @{num}" . ("9k" . 850))
    '("revgoals" . ("9l" . 851))
    '("shelve" . ("9m" . 852))
    '("shelve_unifiable" . ("9m" . 853))
    '("give_up" . ("9o" . 855))
    '("idtac" . ("9t" . 868))
    '("fail" . ("9t" . 870))
    '("gfail" . ("9t" . 874))
    '("idtac @{message_token+}" . ("9t" . 869))
    '("fail @{n}" . ("9t" . 871))
    '("fail @{message_token+}" . ("9t" . 872))
    '("fail @{n} @{message_token+}" . ("9t" . 873))
    '("gfail @{message_token+}" . ("9t" . 875))
    '("gfail @{n} @{message_token+}" . ("9t" . 876))
    '("specialize_eqs" . ("a2" . 909))
    '("quote @{ident} in @{term} using @{tactic}" . ("a6" . 911))
    '("quote @{ident} [@{ident+}] in @{term} using @{tactic}" . ("a6" . 912))
    '("psatz" . ("ev" . 1021))
    '("lra" . ("ey" . 1022))
    '("lia" . ("f2" . 1023))
    '("nia" . ("f5" . 1024))
    '("ring_simplify" . ("fx" . 1071))
    '("ring [@{term+}]" . ("fx" . 1072))
    '("ring_simplify [@{term+}] @{t+} in @{ident}" . ("fx" . 1073))
    '("field_simplify" . ("g0" . 1084))
    '("field [@{term+}]" . ("g0" . 1083))
    '("field_simplify [@{term+}]" . ("g0" . 1085))
    '("field_simplify [@{term+}] @{term+}" . ("g0" . 1086))
    '("field_simplify in @{hyp}" . ("g0" . 1087))
    '("field_simplify [@{term+}] in @{hyp}" . ("g0" . 1088))
    '("field_simplify [@{term+}] @{term+} in @{hyp}" . ("g0" . 1089))
    '("field_simplify_eq [@{term+}]" . ("g0" . 1091))
    '("field_simplify_eq in @{hyp}" . ("g0" . 1092))
    '("field_simplify_eq [@{term+}] in @{hyp}" . ("g0" . 1093))
    '("nsatz" . ("g6" . 1095))
    '("nsatz with radicalmax:=@{num}%N strategy:=@{num}%Z parameters:=@{list of vars} variables:=@{list of vars}" . ("g6" . 1096))
    '("setoid_reflexivity" . ("gi" . 1097))
    '("setoid_symmetry" . ("gi" . 1098))
    '("setoid_transitivity" . ("gi" . 1099))
    '("setoid_symmetry in @{ident}" . ("gi" . 1098))
    '("setoid_rewrite @{term}" . ("gi" . 1100))
    '("setoid_rewrite @{term} in @{ident}" . ("gi" . 1100))
    '("setoid_rewrite <- @{term}" . ("gi" . 1101))
    '("setoid_rewrite <- @{term} in @{ident}" . ("gi" . 1101))
    '("setoid_rewrite <- @{term} at @{occs}" . ("gi" . 1102))
    '("setoid_rewrite <- @{term} at @{occs} in @{ident}" . ("gi" . 1102))
    '("setoid_rewrite @{term} at @{occs}" . ("gi" . 1103))
    '("setoid_rewrite @{term} at @{occs} in @{ident}" . ("gi" . 1103))
    '("setoid_rewrite @{orientation} @{term}" . ("gi" . 1103))
    '("setoid_rewrite @{orientation} @{term} in @{ident}" . ("gi" . 1103))
    '("setoid_rewrite @{orientation} @{term} at @{occs}" . ("gi" . 1103))
    '("setoid_rewrite @{orientation} @{term} at @{occs} in @{ident}" . ("gi" . 1103))
    '("setoid_replace @{term} with @{term}" . ("gi" . 1104))
    '("setoid_replace @{term} with @{term} by @{tactic}" . ("gi" . 1105))
    '("setoid_replace @{term} with @{term} using relation @{term}" . ("gi" . 1105))
    '("setoid_replace @{term} with @{term} using relation @{term} by @{tactic}" . ("gi" . 1105))
    '("setoid_replace @{term} with @{term} in @{ident}" . ("gi" . 1105))
    '("setoid_replace @{term} with @{term} in @{ident} by @{tactic}" . ("gi" . 1105))
    '("setoid_replace @{term} with @{term} in @{ident} using relation @{term}" . ("gi" . 1105))
    '("setoid_replace @{term} with @{term} in @{ident} using relation @{term} by @{tactic}" . ("gi" . 1105))
    '("rewrite_strat @{s}" . ("gr" . 1108))
    '("rewrite_strat @{s} in @{ident}" . ("gr" . 1108))))

(defconst company-coq--refman-vernac-abbrevs
  (list
    '("Abort." . ("5x" . 335))
    '("Abort @{ident}." . ("5x" . 337))
    '("Abort All." . ("5x" . 338))
    '("About @{qualid}." . ("3p" . 171))
    '("Add Field @{name} : @{field} (@{mod,+})." . ("g1" . 1094))
    '("Add LoadPath \"@{string}\"." . ("4l" . 257))
    '("Add LoadPath \"@{string}\" as @{dirpath}." . ("4l" . 256))
    '("Add ML Path \"@{string}\"." . ("4p" . 263))
    '("Add Printing Coercion @{qualid}." . ("ds" . 997))
    '("Add Printing Constructor @{ident}." . ("16" . 44))
    '("Add Printing If @{ident}." . ("1c" . 63))
    '("Add Printing Let @{ident}." . ("1c" . 59))
    '("Add Printing Record @{ident}." . ("16" . 43))
    '("Add Rec LoadPath \"@{string}\"." . ("4m" . 259))
    '("Add Rec LoadPath \"@{string}\" as @{dirpath}." . ("4m" . 258))
    '("Add Rec ML Path \"@{string}\"." . ("4q" . 264))
    '("Add Ring @{name} : @{ring} (@{mod,+})." . ("fy" . 1078))
    '("Add Search Blacklist \"@{string}\"." . ("49" . 225))
    '("Admit Obligations." . ("fp" . 1065))
    '("Admit Obligations of @{ident}." . ("fp" . 1065))
    '("Admitted." . ("5u" . 318))
    '("Arguments @{qualid} @{possibly_bracketed_ident+}." . ("1p" . 78))
    '("Arguments @{ident} !@{arg+}." . ("82" . 694))
    '("Arguments @{ident} @{possibly_bracketed_ident+} / @{possibly_bracketed_ident+}." . ("82" . 693))
    '("Arguments @{qualid} @{name&} %@{scope&}." . ("bk" . 927))
    '("Arguments @{qualid} : clear implicits." . ("1p" . 79))
    '("Arguments @{qualid} : clear scopes." . ("bk" . 928))
    '("Arguments @{qualid} : default implicits." . ("1q" . 82))
    '("Arguments @{qualid} @{name+} : rename." . ("1x" . 97))
    '("Arguments @{ident} @{possibly_bracketed_ident+} : simpl never." . ("82" . 692))
    '("Arguments @{ident} @{possibly_bracketed_ident+} : simpl nomatch." . ("82" . 695))
    '("Axiom @{ident} : @{term}." . ("10" . 2))
    '("Back." . ("4w" . 270))
    '("Back @{n}." . ("4w" . 271))
    '("BackTo @{num}." . ("4x" . 273))
    '("Backtrack @{num} @{num} @{num}." . ("4x" . 274))
    '("Bind Scope @{scope} with @{qualid}." . ("bk" . 931))
    '("Canonical Structure @{qualid}." . ("22" . 105))
    '("Canonical Structure @{ident}." . ("22" . 109))
    '("Canonical Structure @{ident} := @{term}." . ("22" . 107))
    '("Canonical Structure @{ident} := @{term} : @{type}." . ("22" . 106))
    '("Canonical Structure @{ident} : @{type} := @{term}." . ("22" . 108))
    '("Cd." . ("4k" . 255))
    '("Cd \"@{string}\"." . ("4k" . 254))
    '("Check @{term}." . ("41" . 192))
    '("@{selector}: Check @{term}." . ("41" . 193))
    '("Class @{ident} @{binder+} : @{sort}:= {@{field;+}}." . ("eb" . 998))
    '("Class @{ident} @{binder+} : @{sort}:= @{ident} : @{type}." . ("eb" . 999))
    '("Close Scope @{scope}." . ("bj" . 920))
    '("Coercion @{qualid} : @{class} >-> @{class}." . ("25" . 117))
    '("Coercion @{ident} := @{term}." . ("dj" . 983))
    '("Coercion @{ident} := @{term} : @{type}." . ("dj" . 984))
    '("Collection @{ident}:= @{ident+}." . ("5w" . 334))
    '("Combined Scheme @{ident} from @{ident}, .., @{ident}." . ("bv" . 965))
    '("Compute @{term}." . ("43" . 195))
    '("Conjecture @{ident} : @{term}." . ("10" . 7))
    '("Constraint @{ident} @{ord} @{ident}." . ("h7" . 1117))
    '("Context @{binder+}." . ("ee" . 1008))
    '("Corollary @{ident} : @{type}." . ("14" . 34))
    '("Corollary @{ident} @{binders} : @{type}." . ("14" . 34))
    '("Create HintDb @{ident}." . ("8e" . 738))
    '("Create HintDb @{ident} discriminated." . ("8e" . 738))
    '("Declare Implicit Tactic @{tactic}." . ("8k" . 779))
    '("Declare Instance." . ("ec" . 1005))
    '("Declare ML Module \"@{string}\" .. \"@{string}\"." . ("4g" . 248))
    '("Declare Module @{ident} : @{module_type}." . ("2c" . 167))
    '("Declare Module @{ident} @{module_bindings} : @{module_type}." . ("2c" . 168))
    '("Declare Reduction @{ident} := @{convtactic}." . ("5n" . 302))
    '("Declare Right Step @{term}." . ("7w" . 665))
    '("Defined." . ("5t" . 309))
    '("Definition @{ident} := @{term}." . ("11" . 11))
    '("Definition @{ident} @{binder+}." . ("11" . 14))
    '("Definition @{ident} : @{term} := @{term}." . ("11" . 13))
    '("Definition @{ident} : @{type}." . ("14" . 36))
    '("Definition @{ident} @{binders} : @{type}." . ("14" . 36))
    '("Delimit Scope @{scope} with @{ident}." . ("bk" . 925))
    '("Derive Dependent Inversion_clear @{ident} with forall @{ident&}: @{type&}, @{I} @{arg+} Sort @{sort}." . ("bx" . 970))
    '("Derive Dependent Inversion @{ident} with forall @{ident&}: @{type&}, @{I} @{arg+} Sort @{sort}." . ("bx" . 969))
    '("Derive Inversion_clear @{ident} with forall @{ident&}: @{type&}, @{I} @{arg+} Sort @{sort}." . ("bx" . 968))
    '("Derive Inversion @{ident} with forall @{ident&}: @{type&}, @{I} @{arg+} Sort @{sort}." . ("bx" . 967))
    '("Derive @{ident} SuchThat @{term} As @{ident}." . ("hc" . 1121))
    '("Drop." . ("50" . 277))
    '("dtauto." . ("8m" . 779))
    '("End @{ident}." . ("1g" . 75))
    '("Eval @{convtactic} in @{term}." . ("42" . 194))
    '("Example @{ident} := @{term}." . ("11" . 16))
    '("Existential @{num} := @{term}." . ("5y" . 339))
    '("Existing Class @{ident}." . ("eb" . 1000))
    '("Existing Instance @{ident}." . ("ed" . 1006))
    '("Existing Instance @{ident} @{priority}." . ("ed" . 1006))
    '("Existing Instances @{ident+}." . ("ed" . 1007))
    '("Existing Instances @{ident+} @{priority}." . ("ed" . 1007))
    '("Export @{qualid}." . ("2c" . 170))
    '("Extract Constant @{qualid} => \"@{string}\"." . ("fc" . 1043))
    '("Extract Constant @{qualid} \"@{string+}\" => \"@{string}\"." . ("fc" . 1045))
    '("Extract Inductive @{qualid} => \"@{string}\" [\"@{string+}\"] @{optstring}." . ("fc" . 1046))
    '("Extract Inlined Constant @{qualid} => \"@{string}\"." . ("fc" . 1044))
    '("Extraction @{term}." . ("44" . 196))
    '("Extraction @{qualid}." . ("f7" . 1025))
    '("Extraction \"@{file}\" @{qualid+}." . ("f7" . 1027))
    '("Extraction Blacklist @{ident+}." . ("fd" . 1047))
    '("Extraction Implicit @{qualid} [@{ident+}]." . ("fb" . 1041))
    '("Extraction Language Haskell." . ("f9" . 1032))
    '("Extraction Language Ocaml." . ("f9" . 1031))
    '("Extraction Language Scheme." . ("f9" . 1033))
    '("Extraction Library @{ident}." . ("f7" . 1028))
    '("Fact @{ident} : @{type}." . ("14" . 33))
    '("Fact @{ident} @{binders} : @{type}." . ("14" . 33))
    '("Fixpoint @{ident} @{params} {struct @{ident}} : type := @{term}." . ("13" . 26))
    '("Focus." . ("63" . 345))
    '("Focus @{num}." . ("63" . 346))
    '("From @{dirpath} Require @{qualid}." . ("4e" . 240))
    '("Functional Scheme @{ident} := Induction for @{ident'} Sort @{sort}." . ("bw" . 966))
    '("Function @{ident} @{binder+} {decrease_annot} : type := @{term}." . ("1d" . 67))
    '("Generalizable All Variables." . ("24" . 112))
    '("Generalizable No Variables." . ("24" . 113))
    '("Generalizable Variable @{ident}." . ("24" . 114))
    '("Generalizable Variables @{ident+}." . ("24" . 115))
    '("Global @{command}." . ("5p" . 304))
    '("Global Arguments @{qualid} @{possibly_bracketed_ident+}." . ("1p" . 80))
    '("Global Arguments @{qualid} @{name&} %@{scope&}." . ("bk" . 929))
    '("Global Arguments @{qualid} : default implicits." . ("1q" . 83))
    '("Global Close Scope @{scope}." . ("bj" . 924))
    '("Global Generalizable All Variables." . ("24" . 116))
    '("Global Instance." . ("ec" . 1003))
    '("Global Obligation Tactic := @{expr}." . ("fp" . 1058))
    '("Global Opaque @{qualid+}." . ("5j" . 295))
    '("Global Open Scope @{scope}." . ("bj" . 923))
    '("Global Set @{flag}." . ("3s" . 177))
    '("Global Set @{option} @{value}." . ("3v" . 184))
    '("Global Unset @{flag}." . ("3t" . 180))
    '("Global Unset @{option}." . ("3w" . 187))
    '("Goal @{form}." . ("5s" . 306))
    '("Grab Existential Variables." . ("5z" . 340))
    '("Guarded." . ("6a" . 366))
    '("Hint @{hint_definition}." . ("8e" . 740))
    '("Hint @{hint_definition} : @{ident+}." . ("8e" . 739))
    '("Hint Constructors @{ident}." . ("8e" . 749))
    '("Hint Constructors @{ident+}." . ("8e" . 751))
    '("Hint Constructors @{ident} : @{ident+}." . ("8e" . 749))
    '("Hint Constructors @{ident+} : @{ident+}." . ("8e" . 751))
    '("Hint Cut @{regexp}." . ("8e" . 757))
    '("Hint Cut @{regexp} : @{ident+}." . ("8e" . 757))
    '("Hint Extern @{num} => @{tactic}." . ("8e" . 756))
    '("Hint Extern @{num} => @{tactic} : @{ident+}." . ("8e" . 756))
    '("Hint Extern @{num} @{pattern} => @{tactic}." . ("8e" . 756))
    '("Hint Extern @{num} @{pattern} => @{tactic} : @{ident+}." . ("8e" . 756))
    '("Hint Immediate @{term}." . ("8e" . 746))
    '("Hint Immediate @{term+}." . ("8e" . 748))
    '("Hint Immediate @{term} : @{ident+}." . ("8e" . 746))
    '("Hint Immediate @{term+} : @{ident+}." . ("8e" . 748))
    '("Hint Local @{hint_definition}." . ("8e" . 760))
    '("Hint Local @{hint_definition} : @{ident+}." . ("8e" . 759))
    '("Hint Resolve @{term}." . ("8e" . 743))
    '("Hint Resolve @{term+}." . ("8e" . 745))
    '("Hint Resolve @{term} : @{ident+}." . ("8e" . 743))
    '("Hint Resolve @{term+} : @{ident+}." . ("8e" . 745))
    '("Hint Rewrite @{term+} : @{ident+}." . ("8i" . 766))
    '("Hint Rewrite -> @{term+} : @{ident+}." . ("8i" . 767))
    '("Hint Rewrite <- @{term+} : @{ident+}." . ("8i" . 768))
    '("Hint Rewrite @{term+} using @{tactic} : @{ident+}." . ("8i" . 769))
    '("Hint Unfold @{qualid}." . ("8e" . 752))
    '("Hint Unfold @{ident+}." . ("8e" . 753))
    '("Hint Unfold @{qualid} : @{ident+}." . ("8e" . 752))
    '("Hint Unfold @{ident+} : @{ident+}." . ("8e" . 753))
    '("Identity Coercion @{ident}:@{class} >-> @{class}." . ("dk" . 986))
    '("Implicit Type @{ident} : @{type}." . ("23" . 111))
    '("Implicit Types @{ident+} : @{type}." . ("23" . 110))
    '("Import @{qualid}." . ("2c" . 169))
    '("Include @{module}." . ("2c" . 144))
    '("Include @{module<++}." . ("2c" . 145))
    '("Inductive @{ident} @{binder+} : @{term} := @{ident|&}: @{term|&}." . ("12" . 23))
    '("Infix \"@{symbol}\" := @{qualid} (@{modifier,+})." . ("b9" . 915))
    '("Info @{num} @{expr}." . ("9y" . 904))
    '("@{assumption_keyword} Inline @{assums}." . ("2c" . 161))
    '("Inspect @{num}." . ("3q" . 173))
    '("Instance @{ident} @{binder+} : Class @{term+} := {@{field;&} := @{b;&}}." . ("ec" . 1001))
    '("Instance @{ident} @{binder+} : Class @{term+} @{priority} := {@{field;&} := @{b;&}}." . ("ec" . 1001))
    '("Instance @{ident} @{binder+} : forall @{binder+}, Class @{term+} := @{term}." . ("ec" . 1002))
    '("Instance @{ident} @{binder+} : forall @{binder+}, Class @{term+} @{priority} := @{term}." . ("ec" . 1002))
    '("Lemma @{ident} : @{type}." . ("14" . 31))
    '("Lemma @{ident} @{binders} : @{type}." . ("14" . 31))
    '("Let @{ident} := @{term}." . ("11" . 18))
    '("Let @{ident} : @{term} := @{term}." . ("11" . 20))
    '("Let @{ident} : @{type}." . ("14" . 37))
    '("Let @{ident} @{binders} : @{type}." . ("14" . 37))
    '("Let CoFixpoint @{ident} @{cofix_bodywith+}." . ("11" . 22))
    '("Let Fixpoint @{ident} @{fix_bodywith+}." . ("11" . 21))
    '("Load @{ident}." . ("4c" . 231))
    '("Load \"@{string}\"." . ("4c" . 232))
    '("Load Verbose @{ident}." . ("4c" . 233))
    '("Load Verbose \"@{string}\"." . ("4c" . 234))
    '("Local @{command}." . ("5p" . 303))
    '("Local Arguments @{qualid} @{possibly_bracketed_ident+}." . ("1p" . 81))
    '("Local Arguments @{qualid} @{name&} %@{scope&}." . ("bk" . 930))
    '("Local Arguments @{qualid} : default implicits." . ("1q" . 84))
    '("Local Axiom @{ident} : @{term}." . ("10" . 6))
    '("Local Close Scope @{scope}." . ("bj" . 922))
    '("Local Coercion @{ident} := @{term}." . ("dj" . 985))
    '("Local Coercion @{qualid} : @{class} >-> @{class}." . ("dj" . 982))
    '("Local Declare ML Module \"@{string+}\"." . ("4g" . 249))
    '("Local Definition @{ident} := @{term}." . ("11" . 15))
    '("Local Hint @{hint_definition}." . ("8e" . 742))
    '("Local Hint @{hint_definition} : @{ident+}." . ("8e" . 741))
    '("Local Hint Constructors @{ident}." . ("8e" . 749))
    '("Local Hint Constructors @{ident+}." . ("8e" . 751))
    '("Local Hint Constructors @{ident} : @{ident+}." . ("8e" . 749))
    '("Local Hint Constructors @{ident+} : @{ident+}." . ("8e" . 751))
    '("Local Hint Cut @{regexp}." . ("8e" . 757))
    '("Local Hint Cut @{regexp} : @{ident+}." . ("8e" . 757))
    '("Local Hint Extern @{num} => @{tactic}." . ("8e" . 756))
    '("Local Hint Extern @{num} => @{tactic} : @{ident+}." . ("8e" . 756))
    '("Local Hint Extern @{num} @{pattern} => @{tactic}." . ("8e" . 756))
    '("Local Hint Extern @{num} @{pattern} => @{tactic} : @{ident+}." . ("8e" . 756))
    '("Local Hint Immediate @{term}." . ("8e" . 746))
    '("Local Hint Immediate @{term+}." . ("8e" . 748))
    '("Local Hint Immediate @{term} : @{ident+}." . ("8e" . 746))
    '("Local Hint Immediate @{term+} : @{ident+}." . ("8e" . 748))
    '("Local Hint Resolve @{term}." . ("8e" . 743))
    '("Local Hint Resolve @{term+}." . ("8e" . 745))
    '("Local Hint Resolve @{term} : @{ident+}." . ("8e" . 743))
    '("Local Hint Resolve @{term+} : @{ident+}." . ("8e" . 745))
    '("Local Hint Unfold @{qualid}." . ("8e" . 752))
    '("Local Hint Unfold @{ident+}." . ("8e" . 753))
    '("Local Hint Unfold @{qualid} : @{ident+}." . ("8e" . 752))
    '("Local Hint Unfold @{ident+} : @{ident+}." . ("8e" . 753))
    '("Local Identity Coercion @{ident}:@{ident} >-> @{ident}." . ("dk" . 988))
    '("Local Notation @{ident} := @{term}." . ("bo" . 951))
    '("Local Notation @{ident} @{ident&} @{ident&} := @{term}." . ("bo" . 951))
    '("Local Notation @{ident} := @{term} (only parsing)." . ("bo" . 951))
    '("Local Notation @{ident} @{ident&} @{ident&} := @{term} (only parsing)." . ("bo" . 951))
    '("Local Obligation Tactic := @{expr}." . ("fp" . 1057))
    '("Local Open Scope @{scope}." . ("bj" . 921))
    '("Local Set @{flag}." . ("3s" . 176))
    '("Local Set @{option} @{value}." . ("3v" . 183))
    '("Local SubClass @{ident} := @{type}." . ("dk" . 990))
    '("Local Unset @{flag}." . ("3t" . 179))
    '("Local Unset @{option}." . ("3w" . 186))
    '("Locate @{qualid}." . ("4a" . 227))
    '("Locate \"@{symbol}\"." . ("bd" . 918))
    '("Locate File \"@{string}\"." . ("4s" . 266))
    '("Locate Library @{dirpath}." . ("4t" . 267))
    '("Locate Ltac @{qualid}." . ("4a" . 230))
    '("Locate Module @{qualid}." . ("2c" . 174))
    '("Locate Term @{qualid}." . ("4a" . 228))
    '("Module @{ident}." . ("2c" . 127))
    '("Module @{ident} @{module_bindings}." . ("2c" . 138))
    '("Module @{ident} : @{module_type}." . ("2c" . 139))
    '("Module @{ident} <: @{module_type<:+}." . ("2c" . 141))
    '("Module @{ident} := @{module_expression}." . ("2c" . 152))
    '("Module @{ident} @{module_bindings} : @{module_type}." . ("2c" . 140))
    '("Module @{ident} @{module_bindings} <: @{module_type<:+}." . ("2c" . 142))
    '("Module @{ident} @{module_bindings} := @{module_expression}." . ("2c" . 153))
    '("Module @{ident} @{module_bindings} := @{module_expression<++}." . ("2c" . 156))
    '("Module @{ident} @{module_bindings} : @{module_type} := @{module_expression}." . ("2c" . 154))
    '("Module @{ident} @{module_bindings} <: @{module_type<:+}:= @{module_expression}." . ("2c" . 155))
    '("Module Type @{ident}." . ("2c" . 157))
    '("Module Type @{ident} @{module_bindings}." . ("2c" . 158))
    '("Module Type @{ident} := @{module_type}." . ("2c" . 164))
    '("Module Type @{ident} @{module_bindings} := @{module_type}." . ("2c" . 165))
    '("Module Type @{ident} @{module_bindings} := @{module_type<++}." . ("2c" . 166))
    '("Monomorphic @{definition}." . ("h1" . 1115))
    '("Next Obligation." . ("fp" . 1062))
    '("Next Obligation of @{ident}." . ("fp" . 1062))
    '("Notation @{ident} := @{term}." . ("bo" . 951))
    '("Notation @{ident} @{ident&} @{ident&} := @{term}." . ("bo" . 951))
    '("Notation @{ident} := @{term} (only parsing)." . ("bo" . 951))
    '("Notation @{ident} @{ident&} @{ident&} := @{term} (only parsing)." . ("bo" . 951))
    '("Obligation @{num}." . ("fp" . 1061))
    '("Obligation @{num} of @{ident}." . ("fp" . 1061))
    '("Obligations." . ("fp" . 1060))
    '("Obligations of @{ident}." . ("fp" . 1060))
    '("Opaque @{qualid+}." . ("5j" . 294))
    '("Open Scope @{scope}." . ("bj" . 919))
    '("Optimize Heap." . ("6h" . 372))
    '("Optimize Proof." . ("6g" . 371))
    '("Parameter @{ident} : @{term}." . ("10" . 4))
    '("Parameter @{ident+} : @{term}." . ("10" . 5))
    '("Polymorphic @{definition}." . ("h1" . 1113))
    '("Preterm." . ("fp" . 1066))
    '("Preterm of @{ident}." . ("fp" . 1066))
    '("Print @{qualid}." . ("3p" . 168))
    '("Print All." . ("3q" . 172))
    '("Print All Dependencies @{qualid}." . ("45" . 201))
    '("Print Assumptions @{qualid}." . ("45" . 198))
    '("Print Canonical Projections." . ("dm" . 12))
    '("Print Canonical Projections @{qualid+}." . ("dm" . 13))
    '("Print Classes." . ("dm" . 991))
    '("Print Coercion Paths @{class} @{class}." . ("dp" . 994))
    '("Print Coercions." . ("dn" . 992))
    '("Print Extraction Blacklist." . ("fd" . 1048))
    '("Print Extraction Inline." . ("fa" . 1039))
    '("Print Fields." . ("9g" . 847))
    '("Print Firstorder Solver." . ("8p" . 790))
    '("Print Grammar constr." . ("b7" . 913))
    '("Print Grammar pattern." . ("b7" . 914))
    '("Print Grammar tactic." . ("bp" . 953))
    '("Print Graph." . ("do" . 993))
    '("Print Hint." . ("8h" . 762))
    '("Print Hint *." . ("8h" . 764))
    '("Print Hint @{ident}." . ("8h" . 763))
    '("Print HintDb @{ident}." . ("8h" . 765))
    '("Print Implicit @{qualid}." . ("1y" . 98))
    '("Print Instances @{typeclass}." . ("gj" . 1107))
    '("Print Libraries." . ("4f" . 247))
    '("Print LoadPath." . ("4o" . 261))
    '("Print LoadPath @{dirpath}." . ("4o" . 262))
    '("Print Ltac @{qualid}." . ("9w" . 903))
    '("Print ML Modules." . ("4h" . 252))
    '("Print ML Path \"@{string}\"." . ("4r" . 265))
    '("Print Module @{ident}." . ("2c" . 172))
    '("Print Module Type @{ident}." . ("2c" . 173))
    '("Print Opaque Dependencies @{qualid}." . ("45" . 199))
    '("Print Options." . ("3z" . 190))
    '("Print Rewrite HintDb @{ident}." . ("8i" . 770))
    '("Print Rings." . ("9f" . 843))
    '("Print Scope @{scope}." . ("bm" . 946))
    '("Print Scopes." . ("bm" . 945))
    '("Print Section @{ident}." . ("3q" . 174))
    '("Print Sorted Universes." . ("27" . 122))
    '("Print Sorted Universes \"@{string}\"." . ("27" . 123))
    '("Print Strategies." . ("5m" . 301))
    '("Print Strategy @{qualid}." . ("5m" . 300))
    '("Print Table @{table}." . ("3y" . 189))
    '("Print Table Printing If." . ("1c" . 66))
    '("Print Table Printing Let." . ("1c" . 62))
    '("Print Tables." . ("3z" . 191))
    '("Print Term @{qualid}." . ("3p" . 170))
    '("Print Transparent Dependencies @{qualid}." . ("45" . 200))
    '("Print Universes." . ("27" . 122))
    '("Print Universes \"@{string}\"." . ("27" . 123))
    '("Print Visibility." . ("bn" . 950))
    '("Print Visibility @{scope}." . ("bn" . 951))
    '("Program Definition @{ident} := @{term}." . ("fm" . 1050))
    '("Program Definition @{ident} : @{term} := @{term}." . ("fm" . 1052))
    '("Program Definition @{ident} @{binder+} : @{term} := @{term}." . ("fm" . 1053))
    '("Program Fixpoint @{ident} @{params} {order} : type := @{term}." . ("fn" . 1055))
    '("Program Instance." . ("ec" . 1004))
    '("Program Lemma @{ident} : type." . ("fo" . 1056))
    '("Proof." . ("5v" . 320))
    '("Proof @{term}." . ("5v" . 319))
    '("Proof using." . ("5w" . 325))
    '("Proof using @{ident+}." . ("5w" . 321))
    '("Proof using -(@{ident+})." . ("5w" . 327))
    '("Proof using @{collection} *." . ("5w" . 331))
    '("Proof using @{collection} + @{collection}." . ("5w" . 328))
    '("Proof using @{collection} - @{collection}." . ("5w" . 329))
    '("Proof using @{collection} - (@{ident+})." . ("5w" . 330))
    '("Proof using All." . ("5w" . 323))
    '("Proof using Type." . ("5w" . 324))
    '("Proof using Type*." . ("5w" . 326))
    '("Proof using @{ident+} with @{tactic}." . ("5w" . 322))
    '("Proof with @{tactic}." . ("8k" . 776))
    '("Proof with @{tactic} using @{ident+}." . ("8k" . 777))
    '("Proposition @{ident} : @{type}." . ("14" . 35))
    '("Proposition @{ident} @{binders} : @{type}." . ("14" . 35))
    '("Pwd." . ("4j" . 253))
    '("Qed." . ("5t" . 307))
    '("Qed exporting." . ("9t" . 898))
    '("Qed exporting @{ident,+}." . ("9t" . 899))
    '("Quit." . ("4z" . 276))
    '("Record @{ident} @{params} : @{sort} := @{ident} {@{ident;&} @{binders;&} : @{term;&}}." . ("16" . 38))
    '("Recursive Extraction @{qualid+}." . ("44" . 197))
    '("Recursive Extraction Library @{ident}." . ("f7" . 1029))
    '("Redirect \"@{file}\" @{command}." . ("52" . 279))
    '("Remark @{ident} : @{type}." . ("14" . 32))
    '("Remark @{ident} @{binders} : @{type}." . ("14" . 32))
    '("Remove Hints @{term+} : @{ident+}." . ("8g" . 761))
    '("Remove LoadPath \"@{string}\"." . ("4n" . 260))
    '("Remove Printing If @{ident}." . ("1c" . 64))
    '("Remove Printing Let @{ident}." . ("1c" . 60))
    '("Remove Search Blacklist \"@{string}\"." . ("49" . 226))
    '("Require @{qualid}." . ("4e" . 236))
    '("Require @{qualid+}." . ("4e" . 239))
    '("Require Export @{qualid}." . ("4e" . 238))
    '("Require Import @{qualid}." . ("4e" . 237))
    '("Reset @{ident}." . ("4v" . 268))
    '("Reset Extraction Blacklist." . ("fd" . 1049))
    '("Reset Extraction Inline." . ("fa" . 1040))
    '("Restart." . ("62" . 343))
    '("Save." . ("5t" . 310))
    '("Save @{ident}." . ("5t" . 311))
    '("Save Corollary @{ident}." . ("5t" . 316))
    '("Save Fact @{ident}." . ("5t" . 315))
    '("Save Lemma @{ident}." . ("5t" . 313))
    '("Save Proposition @{ident}." . ("5t" . 317))
    '("Save Remark @{ident}." . ("5t" . 314))
    '("Save Theorem @{ident}." . ("5t" . 312))
    '("Scheme Equality for @{ident}." . ("bt" . 956))
    '("Scheme Induction for @{ident} Sort @{sort}." . ("bt" . 957))
    '("Scheme @{ident} := Induction for @{ident'} Sort @{sort}." . ("bt" . 954))
    '("Scheme @{ident} := Minimality for @{ident'} Sort @{sort}." . ("bt" . 955))
    '("Search @{qualid}." . ("46" . 202))
    '("Search \"@{string}\"." . ("46" . 204))
    '("Search @{term_pattern}." . ("46" . 206))
    '("Search @{search_term+}." . ("46" . 207))
    '("Search -@{search_term+}." . ("46" . 207))
    '("Search \"@{string}\"%@{key}." . ("46" . 205))
    '("@{selector}: Search @{search_term+}." . ("46" . 210))
    '("@{selector}: Search -@{search_term+}." . ("46" . 210))
    '("SearchAbout @{qualid}." . ("46" . 211))
    '("SearchHead @{term}." . ("47" . 212))
    '("@{selector}: SearchHead @{term}." . ("47" . 216))
    '("SearchHead @{term} inside @{module+}." . ("47" . 213))
    '("SearchHead @{term} outside @{module+}." . ("47" . 214))
    '("Search @{search_term+} inside @{module+}." . ("46" . 208))
    '("Search @{search_term+} outside @{module+}." . ("46" . 209))
    '("SearchPattern @{term}." . ("48" . 217))
    '("@{selector}: SearchPattern @{term}." . ("48" . 220))
    '("SearchPattern @{term} inside @{module+}." . ("48" . 218))
    '("SearchPattern @{term} outside @{module+}." . ("48" . 219))
    '("SearchRewrite @{term}." . ("49" . 221))
    '("@{selector}: SearchRewrite @{term}." . ("49" . 224))
    '("SearchRewrite @{term} inside @{module+}." . ("49" . 222))
    '("SearchRewrite @{term} outside @{module+}." . ("49" . 223))
    '("Section @{ident}." . ("1f" . 74))
    '("Separate Extraction @{qualid+}." . ("f7" . 1030))
    '("Set @{flag}." . ("3s" . 175))
    '("Set @{option} @{value}." . ("3v" . 182))
    '("Set Automatic Introduction." . ("6e" . 369))
    '("Set Boolean Equality Schemes." . ("bu" . 963))
    '("Set Bracketing Last Introduction Pattern." . ("6y" . 452))
    '("Set Bullet Behavior \"None\"." . ("67" . 354))
    '("Set Bullet Behavior \"Strict Subproofs\"." . ("67" . 355))
    '("Set Case Analysis Schemes." . ("bu" . 962))
    '("Set Contextual Implicit." . ("1t" . 91))
    '("Set Decidable Equality Schemes." . ("bu" . 964))
    '("Set Default Goal Selector \"@{selector}\"." . ("6k" . 373))
    '("Set Default Goal Selector \"all\"." . ("6k" . 374))
    '("Set Default Proof Using \"@{expression}\"." . ("5w" . 332))
    '("Set Default Timeout @{int}." . ("54" . 281))
    '("Set Elimination Schemes." . ("bu" . 958))
    '("Set Extraction AutoInline." . ("fa" . 1037))
    '("Set Extraction Conservative Types." . ("fa" . 1035))
    '("Set Extraction KeepSingleton." . ("fa" . 1036))
    '("Set Extraction Optimize." . ("fa" . 1034))
    '("Set Extraction SafeImplicits." . ("fb" . 1042))
    '("Set Firstorder Depth @{n}." . ("8p" . 795))
    '("Set Firstorder Solver @{tactic}." . ("8p" . 789))
    '("Set Hide Obligations." . ("fp" . 1068))
    '("Set Hyps Limit @{num}." . ("6c" . 367))
    '("Set Implicit Arguments." . ("1r" . 85))
    '("Set Info Level @{num}." . ("9y" . 905))
    '("Set Intuition Iff Unfolding." . ("8n" . 785))
    '("Set Intuition Negation Unfolding." . ("8n" . 783))
    '("Set Loose Hint Behavior \"Lax\"." . ("8j" . 771))
    '("Set Loose Hint Behavior \"Strict\"." . ("8j" . 773))
    '("Set Loose Hint Behavior \"Warn\"." . ("8j" . 772))
    '("Set Ltac Debug." . ("9z" . 907))
    '("Set Maximal Implicit Insertion." . ("1v" . 95))
    '("Set Nonrecursive Elimination Schemes." . ("bu" . 960))
    '("Set Parsing Explicit." . ("21" . 103))
    '("Set Primitive Projections." . ("17" . 47))
    '("Set Printing All." . ("26" . 118))
    '("Set Printing Coercions." . ("dr" . 995))
    '("Set Printing Depth @{integer}." . ("5f" . 291))
    '("Set Printing Existential Instances." . ("29" . 124))
    '("Set Printing Implicit." . ("1z" . 99))
    '("Set Printing Implicit Defensive." . ("1z" . 101))
    '("Set Printing Matching." . ("1c" . 50))
    '("Set Printing Notations." . ("bc" . 916))
    '("Set Printing Parentheses." . ("dm" . 11))
    '("Set Printing Primitive Projection Compatibility." . ("17" . 49))
    '("Set Printing Primitive Projection Parameters." . ("17" . 48))
    '("Set Printing Projections." . ("16" . 45))
    '("Set Printing Records." . ("16" . 42))
    '("Set Printing Synth." . ("1c" . 56))
    '("Set Printing Universes." . ("27" . 120))
    '("Set Printing Width @{integer}." . ("5c" . 288))
    '("Set Printing Wildcard." . ("1c" . 53))
    '("Set Refine Instance Mode." . ("eh" . 1012))
    '("Set Reversible Pattern Implicit." . ("1u" . 93))
    '("Set Search Output Name Only." . ("5a" . 286))
    '("Set Shrink Abstract." . ("9t" . 900))
    '("Set Shrink Obligations." . ("fp" . 1069))
    '("Set Silent." . ("58" . 284))
    '("Set Strict Implicit." . ("1s" . 87))
    '("Set Strict Universe Declaration." . ("h9" . 1120))
    '("Set Strongly Strict Implicit." . ("1s" . 89))
    '("Set Suggest Proof Using." . ("5w" . 333))
    '("Set Tactic Compat Context." . ("9t" . 885))
    '("Set Transparent Obligations." . ("fp" . 1067))
    '("Set Universal Lemma Under Conjunction." . ("6s" . 398))
    '("Set Universe Polymorphism." . ("h1" . 1114))
    '("Show." . ("69" . 356))
    '("Show @{num}." . ("69" . 357))
    '("Show Conjectures." . ("69" . 362))
    '("Show Existentials." . ("69" . 365))
    '("Show Intro." . ("69" . 363))
    '("Show Intros." . ("69" . 364))
    '("Show Obligation Tactic." . ("fp" . 1059))
    '("Show Proof." . ("69" . 361))
    '("Show Script." . ("69" . 360))
    '("Solve All Obligations." . ("fp" . 1064))
    '("Solve All Obligations with @{expr}." . ("fp" . 1064))
    '("Solve Obligations." . ("fp" . 1063))
    '("Solve Obligations of @{ident}." . ("fp" . 1063))
    '("Solve Obligations of @{ident} with @{expr}." . ("fp" . 1063))
    '("Solve Obligations with @{expr}." . ("fp" . 1063))
    '("Strategy @{level} [@{qualid+}]." . ("5l" . 299))
    '("SubClass @{ident} := @{type}." . ("dk" . 989))
    '("Tactic Notation @{tactic_level} := @{tactic}." . ("bp" . 952))
    '("Tactic Notation @{tactic_level} @{prod_item+} := @{tactic}." . ("bp" . 952))
    '("Test @{flag}." . ("3u" . 181))
    '("Test @{option}." . ("3x" . 188))
    '("Test Automatic Introduction." . ("6e" . 369))
    '("Test Boolean Equality Schemes." . ("bu" . 963))
    '("Test Bracketing Last Introduction Pattern." . ("6y" . 452))
    '("Test Case Analysis Schemes." . ("bu" . 962))
    '("Test Contextual Implicit." . ("1t" . 91))
    '("Test Decidable Equality Schemes." . ("bu" . 964))
    '("Test Default Goal Selector." . ("6l" . 375))
    '("Test Default Timeout." . ("55" . 282))
    '("Test Elimination Schemes." . ("bu" . 958))
    '("Test Extraction AutoInline." . ("fa" . 1037))
    '("Test Extraction Conservative Types." . ("fa" . 1035))
    '("Test Extraction KeepSingleton." . ("fa" . 1036))
    '("Test Extraction Optimize." . ("fa" . 1034))
    '("Test Extraction SafeImplicits." . ("fb" . 1042))
    '("Test Hide Obligations." . ("fp" . 1068))
    '("Test Hyps Limit." . ("6d" . 368))
    '("Test Implicit Arguments." . ("1r" . 85))
    '("Test Intuition Iff Unfolding." . ("8n" . 785))
    '("Test Intuition Negation Unfolding." . ("8n" . 783))
    '("Test Ltac Debug." . ("9z" . 907))
    '("Test Maximal Implicit Insertion." . ("1v" . 95))
    '("Test Nonrecursive Elimination Schemes." . ("bu" . 960))
    '("Test Parsing Explicit." . ("21" . 103))
    '("Test Primitive Projections." . ("17" . 47))
    '("Test Printing All." . ("26" . 118))
    '("Test Printing Coercions." . ("dr" . 995))
    '("Test Printing Depth." . ("5g" . 292))
    '("Test Printing Existential Instances." . ("29" . 124))
    '("Test Printing If for @{ident}." . ("1c" . 65))
    '("Test Printing Implicit." . ("1z" . 99))
    '("Test Printing Implicit Defensive." . ("1z" . 101))
    '("Test Printing Let for @{ident}." . ("1c" . 61))
    '("Test Printing Matching." . ("1c" . 50))
    '("Test Printing Notations." . ("bc" . 916))
    '("Test Printing Primitive Projection Compatibility." . ("17" . 49))
    '("Test Printing Primitive Projection Parameters." . ("17" . 48))
    '("Test Printing Projections." . ("16" . 45))
    '("Test Printing Records." . ("16" . 42))
    '("Test Printing Synth." . ("1c" . 56))
    '("Test Printing Universes." . ("27" . 120))
    '("Test Printing Width." . ("5d" . 289))
    '("Test Printing Wildcard." . ("1c" . 53))
    '("Test Refine Instance Mode." . ("eh" . 1012))
    '("Test Reversible Pattern Implicit." . ("1u" . 93))
    '("Test Search Output Name Only." . ("5a" . 286))
    '("Test Shrink Abstract." . ("9t" . 900))
    '("Test Shrink Obligations." . ("fp" . 1069))
    '("Test Silent." . ("58" . 284))
    '("Test Strict Implicit." . ("1s" . 87))
    '("Test Strict Universe Declaration." . ("h9" . 1120))
    '("Test Strongly Strict Implicit." . ("1s" . 89))
    '("Test Suggest Proof Using." . ("5w" . 333))
    '("Test Tactic Compat Context." . ("9t" . 885))
    '("Test Transparent Obligations." . ("fp" . 1067))
    '("Test Universal Lemma Under Conjunction." . ("6s" . 398))
    '("Test Universe Polymorphism." . ("h1" . 1114))
    '("Theorem @{ident} : @{type}." . ("14" . 28))
    '("Theorem @{ident} @{binders} : @{type}." . ("14" . 28))
    '("Time @{command}." . ("51" . 278))
    '("Timeout @{int} @{command}." . ("53" . 280))
    '("Transparent @{qualid+}." . ("5k" . 297))
    '("Typeclasses eauto :=." . ("eg" . 1011))
    '("Typeclasses eauto := debug." . ("eg" . 1011))
    '("Typeclasses Opaque @{ident+}." . ("ef" . 1010))
    '("Typeclasses Transparent @{ident+}." . ("ef" . 1009))
    '("Undelimit Scope @{scope}." . ("bk" . 926))
    '("Undo." . ("61" . 341))
    '("Undo @{num}." . ("61" . 342))
    '("Unfocus." . ("64" . 347))
    '("Unfocused." . ("65" . 348))
    '("Universe @{ident}." . ("h6" . 1116))
    '("Unset @{flag}." . ("3t" . 178))
    '("Unset @{option}." . ("3w" . 185))
    '("Unset Automatic Introduction." . ("6e" . 369))
    '("Unset Boolean Equality Schemes." . ("bu" . 963))
    '("Unset Bracketing Last Introduction Pattern." . ("6y" . 452))
    '("Unset Case Analysis Schemes." . ("bu" . 962))
    '("Unset Contextual Implicit." . ("1t" . 91))
    '("Unset Decidable Equality Schemes." . ("bu" . 964))
    '("Unset Default Goal Selector." . ("6l" . 375))
    '("Unset Default Timeout." . ("55" . 282))
    '("Unset Elimination Schemes." . ("bu" . 958))
    '("Unset Extraction AutoInline." . ("fa" . 1037))
    '("Unset Extraction Conservative Types." . ("fa" . 1035))
    '("Unset Extraction KeepSingleton." . ("fa" . 1036))
    '("Unset Extraction Optimize." . ("fa" . 1034))
    '("Unset Extraction SafeImplicits." . ("fb" . 1042))
    '("Unset Hide Obligations." . ("fp" . 1068))
    '("Unset Hyps Limit." . ("6d" . 368))
    '("Unset Implicit Arguments." . ("1r" . 85))
    '("Unset Info Level @{num}." . ("9y" . 906))
    '("Unset Intuition Iff Unfolding." . ("8n" . 785))
    '("Unset Intuition Negation Unfolding." . ("8n" . 783))
    '("Unset Ltac Debug." . ("9z" . 907))
    '("Unset Maximal Implicit Insertion." . ("1v" . 95))
    '("Unset Nonrecursive Elimination Schemes." . ("bu" . 960))
    '("Unset Parsing Explicit." . ("21" . 103))
    '("Unset Primitive Projections." . ("17" . 47))
    '("Unset Printing All." . ("26" . 118))
    '("Unset Printing Coercions." . ("dr" . 995))
    '("Unset Printing Depth." . ("5g" . 292))
    '("Unset Printing Existential Instances." . ("29" . 124))
    '("Unset Printing Implicit." . ("1z" . 99))
    '("Unset Printing Implicit Defensive." . ("1z" . 101))
    '("Unset Printing Matching." . ("1c" . 50))
    '("Unset Printing Notations." . ("bc" . 916))
    '("Unset Printing Primitive Projection Compatibility." . ("17" . 49))
    '("Unset Printing Primitive Projection Parameters." . ("17" . 48))
    '("Unset Printing Projections." . ("16" . 45))
    '("Unset Printing Records." . ("16" . 42))
    '("Unset Printing Synth." . ("1c" . 56))
    '("Unset Printing Universes." . ("27" . 120))
    '("Unset Printing Width." . ("5d" . 289))
    '("Unset Printing Wildcard." . ("1c" . 53))
    '("Unset Refine Instance Mode." . ("eh" . 1012))
    '("Unset Reversible Pattern Implicit." . ("1u" . 93))
    '("Unset Search Output Name Only." . ("5a" . 286))
    '("Unset Shrink Abstract." . ("9t" . 900))
    '("Unset Shrink Obligations." . ("fp" . 1069))
    '("Unset Silent." . ("58" . 284))
    '("Unset Strict Implicit." . ("1s" . 87))
    '("Unset Strict Universe Declaration." . ("h9" . 1120))
    '("Unset Strongly Strict Implicit." . ("1s" . 89))
    '("Unset Suggest Proof Using." . ("5w" . 333))
    '("Unset Tactic Compat Context." . ("9t" . 885))
    '("Unset Transparent Obligations." . ("fp" . 1067))
    '("Unset Universal Lemma Under Conjunction." . ("6s" . 398))
    '("Unset Universe Polymorphism." . ("h1" . 1114))
    '("Unshelve." . ("9n" . 854))
    '("Variable @{ident} : @{term}." . ("10" . 8))
    '("Variable @{ident+} : @{term}." . ("10" . 10))
    '("Variant @{ident} @{binder+} : @{term} := @{constructors+}." . ("12" . 24))
    '("Extraction @{Inline | NoInline} @{qualid+}." . ("fa" . 1038))
    '("Hint @{Transparent | Opaque} @{qualid}." . ("8e" . 754))
    '("Hint @{Transparent | Opaque} @{ident+}." . ("8e" . 755))
    '("Hint @{Transparent | Opaque} @{qualid} : @{ident+}." . ("8e" . 754))
    '("Hint @{Transparent | Opaque} @{ident+} : @{ident+}." . ("8e" . 755))
    '("Local Hint @{Transparent | Opaque} @{qualid}." . ("8e" . 754))
    '("Local Hint @{Transparent | Opaque} @{ident+}." . ("8e" . 755))
    '("Local Hint @{Transparent | Opaque} @{qualid} : @{ident+}." . ("8e" . 754))
    '("Local Hint @{Transparent | Opaque} @{ident+} : @{ident+}." . ("8e" . 755))
    '("Module @{Import | Export} @{ident}." . ("2c" . 143))
    '("Print Instances @{Reflexive | Symmetric | Transitive | Equivalence | PreOrder | PER | Proper}." . ("gj" . 1106))
    '("Require @{Import | Export} @{qualid+}." . ("4e" . 239))
    '("Typeclasses eauto := @{dfs | bfs} @{depth}." . ("eg" . 1011))
    '("Typeclasses eauto := debug @{dfs | bfs} @{depth}." . ("eg" . 1011))))

(defconst company-coq--refman-scope-abbrevs
  (list
    '("bool_scope" . ("bm" . 955))
    '("char_scope" . ("bm" . 959))
    '("core_scope" . ("bm" . 957))
    '("list_scope" . ("bm" . 956))
    '("nat_scope" . ("bm" . 948))
    '("N_scope" . ("bm" . 949))
    '("positive_scope" . ("bm" . 951))
    '("Qc_scope" . ("bm" . 953))
    '("Q_scope" . ("bm" . 952))
    '("real_scope" . ("bm" . 954))
    '("string_scope" . ("bm" . 958))
    '("type_scope" . ("bm" . 947))
    '("Z_scope" . ("bm" . 950))))

(defconst company-coq--refman-error-abbrevs
  (list
    '("@{ident} already exists" . ("10" . 3))
    '("@{ident} cannot be defined." . ("16" . 39))
    '("@{ident} is already used" . ("6w" . 433))
    '("@{ident} is not a local definition" . ("6z" . 459))
    '("@{ident} is used in conclusion" . ("76" . 515))
    '("@{ident} is used in hypothesis @{ident'}" . ("76" . 514))
    '("@{ident} is used in the conclusion" . ("6z" . 455))
    '("@{ident} is used in the hypothesis @{ident'}" . ("6z" . 456))
    '("@{qualid} is not a module" . ("2c" . 171))
    '("Argument of match does not evaluate to a term" . ("9t" . 882))
    '("arguments of ring_simplify do not have all the same type" . ("fx" . 1075))
    '("Attempt to save an incomplete proof" . ("5t" . 308))
    '("bad lemma for decidability of equality" . ("fy" . 1080))
    '("Bad magic number" . ("4e" . 244))
    '("bad ring structure" . ("fy" . 1079))
    '("cannot be used as a hint" . ("8e" . 744))
    '("Cannot build functional inversion principle" . ("1d" . 73))
    '("Cannot define graph for @{ident}@{hole}" . ("1d" . 71))
    '("Cannot define principle(s) for @{ident}@{hole}" . ("1d" . 72))
    '("cannot find a declared ring structure for equality term" . ("fx" . 1077))
    '("cannot find a declared ring structure over term" . ("fx" . 1076))
    '("Cannot find induction information on @{qualid}" . ("7l" . 581))
    '("Cannot find inversion information for hypothesis @{ident}" . ("98" . 831))
    '("Cannot find library foo in loadpath" . ("4e" . 242))
    '("Cannot find the source class of @{qualid}" . ("dj" . 978))
    '("Cannot handle mutually (co)inductive records." . ("16" . 41))
    '("Cannot infer a term for this placeholder" . ("1o" . 77))
    '("Cannot load @{qualid}: no physical path bound to @{dirpath}" . ("4e" . 241))
    '("Cannot move @{ident} after @{ident}: it depends on @{ident}" . ("71" . 473))
    '("Cannot move @{ident} after @{ident}: it occurs in @{ident}" . ("71" . 472))
    '("Cannot recognize @{class} as a source class of @{qualid}" . ("dj" . 979))
    '("Cannot solve the goal" . ("9t" . 867))
    '("Cannot use mutual definition with well-founded recursion or measure" . ("1d" . 70))
    '("Can’t find file @{ident} on loadpath" . ("4c" . 235))
    '("Compiled library @{ident}.vo makes inconsistent assumptions over library @{qualid}" . ("4e" . 243))
    '("Condition not satisfied" . ("9t" . 896))
    '("does not denote an evaluable constant" . ("83" . 705))
    '("does not respect the uniform inheritance condition" . ("dj" . 980))
    '("Failed to progress" . ("9t" . 860))
    '("File not found on loadpath : \"@{string}\"" . ("4g" . 250))
    '("Found target class @{class} instead of @{class}" . ("dj" . 981))
    '("Funclass cannot be a source class" . ("dj" . 975))
    '("goal does not satisfy the expected preconditions" . ("7o" . 602))
    '("Goal is solvable by congruence but some arguments are missing. Try \"congruence with @{hole}\", replacing metavariables by arbitrary terms." . ("8q" . 800))
    '("Hypothesis @{ident} must contain at least one Function" . ("98" . 830))
    '("I don’t know how to handle dependent equality" . ("8q" . 799))
    '("Impossible to unify @{hole} with @{hole}" . ("6s" . 389))
    '("In environment @{hole} the term: @{term} does not have type @{term}" . ("fm" . 1054))
    '("invalid argument" . ("6r" . 385))
    '("Invalid backtrack" . ("4w" . 272))
    '("is already a coercion" . ("dj" . 974))
    '("is not a function" . ("dj" . 977))
    '("is not an inductive type" . ("8e" . 750))
    '("Loading of ML object file forbidden in a native Coq" . ("4g" . 251))
    '("Module/section @{module} not found" . ("47" . 215))
    '("must be a transparent constant" . ("dk" . 987))
    '("name @{ident} is already used" . ("6w" . 436))
    '("No applicable tactic" . ("9t" . 861))
    '("No argument name @{ident}" . ("1d" . 69))
    '("No discriminable equalities" . ("7m" . 592))
    '("No evars" . ("8v" . 809))
    '("No focused proof" . ("5q" . 305))
    '("No focused proof (No proof-editing in progress)" . ("5x" . 336))
    '("No focused proof to restart" . ("62" . 344))
    '("No matching clauses for match" . ("9t" . 881))
    '("No matching clauses for match goal" . ("9t" . 886))
    '("No primitive equality found" . ("7m" . 585))
    '("No product even after head-reduction" . ("6w" . 432))
    '("No progress made" . ("gr" . 1110))
    '("No such assumption" . ("6q" . 382))
    '("No such binder" . ("6m" . 376))
    '("no such entry" . ("4v" . 269))
    '("No such goal" . ("69" . 358))
    '("No such goal. Focus next goal with bullet @{bullet}." . ("67" . 352))
    '("No such goal. Try unfocusing with \"}\"." . ("67" . 353))
    '("No such hypothesis" . ("6w" . 446))
    '("No such hypothesis in current goal" . ("6w" . 439))
    '("No such label @{ident}" . ("2c" . 149))
    '("Non exhaustive pattern-matching" . ("db" . 971))
    '("Non strictly positive occurrence of @{ident} in @{type}" . ("12" . 21))
    '("not a context variable" . ("9t" . 888))
    '("not a defined object" . ("3p" . 169))
    '("Not a discriminable equality" . ("7m" . 586))
    '("Not a primitive equality" . ("7o" . 596))
    '("Not a projectable equality but a discriminable one" . ("7o" . 594))
    '("Not a proposition or a type" . ("76" . 496))
    '("not a valid ring equation" . ("fx" . 1074))
    '("Not a variable or hypothesis" . ("8w" . 811))
    '("Not an evar" . ("8u" . 807))
    '("Not an exact proof" . ("6p" . 379))
    '("Not an inductive goal with 1 constructor" . ("6u" . 416))
    '("Not an inductive goal with 2 constructors" . ("6u" . 422))
    '("Not an inductive product" . ("6u" . 410))
    '("Not convertible" . ("7x" . 667))
    '("not declared" . ("dj" . 973))
    '("Not enough constructors" . ("6u" . 411))
    '("Not equal" . ("8s" . 802))
    '("Not reducible" . ("80" . 688))
    '("Not the right number of induction arguments" . ("7l" . 582))
    '("Not the right number of missing arguments" . ("6m" . 377))
    '("Not unifiable" . ("8t" . 804))
    '("Nothing to do, it is an equality between convertible terms" . ("7o" . 595))
    '("Nothing to rewrite" . ("gr" . 1109))
    '("omega can’t solve this system" . ("el" . 1013))
    '("omega: Can’t solve a goal with equality on @{type}" . ("el" . 1020))
    '("omega: Can’t solve a goal with non-linear products" . ("el" . 1019))
    '("omega: Can’t solve a goal with proposition variables" . ("el" . 1017))
    '("omega: Not a quantifier-free goal" . ("el" . 1014))
    '("omega: Unrecognized atomic proposition: @{prop}" . ("el" . 1016))
    '("omega: Unrecognized predicate or connective: @{ident}" . ("el" . 1015))
    '("omega: Unrecognized proposition" . ("el" . 1018))
    '("Proof is not complete" . ("76" . 499))
    '("quote: not a simple fixpoint" . ("99" . 835))
    '("Records declared with the keyword Record or Structure cannot be recursive." . ("16" . 40))
    '("Require is not allowed inside a module or a module type" . ("4e" . 246))
    '("ring @{operation} should be declared as a morphism" . ("fy" . 1081))
    '("Signature components for label @{ident} do not match" . ("2c" . 150))
    '("Sortclass cannot be a source class" . ("dj" . 976))
    '("Statement without assumptions" . ("6t" . 400))
    '("Tactic Failure @{message} (level @{n})" . ("9t" . 877))
    '("Tactic generated a subgoal identical to the original goal" . ("7t" . 638))
    '("terms do not have convertible types" . ("7u" . 647))
    '("The @{num}th argument of @{ident} must be @{ident'} in @{type}" . ("12" . 25))
    '("The conclusion is not a substitutive equation" . ("8z" . 814))
    '("The conclusion of @{type} is not valid; it must be built from @{ident}" . ("12" . 22))
    '("The file @{ident}.vo contains library @{dirpath} and not library @{dirpath'}" . ("4e" . 245))
    '("The recursive argument must be specified" . ("1d" . 68))
    '("The reference @{qualid} was not found in the current environment" . ("46" . 203))
    '("The term @{form} has type @{hole} which should be Set, Prop or Type" . ("14" . 29))
    '("The term @{term} has type @{type} while it is expected to have type @{type}" . ("11" . 17))
    '("The term provided does not end with an equation" . ("7t" . 637))
    '("The variable @{ident} is already defined" . ("73" . 479))
    '("This is not the last opened module" . ("2c" . 151))
    '("This is not the last opened module type" . ("2c" . 163))
    '("This is not the last opened section" . ("1g" . 76))
    '("This proof is focused, but cannot be unfocused this way" . ("66" . 349))
    '("This tactic has more than one success" . ("9t" . 865))
    '("Unable to apply" . ("6t" . 401))
    '("Unable to find an instance for the variables @{ident+}" . ("6s" . 390))
    '("Unable to satisfy the rewriting constraints" . ("gr" . 1111))
    '("Undeclared universe @{ident}" . ("h7" . 1118))
    '("Universe inconsistency" . ("35" . 167))
    '("Variable @{ident} is already declared" . ("76" . 503))
    '("Wrong bullet @{bullet}1 : Bullet @{bullet}2 is mandatory here." . ("67" . 351))
    '("Wrong bullet @{bullet}1 : Current bullet @{bullet}2 is not finished." . ("67" . 350))))

(provide 'company-coq-abbrev)
;;; company-coq-abbrev.el ends here
