;;; darktooth.el --- From the darkness... it watches

;; Copyright (c) 2015-2022 Jason Milkins (GNU/GPL Licence)

;; Authors: Jason Milkins <jasonm23@gmail.com>
;; URL: http://github.com/emacsfodder/emacs-theme-darktooth

;; Package-Requires: ((emacs "27.1") (autothemer "0.2"))

;;; Commentary:
;;  From the darkness... it watches

;;  Since 1.0.0  : Prepare for variations, create darktooth-deftheme.
;;  Since 0.4.0  : Restructure for simpler theme development
;;  Since 0.3.0  : Official release integrated with autothemer
;;  Since 0.2.0  : Built using autothemer
;;  Since 0.1.60 : includes `darktooth-modeline'

;;; Code:
(require 'autothemer)

(unless (>= emacs-major-version 24)
  (error "Requires Emacs 24 or later"))

;;;###autoload
(defmacro darktooth-deftheme (name description palette &rest body)
  "Create darktooth theme with NAME, DESCRIPTION, PALETTE and BODY."
  `(autothemer-deftheme ,name ,description ,palette
     ((Man-overstrike                            (:foreground darktooth-bright-red :bold t))
      (Man-underline                             (:foreground darktooth-bright-green :bold t))
      (ac-dabbrev-menu-face                      (:inherit 'popup-face))
      (ac-dabbrev-selection-face                 (:inherit 'popup-menu-selection-face))
      (ag-hit-face                               (:foreground darktooth-neutral-blue))
      (ag-match-face                             (:foreground darktooth-neutral-red))
      (anzu-match-1                              (:foreground darktooth-background-0 :background darktooth-bright-green))
      (anzu-match-2                              (:foreground darktooth-background-0 :background darktooth-bright-yellow))
      (anzu-match-3                              (:foreground darktooth-background-0 :background darktooth-bright-cyan))
      (anzu-mode-line                            (:foreground darktooth-foreground-0 :height 100 :background darktooth-faded-blue))
      (anzu-replace-highlight                    (:background darktooth-background-aqua))
      (anzu-replace-to                           (:background darktooth-background-cyan))
      (avy-background-face                       (:foreground darktooth-background-3))
      (avy-goto-char-timer-face                  (:inherit 'highlight))
      (avy-lead-face                             (:foreground darktooth-bright-red))
      (avy-lead-face-0                           (:foreground darktooth-bright-blue))
      (avy-lead-face-1                           (:foreground darktooth-bright-aqua))
      (avy-lead-face-2                           (:foreground darktooth-bright-purple))
      (col-highlight                             (:inherit 'vline))
      (column-enforce-face                       (:foreground darktooth-background-4 :background darktooth-background-red))
      (column-marker-1                           (:background darktooth-faded-blue))
      (column-marker-2                           (:background darktooth-faded-purple))
      (column-marker-3                           (:background darktooth-faded-cyan))
      (company-echo                              (:inherit 'company-echo-common))
      (company-echo-common                       (:foreground darktooth-bright-blue :background 'unspecified))
      (company-preview                           (:inherit 'company-preview-common))
      (company-preview-common                    (:inherit 'font-lock-comment-face))
      (company-preview-common                    (:underline darktooth-foreground-1))
      (company-preview-search                    (:inherit 'company-preview-common))
      (company-scrollbar-bg                      (:foreground 'unspecified :background darktooth-background-3))
      (company-scrollbar-fg                      (:foreground 'unspecified :background darktooth-background-2))
      (company-template-field                    (:foreground darktooth-bright-blue :background 'unspecified :underline darktooth-background-blue))
      (company-tooltip                           (:foreground darktooth-foreground-0-hard :background darktooth-background-1))
      (company-tooltip-annotation                (:foreground darktooth-bright-blue :background darktooth-background-1))
      (company-tooltip-common                    (:foreground darktooth-foreground-0 :background darktooth-background-1))
      (company-tooltip-common-selection          (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (company-tooltip-mouse                     (:foreground darktooth-background-0 :background darktooth-bright-blue))
      (company-tooltip-selection                 (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (compilation-info                          (:foreground darktooth-neutral-green))
      (compilation-mode-line-fail                (:foreground darktooth-neutral-red))
      (completions-annotations                   (:inherit 'font-lock-doc-face))
      (corfu-annotations                         (:foreground darktooth-bright-blue :background 'unspecified))
      (corfu-bar                                 (:background darktooth-background-3))
      (corfu-border                              (:background darktooth-background-0))
      (corfu-current                             (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (corfu-default                             (:foreground darktooth-foreground-0 :background darktooth-background-1))
      (cua-rectangle                             (:background darktooth-mid-blue))
      (cursor                                    (:background darktooth-foreground-0))
      (default                                   (:foreground darktooth-foreground-0 :background darktooth-background-0))
      (diff-added                                (:foreground darktooth-neutral-green :background darktooth-mid-green))
      (diff-changed                              (:foreground darktooth-foreground-1 :background 'unspecified))
      (diff-hl-change                            (:inherit 'diff-changed))
      (diff-hl-delete                            (:inherit 'diff-removed))
      (diff-hl-insert                            (:inherit 'diff-added))
      (diff-indicator-added                      (:inherit 'diff-added))
      (diff-indicator-changed                    (:inherit 'diff-changed))
      (diff-indicator-removed                    (:inherit 'diff-removed))
      (diff-refine-added                         (:foreground darktooth-bright-green :background darktooth-muted-green))
      (diff-refine-removed                       (:foreground darktooth-bright-red :background darktooth-muted-red))
      (diff-removed                              (:foreground darktooth-neutral-red :background darktooth-mid-red))
      (diff-file-header                          (:weight 'bold :inherit 'default :extend t))
      (diff-hunk-header                          (:foreground darktooth-foreground-2 :background darktooth-background-2 :extend t))
      (diff-header                               (:weight 'bold :inherit 'default :extend t))
      (diff-context                              (:foreground darktooth-background-3 :background 'unspecified))
      (dired-directory                           (:inherit 'font-lock-function-name-face))
      (dired-flagged                             (:inherit 'error))
      (dired-header                              (:inherit 'font-lock-type-face))
      (dired-ignored                             (:inherit 'shadow))
      (dired-mark                                (:inherit 'font-lock-constant-face))
      (dired-marked                              (:inherit 'warning))
      (dired-perm-write                          (:inherit 'font-lock-comment-delimiter-face))
      (dired-subtree-depth-1-face                (:background 'unspecified))
      (dired-subtree-depth-2-face                (:background 'unspecified))
      (dired-subtree-depth-3-face                (:background 'unspecified))
      (dired-subtree-depth-4-face                (:background 'unspecified))
      (dired-subtree-depth-5-face                (:background 'unspecified))
      (dired-subtree-depth-6-face                (:background 'unspecified))
      (dired-symlink                             (:inherit 'font-lock-keyword-face))
      (dired-warning                             (:inherit 'font-lock-warning-face))
      (diredfl-autofile-name                     (:foreground darktooth-foreground-1))
      (diredfl-compressed-file-name              (:foreground darktooth-foreground-1))
      (diredfl-compressed-file-suffix            (:foreground darktooth-foreground-1))
      (diredfl-date-time                         (:foreground darktooth-foreground-2))
      (diredfl-deletion                          (:foreground darktooth-faded-red))
      (diredfl-deletion-file-name                (:foreground darktooth-faded-red))
      (diredfl-dir-heading                       (:foreground darktooth-foreground-1))
      (diredfl-dir-name                          (:foreground darktooth-bright-cyan))
      (diredfl-dir-priv                          (:foreground darktooth-bright-cyan :background darktooth-background-1))
      (diredfl-exec-priv                         (:foreground darktooth-bright-orange :background darktooth-background-1))
      (diredfl-executable-tag                    (:foreground darktooth-bright-orange))
      (diredfl-file-name                         (:foreground darktooth-neutral-cyan))
      (diredfl-file-suffix                       (:foreground darktooth-faded-cyan))
      (diredfl-flag-mark                         (:foreground darktooth-bright-cyan))
      (diredfl-flag-mark-line                    (:foreground darktooth-foreground-0 :background darktooth-background-1))
      (diredfl-ignored-file-name                 (:foreground darktooth-foreground-3))
      (diredfl-link-priv                         (:foreground darktooth-bright-purple :background darktooth-background-1))
      (diredfl-no-priv                           (:foreground darktooth-foreground-4 :background darktooth-background-1))
      (diredfl-number                            (:foreground darktooth-foreground-2))
      (diredfl-other-priv                        (:background darktooth-background-1))
      (diredfl-rare-priv                         (:background darktooth-background-1))
      (diredfl-read-priv                         (:foreground darktooth-bright-aqua :background darktooth-background-1))
      (diredfl-symlink                           (:foreground darktooth-neutral-cyan))
      (diredfl-tagged-autofile-name              (:foreground darktooth-foreground-1 :background darktooth-background-1))
      (diredfl-write-priv                        (:foreground darktooth-bright-green :background darktooth-background-1))
      (diredp-autofile-name                      (:inherit 'diredfl-autofile-name))
      (diredp-compressed-file-name               (:inherit 'diredfl-compressed-file-name))
      (diredp-compressed-file-suffix             (:inherit 'diredfl-compressed-file-suffix))
      (diredp-date-time                          (:inherit 'diredfl-date-time))
      (diredp-deletion                           (:inherit 'diredfl-deletion))
      (diredp-deletion-file-name                 (:inherit 'diredfl-deletion-file-name))
      (diredp-dir-heading                        (:inherit 'diredfl-dir-heading))
      (diredp-dir-name                           (:inherit 'diredfl-dir-name))
      (diredp-dir-priv                           (:inherit 'diredfl-dir-priv))
      (diredp-exec-priv                          (:inherit 'diredfl-exec-priv))
      (diredp-executable-tag                     (:inherit 'diredfl-executable-tag))
      (diredp-file-name                          (:inherit 'diredfl-file-name))
      (diredp-file-suffix                        (:inherit 'diredfl-file-suffix))
      (diredp-flag-mark                          (:inherit 'diredfl-flag-mark))
      (diredp-flag-mark-line                     (:inherit 'diredfl-flag-mark-line))
      (diredp-ignored-file-name                  (:inherit 'diredfl-ignored-file-name))
      (diredp-link-priv                          (:inherit 'diredfl-link-priv))
      (diredp-no-priv                            (:inherit 'diredfl-no-priv))
      (diredp-number                             (:inherit 'diredfl-number))
      (diredp-other-priv                         (:inherit 'diredfl-other-priv))
      (diredp-rare-priv                          (:inherit 'diredfl-rare-priv))
      (diredp-read-priv                          (:inherit 'diredfl-read-priv))
      (diredp-symlink                            (:inherit 'diredfl-symlink))
      (diredp-tagged-autofile-name               (:inherit 'diredfl-tagged-autofile-name))
      (diredp-write-priv                         (:inherit 'diredfl-write-priv))
      (dropdown-list-face                        (:foreground darktooth-black :background darktooth-foreground-0-hard :inherit 'default))
      (dropdown-list-selection-face              (:background darktooth-bright-purple :inherit 'dropdown-list))
      (el-search-match                           (:background darktooth-background-cyan))
      (el-search-other-match                     (:background darktooth-background-blue))
      (eldoc-highlight-function-argument         (:foreground darktooth-aquamarine4 :weight 'bold))
      (elfeed-search-date-face                   (:foreground darktooth-muted-cyan))
      (elfeed-search-feed-face                   (:foreground darktooth-faded-cyan))
      (elfeed-search-tag-face                    (:foreground darktooth-foreground-3))
      (elfeed-search-title-face                  (:foreground darktooth-foreground-3 :bold nil))
      (elfeed-search-unread-title-face           (:foreground darktooth-foreground-0-hard :bold nil))
      (elixir-atom-face                          (:foreground darktooth-lightblue4))
      (elixir-attribute-face                     (:foreground darktooth-burlywood4))
      (elscreen-tab-background-face              (:background darktooth-background-0 :box nil))
      (elscreen-tab-control-face                 (:foreground darktooth-neutral-red :background darktooth-background-2 :box nil :underline nil))
      (elscreen-tab-current-screen-face          (:foreground darktooth-background-0 :background darktooth-background-4 :box nil))
      (elscreen-tab-other-screen-face            (:foreground darktooth-foreground-4 :background darktooth-background-2 :box nil :underline nil))
      (embrace-help-key-face                     (:foreground darktooth-bright-green :weight 'bold))
      (embrace-help-mark-func-face               (:foreground darktooth-bright-cyan))
      (embrace-help-pair-face                    (:foreground darktooth-bright-blue))
      (embrace-help-separator-face               (:foreground darktooth-bright-orange))
      (erc-action-face                           (:inherit 'erc-default-face))
      (erc-bold-face                             (:weight 'bold))
      (erc-button                                (:weight 'bold  :underline t))
      (erc-current-nick-face                     (:foreground darktooth-aquamarine4 :weight 'bold))
      (erc-dangerous-host-face                   (:inherit 'font-lock-warning-face))
      (erc-default-face                          (:inherit 'default))
      (erc-direct-msg-face                       (:inherit 'erc-default-face))
      (erc-error-face                            (:inherit 'font-lock-warning-face))
      (erc-fool-face                             (:inherit 'erc-default-face))
      (erc-input-face                            (:foreground darktooth-sienna))
      (erc-keyword-face                          (:foreground darktooth-bright-orange :weight 'bold))
      (erc-my-nick-face                          (:foreground darktooth-sienna :weight 'bold))
      (erc-nick-default-face                     (:weight 'bold))
      (erc-nick-msg-face                         (:inherit 'erc-default-face))
      (erc-notice-face                           (:foreground darktooth-background-4))
      (erc-pal-face                              (:foreground darktooth-neutral-yellow :weight 'bold))
      (erc-prompt-face                           (:foreground darktooth-sienna :weight 'bold))
      (erc-timestamp-face                        (:foreground darktooth-neutral-green))
      (erc-underline-face                        (:underline t))
      (erefactor-highlight-face                  (:inherit 'match))
      (error                                     (:foreground darktooth-bright-red :bold t))
      (escape-glyph                              (:foreground darktooth-neutral-cyan))
      (eww-form-checkbox                         (:box (:line-width 2 :style 'released-button) :foreground darktooth-black :background darktooth-identifiers-1))
      (eww-form-file                             (:box (:line-width 2 :style 'released-button) :foreground darktooth-black :background darktooth-muted-purple))
      (eww-form-select                           (:box (:line-width 2 :style 'released-button) :foreground darktooth-black :background darktooth-identifiers-1))
      (eww-form-submit                           (:box (:line-width 2 :style 'released-button) :foreground darktooth-black :background darktooth-muted-purple))
      (eww-form-text                             (:box (:line-width 1) :foreground darktooth-white :background darktooth-background-2))
      (eww-form-textarea                         (:box (:line-width 1) :foreground darktooth-black :background darktooth-neutral-purple))
      (eww-invalid-certificate                   (:weight 'bold :foreground darktooth-faded-red))
      (eww-valid-certificate                     (:weight 'bold :foreground darktooth-mid-aqua))
      (ffap                                      (:inherit 'highlight))
      (file-name-shadow                          (:inherit 'shadow))
      (flx-highlight-face                        (:weight 'bold :underline t :inherit 'font-lock-variable-name-face))
      (flycheck-error                            (:underline (:style 'wave :color darktooth-bright-red)))
      (flycheck-error-list-error                 (:foreground darktooth-bright-red :bold t))
      (flycheck-error-list-info                  (:foreground darktooth-bright-blue :bold t))
      (flycheck-error-list-warning               (:foreground darktooth-bright-yellow :bold t))
      (flycheck-fringe-error                     (:foreground darktooth-bright-red))
      (flycheck-fringe-info                      (:foreground darktooth-bright-blue))
      (flycheck-fringe-warning                   (:foreground darktooth-bright-yellow))
      (flycheck-info                             (:underline (:style 'wave :color darktooth-bright-blue)))
      (flycheck-warning                          (:underline (:style 'wave :color darktooth-bright-yellow)))
      (flymake-errline                           (:underline (:style 'wave :color darktooth-bright-red)))
      (flymake-error                             (:underline (:style 'wave :color darktooth-bright-red)))
      (flymake-note                              (:underline (:style 'wave :color darktooth-bright-blue)))
      (flymake-warline                           (:underline (:style 'wave :color darktooth-bright-yellow)))
      (flymake-warning                           (:underline (:style 'wave :color darktooth-bright-yellow)))
      (font-latex-math-face                      (:foreground darktooth-lightblue4))
      (font-latex-sectioning-5-face              (:foreground darktooth-neutral-green))
      (font-latex-string-face                    (:inherit 'font-lock-string-face))
      (font-latex-warning-face                   (:inherit 'warning))
      (font-lock-builtin-face                    (:foreground darktooth-bright-orange))
      (font-lock-comment-delimiter-face          (:inherit 'font-lock-comment-face))
      (font-lock-comment-face                    (:foreground darktooth-medium))
      (font-lock-constant-face                   (:foreground darktooth-burlywood4))
      (font-lock-doc-face                        (:inherit 'font-lock-string-face))
      (font-lock-function-name-face              (:foreground darktooth-foreground-4))
      (font-lock-keyword-face                    (:foreground darktooth-sienna))
      (font-lock-negation-char-face              (:foreground darktooth-mid-cyan))
      (font-lock-preprocessor-face               (:inherit 'font-lock-builtin-face))
      (font-lock-regexp-grouping-backslash       (:inherit 'bold))
      (font-lock-regexp-grouping-construct       (:inherit 'bold))
      (font-lock-string-face                     (:foreground darktooth-darkslategray4))
      (font-lock-type-face                       (:foreground darktooth-lightblue4))
      (font-lock-variable-name-face              (:foreground darktooth-aquamarine4))
      (font-lock-warning-face                    (:foreground darktooth-neutral-red :bold t))
      (fringe                                    (:background darktooth-background-0))
      (git-commit-comment-action                 (:inherit 'git-commit-comment-branch))
      (git-commit-comment-branch                 (:inherit 'font-lock-variable-name-face))
      (git-commit-comment-detached               (:inherit 'git-commit-comment-branch))
      (git-commit-comment-file                   (:inherit 'git-commit-pseudo-header))
      (git-commit-comment-heading                (:inherit 'git-commit-known-pseudo-header))
      (git-commit-known-pseudo-header            (:inherit 'font-lock-keyword-face))
      (git-commit-nonempty-second-line           (:inherit 'font-lock-warning-face))
      (git-commit-note                           (:inherit 'font-lock-string-face))
      (git-commit-overlong-summary               (:inherit 'font-lock-warning-face))
      (git-commit-pseudo-header                  (:inherit 'font-lock-string-face))
      (git-commit-summary                        (:inherit 'font-lock-type-face))
      (git-gutter+-added                         (:foreground darktooth-faded-green :background darktooth-background-green))
      (git-gutter+-commit-header-face            (:inherit 'font-lock-comment-face))
      (git-gutter+-deleted                       (:foreground darktooth-faded-red :background darktooth-background-red))
      (git-gutter+-modified                      (:foreground darktooth-faded-purple :background darktooth-background-purple))
      (git-gutter+-separator                     (:foreground darktooth-faded-cyan :background darktooth-background-cyan))
      (git-gutter+-unchanged                     (:foreground darktooth-faded-yellow :background darktooth-background-yellow))
      (git-gutter-fr+-added                      (:inherit 'git-gutter+-added))
      (git-gutter-fr+-deleted                    (:inherit 'git-gutter+-deleted))
      (git-gutter-fr+-modified                   (:inherit 'git-gutter+-modified))
      (git-gutter-fr:added                       (:inherit 'git-gutter:added))
      (git-gutter-fr:deleted                     (:inherit 'git-gutter:deleted))
      (git-gutter-fr:modified                    (:inherit 'git-gutter:modified))
      (git-gutter:added                          (:foreground darktooth-faded-green :background darktooth-background-green))
      (git-gutter:deleted                        (:foreground darktooth-faded-red :background darktooth-background-red))
      (git-gutter:modified                       (:foreground darktooth-faded-purple :background darktooth-background-purple))
      (git-gutter:separator                      (:foreground darktooth-faded-cyan :background darktooth-background-cyan))
      (git-gutter:unchanged                      (:foreground darktooth-faded-yellow :background darktooth-background-yellow))
      (glyphless-char                            (:height 0.6))
      (gnus-group-mail-1                         (:weight 'bold :foreground darktooth-foreground-0-hard))
      (gnus-group-mail-1-empty                   (:foreground darktooth-foreground-0-hard))
      (gnus-group-mail-2                         (:weight 'bold :foreground darktooth-identifiers-4))
      (gnus-group-mail-2-empty                   (:foreground darktooth-identifiers-4))
      (gnus-group-mail-3                         (:weight 'bold :foreground darktooth-bright-orange))
      (gnus-group-mail-3-empty                   (:foreground darktooth-bright-orange))
      (gnus-group-mail-low                       (:weight 'bold :foreground darktooth-faded-orange))
      (gnus-group-mail-low-empty                 (:foreground darktooth-faded-orange))
      (gnus-group-news-1                         (:weight 'bold :foreground darktooth-identifiers-7))
      (gnus-group-news-1-empty                   (:foreground darktooth-identifiers-7))
      (gnus-group-news-2                         (:weight 'bold :foreground darktooth-bright-cyan))
      (gnus-group-news-2-empty                   (:foreground darktooth-bright-cyan))
      (gnus-group-news-3                         (:weight 'bold))
      (gnus-group-news-3-empty nil)
      (gnus-group-news-4                         (:weight 'bold))
      (gnus-group-news-4-empty nil)
      (gnus-group-news-5                         (:weight 'bold))
      (gnus-group-news-5-empty nil)
      (gnus-group-news-6                         (:weight 'bold))
      (gnus-group-news-6-empty nil)
      (gnus-group-news-low                       (:weight 'bold :foreground darktooth-neutral-cyan))
      (gnus-group-news-low-empty                 (:foreground darktooth-neutral-cyan))
      (gnus-splash                               (:foreground darktooth-identifiers-4))
      (gnus-summary-cancelled                    (:foreground darktooth-foreground-0-hard :background darktooth-black))
      (gnus-summary-high-ancient                 (:weight 'bold :foreground darktooth-bright-green))
      (gnus-summary-high-read                    (:weight 'bold :foreground darktooth-neutral-yellow))
      (gnus-summary-high-ticked                  (:weight 'bold :foreground darktooth-identifiers-15))
      (gnus-summary-high-undownloaded            (:weight 'bold :foreground darktooth-identifiers-1))
      (gnus-summary-high-unread                  (:weight 'bold))
      (gnus-summary-low-ancient                  (:slant 'italic :foreground darktooth-bright-green))
      (gnus-summary-low-read                     (:slant 'italic :foreground darktooth-neutral-yellow))
      (gnus-summary-low-ticked                   (:slant 'italic :foreground darktooth-identifiers-15))
      (gnus-summary-low-undownloaded             (:weight 'normal :slant 'italic :foreground darktooth-faded-cyan))
      (gnus-summary-low-unread                   (:slant 'italic))
      (gnus-summary-normal-ancient               (:foreground darktooth-bright-green))
      (gnus-summary-normal-read                  (:foreground darktooth-neutral-yellow))
      (gnus-summary-normal-ticked                (:foreground darktooth-identifiers-15))
      (gnus-summary-normal-undownloaded          (:weight 'normal :foreground darktooth-faded-cyan))
      (gnus-summary-normal-unread nil)
      (gnus-summary-selected                     (:underline t))
      (haskell-constructor-face                  (:foreground darktooth-neutral-aqua :background 'unspecified))
      (haskell-interactive-face-compile-error    (:underline (:color darktooth-bright-red :style 'wave)))
      (haskell-interactive-face-compile-warning  (:underline (:color darktooth-bright-yellow :style 'wave)))
      (haskell-interactive-face-garbage          (:foreground darktooth-background-4 :background 'unspecified))
      (haskell-interactive-face-prompt           (:foreground darktooth-foreground-0 :background 'unspecified))
      (haskell-interactive-face-result           (:foreground darktooth-foreground-3 :background 'unspecified))
      (haskell-literate-comment-face             (:foreground darktooth-foreground-0 :background 'unspecified))
      (haskell-pragma-face                       (:foreground darktooth-medium :background 'unspecified))
      (header-line                               (:foreground darktooth-turquoise4 :background darktooth-background-0 :bold nil))
      (helm-M-x-key                              (:foreground darktooth-neutral-orange))
      (helm-action                               (:foreground darktooth-white :underline t))
      (helm-bookmark-addressbook                 (:foreground darktooth-neutral-red))
      (helm-bookmark-directory                   (:foreground darktooth-bright-purple))
      (helm-bookmark-file                        (:foreground darktooth-faded-blue))
      (helm-bookmark-gnus                        (:foreground darktooth-faded-purple))
      (helm-bookmark-info                        (:foreground darktooth-turquoise4))
      (helm-bookmark-man                         (:foreground darktooth-sienna))
      (helm-bookmark-w3m                         (:foreground darktooth-neutral-yellow))
      (helm-buffer-directory                     (:foreground darktooth-white :background darktooth-bright-blue))
      (helm-buffer-not-saved                     (:foreground darktooth-faded-red))
      (helm-buffer-process                       (:foreground darktooth-burlywood4))
      (helm-buffer-saved-out                     (:foreground darktooth-bright-red))
      (helm-buffer-size                          (:foreground darktooth-bright-purple))
      (helm-candidate-number                     (:foreground darktooth-neutral-green))
      (helm-ff-directory                         (:foreground darktooth-neutral-purple))
      (helm-ff-executable                        (:foreground darktooth-turquoise4))
      (helm-ff-file                              (:foreground darktooth-sienna))
      (helm-ff-invalid-symlink                   (:foreground darktooth-white :background darktooth-bright-red))
      (helm-ff-prefix                            (:foreground darktooth-black :background darktooth-neutral-yellow))
      (helm-ff-symlink                           (:foreground darktooth-neutral-orange))
      (helm-grep-cmd-line                        (:foreground darktooth-neutral-green))
      (helm-grep-file                            (:foreground darktooth-faded-purple))
      (helm-grep-finish                          (:foreground darktooth-turquoise4))
      (helm-grep-lineno                          (:foreground darktooth-neutral-orange))
      (helm-grep-match                           (:foreground darktooth-neutral-yellow))
      (helm-grep-running                         (:foreground darktooth-neutral-red))
      (helm-header                               (:foreground darktooth-aquamarine4))
      (helm-helper                               (:foreground darktooth-aquamarine4))
      (helm-history-deleted                      (:foreground darktooth-black :background darktooth-bright-red))
      (helm-history-remote                       (:foreground darktooth-faded-red))
      (helm-lisp-completion-info                 (:foreground darktooth-faded-orange))
      (helm-lisp-show-completion                 (:foreground darktooth-bright-red))
      (helm-locate-finish                        (:foreground darktooth-white :background darktooth-aquamarine4))
      (helm-match                                (:foreground darktooth-neutral-orange))
      (helm-moccur-buffer                        (:foreground darktooth-bright-aqua :underline t))
      (helm-prefarg                              (:foreground darktooth-turquoise4))
      (helm-selection                            (:foreground darktooth-white :background darktooth-background-2))
      (helm-selection-line                       (:foreground darktooth-white :background darktooth-background-2))
      (helm-separator                            (:foreground darktooth-faded-red))
      (helm-source-header                        (:foreground darktooth-foreground-2 :background darktooth-background-1))
      (helm-swoop-line-number-face               (:foreground darktooth-neutral-orange))
      (helm-swoop-target-line-block-face         (:foreground darktooth-foreground-0-hard :background darktooth-faded-blue))
      (helm-swoop-target-line-face               (:foreground darktooth-foreground-0-hard :background darktooth-faded-blue))
      (helm-swoop-target-word-face               (:foreground darktooth-foreground-0 :background darktooth-faded-aqua))
      (helm-visible-mark                         (:foreground darktooth-black :background darktooth-foreground-3))
      (hi-black-b                                (:foreground darktooth-bright-orange :background darktooth-background-0-hard :bold t))
      (hi-black-hb                               (:foreground darktooth-bright-cyan :background darktooth-background-0-hard :bold t))
      (hi-blue                                   (:foreground darktooth-background-0-hard :background darktooth-bright-blue))
      (hi-blue-b                                 (:foreground darktooth-bright-blue :bold t))
      (hi-green                                  (:foreground darktooth-background-0-hard :background darktooth-bright-green))
      (hi-green-b                                (:foreground darktooth-bright-green :bold t))
      (hi-pink                                   (:foreground darktooth-background-0-hard :background darktooth-bright-purple))
      (hi-red-b                                  (:foreground darktooth-bright-red :bold t))
      (hi-yellow                                 (:foreground darktooth-background-0-hard :background darktooth-bright-yellow))
      (highlight                                 (:foreground darktooth-foreground-0-hard :background darktooth-faded-blue))
      (highlight-indentation-current-column-face (:background darktooth-background-4))
      (highlight-indentation-face                (:background darktooth-background-1))
      (highlight-numbers-number                  (:foreground darktooth-bright-purple :bold nil))
      (highlight-symbol-face                     (:foreground darktooth-neutral-purple))
      (hl-line                                   (:background darktooth-background-purple))
      (hydra-face-amaranth                       (:foreground darktooth-faded-purple))
      (hydra-face-blue                           (:foreground darktooth-bright-blue))
      (hydra-face-pink                           (:foreground darktooth-identifiers-15))
      (hydra-face-red                            (:foreground darktooth-bright-red))
      (hydra-face-teal                           (:foreground darktooth-faded-cyan))
      (ido-first-match                           (:foreground darktooth-faded-cyan :background darktooth-background-0-hard))
      (ido-indicator                             (:background darktooth-bright-red :foreground darktooth-bright-yellow))
      (ido-only-match                            (:foreground darktooth-darkslategray4))
      (ido-subdir                                (:foreground darktooth-foreground-3))
      (ido-vertical-first-match-face             (:foreground darktooth-bright-cyan :background darktooth-background-blue))
      (ido-vertical-match-face                   (:bold t))
      (ido-vertical-only-match-face              (:foreground darktooth-bright-cyan))
      (isearch                                   (:foreground darktooth-foreground-0 :background darktooth-faded-aqua))
      (isearch-fail                              (:foreground darktooth-foreground-0-hard :background darktooth-faded-red))
      (ivy-confirm-face                          (:foreground darktooth-bright-green))
      (ivy-current-match                         (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (ivy-match-required-face                   (:foreground darktooth-bright-red))
      (ivy-minibuffer-match-face-1               (:background darktooth-background-1))
      (ivy-minibuffer-match-face-2               (:background darktooth-background-2))
      (ivy-minibuffer-match-face-3               (:background darktooth-faded-aqua))
      (ivy-minibuffer-match-face-4               (:background darktooth-faded-purple))
      (ivy-remote                                (:foreground darktooth-neutral-blue))
      (js2-error                                 (:underline (:color darktooth-bright-red :style 'wave)))
      (js2-external-variable                     (:underline (:color darktooth-bright-aqua :style 'wave)))
      (js2-function-call                         (:foreground darktooth-bright-blue :background 'unspecified))
      (js2-function-param                        (:foreground darktooth-bright-aqua :background 'unspecified))
      (js2-instance-member                       (:foreground darktooth-bright-orange :background 'unspecified))
      (js2-jsdoc-html-tag-delimiter              (:foreground darktooth-foreground-3 :background 'unspecified))
      (js2-jsdoc-html-tag-name                   (:foreground darktooth-foreground-4 :background 'unspecified))
      (js2-jsdoc-tag                             (:foreground darktooth-medium :background 'unspecified))
      (js2-jsdoc-type                            (:foreground darktooth-foreground-4 :background 'unspecified))
      (js2-jsdoc-value                           (:foreground darktooth-foreground-3 :background 'unspecified))
      (js2-private-function-call                 (:foreground darktooth-faded-aqua :background 'unspecified))
      (js2-private-member                        (:foreground darktooth-faded-yellow :background 'unspecified))
      (js2-warning                               (:underline (:color darktooth-bright-yellow :style 'wave)))
      (lazy-highlight                            (:foreground darktooth-foreground-0 :background darktooth-background-2))
      (line-number                               (:foreground darktooth-background-4))
      (line-number-current-line                  (:foreground darktooth-foreground-4 :background darktooth-background-1))
      (link                                      (:foreground darktooth-bright-blue :underline t))
      (link-visited                              (:foreground darktooth-bright-blue :underline nil))
      (linum                                     (:foreground darktooth-background-4))
      (linum-relative-current-face               (:foreground darktooth-foreground-4 :background darktooth-background-1))
      (magit-bisect-bad                          (:foreground darktooth-faded-red))
      (magit-bisect-good                         (:foreground darktooth-neutral-green))
      (magit-bisect-skip                         (:foreground darktooth-foreground-2))
      (magit-blame-date                          (:inherit 'magit-blame-heading))
      (magit-blame-hash                          (:inherit 'magit-blame-heading))
      (magit-blame-heading                       (:background darktooth-background-1 :foreground darktooth-foreground-0))
      (magit-blame-name                          (:inherit 'magit-blame-heading))
      (magit-blame-summary                       (:inherit 'magit-blame-heading))
      (magit-branch                              (:foreground darktooth-turquoise4 :background 'unspecified))
      (magit-branch-local                        (:foreground darktooth-turquoise4 :background 'unspecified))
      (magit-branch-remote                       (:foreground darktooth-aquamarine4 :background 'unspecified))
      (magit-cherry-equivalent                   (:foreground darktooth-neutral-orange))
      (magit-cherry-unmatched                    (:foreground darktooth-neutral-purple))
      (magit-diff-add                            (:foreground darktooth-bright-green))
      (magit-diff-added                          (:foreground darktooth-bright-green :background darktooth-background-green))
      (magit-diff-added-highlight                (:foreground darktooth-bright-green :background darktooth-background-green))
      (magit-diff-context                        (:foreground darktooth-background-3 :background 'unspecified))
      (magit-diff-context-highlight              (:foreground darktooth-background-4 :background darktooth-background-0-soft))
      (magit-diff-del                            (:foreground darktooth-bright-red))
      (magit-diff-file-header                    (:foreground darktooth-bright-blue))
      (magit-diff-hunk-header                    (:foreground darktooth-neutral-aqua))
      (magit-diff-hunk-heading                   (:inherit 'diff-hunk-header))
      (magit-diff-hunk-heading-highlight         (:foreground darktooth-foreground-1 :background darktooth-background-3))
      (magit-diff-merge-current                  (:background darktooth-background-yellow))
      (magit-diff-merge-diff3-separator          (:foreground darktooth-neutral-orange :weight 'bold))
      (magit-diff-merge-proposed                 (:background darktooth-background-green))
      (magit-diff-merge-separator                (:foreground darktooth-neutral-orange))
      (magit-diff-none                           (:foreground darktooth-medium))
      (magit-diff-removed                        (:foreground darktooth-bright-red :background darktooth-background-red))
      (magit-diff-removed-highlight              (:foreground darktooth-bright-red :background darktooth-background-red))
      (magit-filename                            (:weight 'normal))
      (magit-head                                (:inherit 'magit-branch-local))
      (magit-item-highlight                      (:background darktooth-background-1 :weight 'normal))
      (magit-item-mark                           (:background darktooth-background-0))
      (magit-key-mode-args-face                  (:foreground darktooth-foreground-4))
      (magit-key-mode-button-face                (:foreground darktooth-neutral-orange :weight 'bold))
      (magit-key-mode-header-face                (:foreground darktooth-foreground-4 :weight 'bold))
      (magit-key-mode-switch-face                (:foreground darktooth-turquoise4 :weight 'bold))
      (magit-log-author                          (:foreground darktooth-neutral-aqua))
      (magit-log-date                            (:foreground darktooth-faded-orange))
      (magit-log-graph                           (:foreground darktooth-foreground-1))
      (magit-log-head-label-bisect-bad           (:foreground darktooth-bright-red))
      (magit-log-head-label-bisect-good          (:foreground darktooth-bright-green))
      (magit-log-head-label-bisect-skip          (:foreground darktooth-neutral-yellow))
      (magit-log-head-label-default              (:foreground darktooth-neutral-blue))
      (magit-log-head-label-head                 (:foreground darktooth-foreground-0 :background darktooth-background-aqua))
      (magit-log-head-label-local                (:foreground darktooth-faded-blue :weight 'bold))
      (magit-log-head-label-patches              (:foreground darktooth-faded-orange))
      (magit-log-head-label-remote               (:foreground darktooth-neutral-blue :weight 'bold))
      (magit-log-head-label-tags                 (:foreground darktooth-neutral-aqua))
      (magit-log-head-label-wip                  (:foreground darktooth-neutral-red))
      (magit-log-message                         (:foreground darktooth-foreground-1))
      (magit-log-reflog-label-amend              (:foreground darktooth-bright-blue))
      (magit-log-reflog-label-checkout           (:foreground darktooth-bright-yellow))
      (magit-log-reflog-label-cherry-pick        (:foreground darktooth-neutral-red))
      (magit-log-reflog-label-commit             (:foreground darktooth-neutral-green))
      (magit-log-reflog-label-merge              (:foreground darktooth-bright-green))
      (magit-log-reflog-label-other              (:foreground darktooth-faded-red))
      (magit-log-reflog-label-rebase             (:foreground darktooth-bright-blue))
      (magit-log-reflog-label-remote             (:foreground darktooth-neutral-orange))
      (magit-log-reflog-label-reset              (:foreground darktooth-neutral-yellow))
      (magit-log-sha1                            (:foreground darktooth-bright-orange))
      (magit-popup-disabled-argument             (:foreground darktooth-foreground-4))
      (magit-process-ng                          (:foreground darktooth-bright-red :weight 'bold))
      (magit-process-ok                          (:foreground darktooth-bright-green :weight 'bold))
      (magit-refname                             (:foreground darktooth-foreground-2))
      (magit-refname-stash                       (:inherit 'magit-refname))
      (magit-refname-wip                         (:inherit 'magit-refname))
      (magit-section-heading                     (:foreground darktooth-foreground-2 :background darktooth-background-blue))
      (magit-section-highlight                   (:background darktooth-background-0-soft))
      (magit-sequence-done                       (:inherit 'magit-hash))
      (magit-sequence-drop                       (:foreground darktooth-faded-red))
      (magit-sequence-head                       (:foreground darktooth-faded-cyan))
      (magit-sequence-onto                       (:inherit 'magit-sequence-done))
      (magit-sequence-part                       (:foreground darktooth-bright-yellow))
      (magit-sequence-pick                       (:inherit 'default))
      (magit-sequence-stop                       (:foreground darktooth-bright-aqua))
      (magit-signature-bad                       (:foreground darktooth-bright-red :weight 'bold))
      (magit-signature-good                      (:foreground darktooth-bright-green :weight 'bold))
      (magit-signature-none                      (:foreground darktooth-faded-red))
      (magit-signature-untrusted                 (:foreground darktooth-bright-purple :weight 'bold))
      (magit-tag                                 (:foreground darktooth-darkslategray4))
      (magit-whitespace-warning-face             (:background darktooth-faded-red))
      (markdown-header-face-1                    (:height 1.9 :inherit 'variable-pitch :foreground darktooth-foreground-4))
      (markdown-header-face-2                    (:height 1.8 :inherit 'variable-pitch :foreground darktooth-foreground-3))
      (markdown-header-face-3                    (:height 1.6 :inherit 'variable-pitch :foreground darktooth-foreground-2))
      (markdown-header-face-4                    (:height 1.5 :inherit 'variable-pitch :foreground darktooth-foreground-1))
      (markdown-header-face-5                    (:height 1.4 :inherit 'variable-pitch :foreground darktooth-foreground-0-soft))
      (markdown-header-face-6                    (:height 1.3 :inherit 'variable-pitch :foreground darktooth-foreground-0))
      (match                                     (:foreground darktooth-foreground-0 :background darktooth-background-2))
      (message-cited-text                        (:foreground darktooth-foreground-3))
      (message-header-cc                         (:foreground darktooth-bright-cyan))
      (message-header-name                       (:foreground darktooth-bright-cyan))
      (message-header-newsgroups                 (:foreground darktooth-bright-cyan))
      (message-header-other                      (:foreground darktooth-muted-cyan))
      (message-header-subject                    (:foreground darktooth-foreground-2))
      (message-header-to                         (:foreground darktooth-bright-cyan))
      (message-header-xheader                    (:foreground darktooth-faded-cyan))
      (message-mml                               (:foreground darktooth-faded-aqua))
      (message-separator                         (:foreground darktooth-faded-cyan))
      (minibuffer-prompt                         (:foreground darktooth-bright-cyan :background darktooth-background-0 :bold nil))
      (mode-line                                 (:foreground darktooth-foreground-1 :background darktooth-background-0-hard :box nil))
      (mode-line-inactive                        (:foreground darktooth-foreground-4 :background darktooth-background-2 :box nil))
      (orderless-match-face-0                    (:foreground darktooth-foreground-1))
      (orderless-match-face-1                    (:foreground darktooth-foreground-2))
      (orderless-match-face-2                    (:foreground darktooth-foreground-3))
      (orderless-match-face-3                    (:foreground darktooth-foreground-4))
      (org-agenda-date-today                     (:foreground darktooth-foreground-2 :slant 'italic :weight 'bold))
      (org-agenda-structure                      (:inherit 'font-lock-comment-face))
      (org-archived                              (:foreground darktooth-foreground-0 :weight 'bold))
      (org-checkbox                              (:foreground darktooth-foreground-2 :background darktooth-background-0 :box (:line-width 1 :style 'released-button)))
      (org-column                                (:background darktooth-background-0))
      (org-column-title                          (:background darktooth-background-0-hard :underline t :weight 'bold))
      (org-date                                  (:foreground darktooth-faded-aqua :underline t))
      (org-deadline-announce                     (:foreground darktooth-faded-red))
      (org-document-info                         (:foreground darktooth-identifiers-7))
      (org-document-info-keyword                 (:foreground darktooth-foreground-2))
      (org-document-title                        (:foreground darktooth-bright-cyan :weight 'bold))
      (org-done                                  (:foreground darktooth-bright-green :bold t :weight 'bold))
      (org-ellipsis                              (:foreground darktooth-bright-yellow :underline t))
      (org-footnote                              (:foreground darktooth-faded-aqua :underline t))
      (org-formula                               (:foreground darktooth-bright-yellow))
      (org-headline-done                         (:foreground darktooth-bright-green))
      (org-hide                                  (:foreground darktooth-background-0))
      (org-level-1                               (:foreground darktooth-bright-orange))
      (org-level-2                               (:foreground darktooth-bright-green))
      (org-level-3                               (:foreground darktooth-bright-blue))
      (org-level-4                               (:foreground darktooth-bright-yellow))
      (org-level-5                               (:foreground darktooth-faded-aqua))
      (org-level-6                               (:foreground darktooth-bright-green))
      (org-level-7                               (:foreground darktooth-bright-red))
      (org-level-8                               (:foreground darktooth-bright-blue))
      (org-link                                  (:foreground darktooth-bright-yellow :underline t))
      (org-mode-line-clock                       (:foreground darktooth-foreground-2 :background darktooth-background-0))
      (org-mode-line-clock-overrun               (:foreground darktooth-black :background darktooth-bright-red))
      (org-scheduled                             (:foreground darktooth-bright-green))
      (org-scheduled-previously                  (:foreground darktooth-bright-red))
      (org-scheduled-today                       (:foreground darktooth-bright-blue))
      (org-sexp-date                             (:foreground darktooth-bright-blue :underline t))
      (org-special-keyword                       (:inherit 'font-lock-comment-face))
      (org-table                                 (:foreground darktooth-bright-green))
      (org-tag                                   (:bold t :weight 'bold))
      (org-time-grid                             (:foreground darktooth-bright-orange))
      (org-todo                                  (:foreground darktooth-bright-red :weight 'bold :bold t))
      (org-upcoming-deadline                     (:inherit 'font-lock-keyword-face))
      (org-warning                               (:foreground darktooth-bright-red :weight 'bold :underline nil :bold t))
      (popup-face                                (:foreground darktooth-foreground-0 :background darktooth-background-1))
      (popup-menu-mouse-face                     (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (popup-menu-selection-face                 (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (popup-tip-face                            (:foreground darktooth-foreground-0-hard :background darktooth-background-aqua))
      (powerline-active1                         (:background darktooth-background-2 :inherit 'mode-line))
      (powerline-active2                         (:background darktooth-background-1 :inherit 'mode-line))
      (powerline-inactive1                       (:background darktooth-medium :inherit 'mode-line-inactive))
      (powerline-inactive2                       (:background darktooth-background-2 :inherit 'mode-line-inactive))
      (rainbow-delimiters-depth-1-face           (:foreground darktooth-delimiter-one))
      (rainbow-delimiters-depth-10-face          (:foreground darktooth-delimiter-two))
      (rainbow-delimiters-depth-11-face          (:foreground darktooth-delimiter-three))
      (rainbow-delimiters-depth-12-face          (:foreground darktooth-delimiter-four))
      (rainbow-delimiters-depth-2-face           (:foreground darktooth-delimiter-two))
      (rainbow-delimiters-depth-3-face           (:foreground darktooth-delimiter-three))
      (rainbow-delimiters-depth-4-face           (:foreground darktooth-delimiter-four))
      (rainbow-delimiters-depth-5-face           (:foreground darktooth-delimiter-one))
      (rainbow-delimiters-depth-6-face           (:foreground darktooth-delimiter-two))
      (rainbow-delimiters-depth-7-face           (:foreground darktooth-delimiter-three))
      (rainbow-delimiters-depth-8-face           (:foreground darktooth-delimiter-four))
      (rainbow-delimiters-depth-9-face           (:foreground darktooth-delimiter-one))
      (rainbow-delimiters-unmatched-face         (:foreground darktooth-foreground-0 :background 'unspecified))
      (rainbow-identifiers-identifier-1          (:foreground darktooth-identifiers-1))
      (rainbow-identifiers-identifier-10         (:foreground darktooth-identifiers-10))
      (rainbow-identifiers-identifier-11         (:foreground darktooth-identifiers-11))
      (rainbow-identifiers-identifier-12         (:foreground darktooth-identifiers-12))
      (rainbow-identifiers-identifier-13         (:foreground darktooth-identifiers-13))
      (rainbow-identifiers-identifier-14         (:foreground darktooth-identifiers-14))
      (rainbow-identifiers-identifier-15         (:foreground darktooth-identifiers-15))
      (rainbow-identifiers-identifier-2          (:foreground darktooth-identifiers-2))
      (rainbow-identifiers-identifier-3          (:foreground darktooth-identifiers-3))
      (rainbow-identifiers-identifier-4          (:foreground darktooth-identifiers-4))
      (rainbow-identifiers-identifier-5          (:foreground darktooth-identifiers-5))
      (rainbow-identifiers-identifier-6          (:foreground darktooth-identifiers-6))
      (rainbow-identifiers-identifier-7          (:foreground darktooth-identifiers-7))
      (rainbow-identifiers-identifier-8          (:foreground darktooth-identifiers-8))
      (rainbow-identifiers-identifier-9          (:foreground darktooth-identifiers-9))
      (region                                    (:background darktooth-mid-blue :distant-foreground darktooth-foreground-0))
      (ripgrep-hit-face                          (:inherit 'ag-hit-face))
      (ripgrep-match-face                        (:inherit 'ag-match-face))
      (secondary-selection                       (:background darktooth-background-blue))
      (sh-heredoc                                (:foreground darktooth-darkslategray4 :background 'unspecified))
      (sh-quoted-exec                            (:foreground darktooth-darkslategray4 :background 'unspecified))
      (show-paren-match                          (:foreground darktooth-foreground-0 :background darktooth-faded-blue))
      (show-paren-mismatch                       (:foreground darktooth-foreground-0-hard :background darktooth-faded-red))
      (smerge-base                               (:background darktooth-background-yellow))
      (smerge-lower                              (:background darktooth-mid-blue))
      (smerge-markers                            (:background darktooth-background-0-soft))
      (smerge-refine-changed                     (:background 'unspecified :foreground 'unspecified))
      (smerge-refined-added                      (:background darktooth-background-green))
      (smerge-refined-removed                    (:background darktooth-background-red))
      (smerge-upper                              (:background darktooth-mid-purple))
      (sml/charging                              (:foreground darktooth-faded-aqua))
      (sml/col-number                            (:foreground darktooth-neutral-orange))
      (sml/discharging                           (:foreground darktooth-faded-aqua :weight 'bold))
      (sml/filename                              (:foreground darktooth-foreground-0-hard :weight 'bold :bold t))
      (sml/git                                   (:inherit 'sml/prefix))
      (sml/minor-modes                           (:foreground darktooth-neutral-orange))
      (sml/modes                                 (:foreground darktooth-foreground-0-hard :weight 'bold :bold t))
      (sml/modified                              (:foreground darktooth-neutral-blue))
      (sml/outside-modified                      (:foreground darktooth-neutral-blue))
      (sml/position-percentage                   (:foreground darktooth-faded-aqua))
      (sml/prefix                                (:foreground darktooth-neutral-blue))
      (sml/process                               (:inherit 'sml/prefix))
      (sml/read-only                             (:foreground darktooth-neutral-blue))
      (sml/sudo                                  (:foreground darktooth-background-orange :weight 'bold))
      (sml/vc                                    (:foreground darktooth-faded-green))
      (sml/vc-edited                             (:foreground darktooth-bright-green))
      (sp-pair-overlay-face                      (:background darktooth-background-2))
      (sp-show-pair-match-face                   (:background darktooth-background-2))
      (sp-show-pair-mismatch-face                (:background darktooth-neutral-red))
      (success                                   (:foreground darktooth-neutral-green :bold t))
      (swoop-face-header-format-line             (:foreground darktooth-white :background darktooth-muted-blue :height 1.3 :weight 'bold))
      (swoop-face-line-buffer-name               (:foreground darktooth-foreground-2 :background darktooth-background-1))
      (swoop-face-line-number                    (:foreground darktooth-neutral-orange))
      (swoop-face-target-line                    (:foreground darktooth-foreground-0-hard :background darktooth-faded-blue))
      (swoop-face-target-words                   (:foreground darktooth-foreground-0 :background darktooth-faded-aqua))
      (tab-bar                                   (:foreground darktooth-foreground-0 :background darktooth-background-0))
      (tab-bar-tab                               (:foreground darktooth-foreground-0 :background darktooth-background-0))
      (tab-bar-tab-inactive                      (:foreground darktooth-foreground-0 :background darktooth-background-0))
      (tab-line                                  (:foreground darktooth-foreground-0 :background darktooth-background-0))
      (term-color-black                          (:foreground darktooth-background-1))
      (term-color-blue                           (:foreground darktooth-neutral-blue))
      (term-color-cyan                           (:foreground darktooth-neutral-cyan))
      (term-color-green                          (:foreground darktooth-neutral-green))
      (term-color-magenta                        (:foreground darktooth-neutral-purple))
      (term-color-red                            (:foreground darktooth-neutral-red))
      (term-color-white                          (:foreground darktooth-foreground-1))
      (term-color-yellow                         (:foreground darktooth-neutral-yellow))
      (term-default-bg-color                     (:background darktooth-background-0))
      (term-default-fg-color                     (:foreground darktooth-foreground-0))
      (tldr-code-block                           (:foreground darktooth-bright-blue :bold t))
      (tldr-command-argument                     (:foreground darktooth-bright-green :bold t))
      (tldr-command-itself                       (:foreground darktooth-bright-red :bold t))
      (tldr-description                          (:inherit 'default))
      (tldr-introduction                         (:inherit 'font-lock-comment-face :slant 'italic))
      (tldr-title                                (:foreground darktooth-bright-red :bold t :height 1.2))
      (vertico-posframe                          (:background darktooth-background-0-hard))
      (vertico-posframe-border                   (:background darktooth-background-0-hard))
      (vertico-posframe-border-2                 (:background darktooth-background-0))
      (vertico-posframe-border-3                 (:background darktooth-background-1))
      (vertico-posframe-border-4                 (:background darktooth-background-2))
      (vline                                     (:background darktooth-background-aqua))
      (vline-visual                              (:background darktooth-background-aqua))
      (warning                                   (:foreground darktooth-bright-yellow :bold t))
      (web-mode-doctype-face                     (:foreground darktooth-foreground-2 :weight 'bold))
      (web-mode-html-attr-equal-face             (:inherit 'default))
      (web-mode-html-attr-name-face              (:inherit 'font-lock-variable-name-face))
      (web-mode-html-tag-bracket-face            (:inherit 'default))
      (web-mode-html-tag-face                    (:foreground darktooth-foreground-3))
      (which-func                                (:inherit 'font-lock-function-name-face))
      (which-key-key-face                        (:inherit 'font-lock-variable-name-face))
      (whitespace-empty                          (:foreground 'unspecified :background 'unspecified))
      (whitespace-hspace                         (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-indentation                    (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-line                           (:foreground darktooth-neutral-red :background darktooth-background-1))
      (whitespace-newline                        (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-space                          (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-space-after-tab                (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-space-before-tab               (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-tab                            (:foreground darktooth-background-4 :background darktooth-background-0))
      (whitespace-trailing                       (:foreground darktooth-neutral-red :background darktooth-background-1))
      (window-divider                            (:foreground darktooth-background-1))
      (window-divider-last-pixel                 (:foreground darktooth-background-1))
      (window-divider-first-pixel                (:foreground darktooth-background-1))
      (woman-bold                                (:foreground darktooth-bright-red :bold t))
      (woman-italic                              (:foreground darktooth-bright-green :bold t)))
    ,@body))

;;;###autoload
(and load-file-name
     (boundp 'custom-theme-load-path)
     (add-to-list 'custom-theme-load-path
                  (file-name-as-directory
                   (file-name-directory load-file-name))))

(provide 'darktooth)

;; Local Variables:
;; eval: (when (fboundp 'rainbow-mode) (rainbow-mode 1))
;; End:

;;; darktooth.el ends here
