;;; doing-finish.el --- Finish current activity for doing.el -*- lexical-binding: t; -*-

;; Copyright (C) 2026 Xiaoxing Hu

;; Author: Xiaoxing Hu <hi@xiaoxing.dev>
;; SPDX-License-Identifier: GPL-3.0-or-later

;; This file is NOT part of GNU Emacs.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;; Commands for finishing the current unfinished activity.
;; Marks the current activity as complete by setting ENDED timestamp
;; and computing the DURATION.

;;; Code:

(require 'doing-lib)
(require 'doing-current)

;;;###autoload
(defun doing-finish ()
  "Finish the current activity.
Sets the ENDED property to current time and computes DURATION.
Signals a user-error if no activity is in progress."
  (interactive)
  (if-let ((entry (doing--current-entry)))
      (let* ((id (plist-get entry :id))
             (title (plist-get entry :title))
             (started (plist-get entry :started))
             (ended (doing--timestamp-now))
             (duration (doing--duration-minutes started ended)))
        (doing--update-entry-property id "ENDED" ended)
        (doing--update-entry-property id "DURATION"
                                      (doing--duration-format duration))
        (message "Finished: %s (%s)" title (doing--duration-format duration)))
    (user-error "No activity in progress")))

(provide 'doing-finish)

;;; doing-finish.el ends here
