;;; gcode-mode-doc.el --- G-Code documentation entries  -*- lexical-binding: t -*-
;; WARNING! This file is automatically generated using scripts in docgen/!

(defun gcode-mode--doc-entries () '(
  ("D-1" "Endless Loop")
  ("D0" "Reset")
  ("D1" "Clear EEPROM and RESET")
  ("D2" "Read/Write RAM")
  ("D3" "Read/Write EEPROM")
  ("D4" "Read/Write PIN")
  ("D5" "Read/Write FLASH")
  ("D6" "Read/Write external FLASH")
  ("D7" "Read/Write Bootloader")
  ("D8" "Read/Write PINDA")
  ("D9" "Read/Write ADC")
  ("D10" "Set XYZ calibration = OK")
  ("D12" "Time")
  ("D80" "Bed check")
  ("D81" "Bed analysis")
  ("D106" "Print measured fan speed for different pwm values")
  ("D2130" "Trinamic stepper controller")
  ("D9125" "PAT9125 filament sensor")
  ("G0" "Linear Move" ?A "An absolute or relative coordinate on the A axis (in current units)" ?B "An absolute or relative coordinate on the B axis (in current units)" ?C "An absolute or relative coordinate on the C axis (in current units)" ?E "An absolute or relative coordinate on the E (extruder) axis (in current units)" ?F "Set the requested movement rate for this move and any following moves" ?S "Set the laser power for the move" ?U "An absolute or relative coordinate on the U axis (in current units)" ?V "An absolute or relative coordinate on the V axis (in current units)" ?W "An absolute or relative coordinate on the W axis (in current units)" ?X "An absolute or relative coordinate on the X axis (in current units)" ?Y "An absolute or relative coordinate on the Y axis (in current units)" ?Z "An absolute or relative coordinate on the Z axis (in current units)")
  ("G1" "Linear Move" ?A "An absolute or relative coordinate on the A axis (in current units)" ?B "An absolute or relative coordinate on the B axis (in current units)" ?C "An absolute or relative coordinate on the C axis (in current units)" ?E "An absolute or relative coordinate on the E (extruder) axis (in current units)" ?F "Set the requested movement rate for this move and any following moves" ?S "Set the laser power for the move" ?U "An absolute or relative coordinate on the U axis (in current units)" ?V "An absolute or relative coordinate on the V axis (in current units)" ?W "An absolute or relative coordinate on the W axis (in current units)" ?X "An absolute or relative coordinate on the X axis (in current units)" ?Y "An absolute or relative coordinate on the Y axis (in current units)" ?Z "An absolute or relative coordinate on the Z axis (in current units)")
  ("G2" "Arc or Circle Move" ?A "A coordinate on the A axis" ?B "A coordinate on the B axis" ?C "A coordinate on the C axis" ?E "The amount to extrude between the start point and end point" ?F "The nominal movement rate" ?I "An offset from the current X position to use as the arc center" ?J "An offset from the current Y position to use as the arc center" ?P "Specify complete circles" ?R "A radius from the current XY position to use as the arc center" ?S "Set the Laser power for the move" ?U "A coordinate on the U axis" ?V "A coordinate on the V axis" ?W "A coordinate on the W axis" ?X "A coordinate on the X axis" ?Y "A coordinate on the Y axis" ?Z "A coordinate on the Z axis")
  ("G3" "Arc or Circle Move" ?A "A coordinate on the A axis" ?B "A coordinate on the B axis" ?C "A coordinate on the C axis" ?E "The amount to extrude between the start point and end point" ?F "The nominal movement rate" ?I "An offset from the current X position to use as the arc center" ?J "An offset from the current Y position to use as the arc center" ?P "Specify complete circles" ?R "A radius from the current XY position to use as the arc center" ?S "Set the Laser power for the move" ?U "A coordinate on the U axis" ?V "A coordinate on the V axis" ?W "A coordinate on the W axis" ?X "A coordinate on the X axis" ?Y "A coordinate on the Y axis" ?Z "A coordinate on the Z axis")
  ("G4" "Dwell" ?P "Amount of time to dwell" ?S "Amount of time to dwell")
  ("G5" "Bézier Cubic Spline Move" ?E "The length of filament to feed into the extruder between the start and end point" ?F "The maximum feedrate of the move between the start and end point (in current units per second)" ?I "Offset from the X start point to first control point" ?J "Offset from the Y start point to first control point" ?P "Offset from the X end point to second control point" ?Q "Offset from the Y end point to the second control point" ?S "Set the Laser power for the move" ?X "A destination coordinate on the X axis" ?Y "A destination coordinate on the Y axis")
  ("G6" "Direct Stepper Move" ?E "1 for positive, 0 for negative" ?I "Set page index" ?R "Step rate per second" ?S "Number of steps to take" ?X "1 for positive, 0 for negative" ?Y "1 for positive, 0 for negative" ?Z "1 for positive, 0 for negative")
  ("G10" "Retract" ?S "Use G10 S1 to do a swap retraction, before changing extruders")
  ("G11" "Recover")
  ("G12" "Clean the Nozzle" ?P "Pattern style selection" ?R "Radius of nozzle cleaning circle" ?S "Number of repetitions of the pattern" ?T "Number of triangles in the zigzag pattern" ?X "Include X motion when cleaning with limited axes" ?Y "Include Y motion when cleaning with limited axes" ?Z "Include Z motion when cleaning with limited axes")
  ("G17" "CNC Workspace Planes")
  ("G18" "CNC Workspace Planes")
  ("G19" "CNC Workspace Planes")
  ("G20" "Inch Units")
  ("G21" "Millimeter Units")
  ("G22" "Firmware Retract")
  ("G23" "Firmware Recover")
  ("G26" "Mesh Validation Pattern" ?B "Bed temperature (otherwise 60°C) to use for the test print" ?C "Continue with the closest point (otherwise, don't)" ?D "Disable leveling compensation (otherwise, enable)" ?F "Filament diameter (otherwise 1.75mm)" ?H "Hot end temperature (otherwise 205°C) to use for the test print" ?I "Material preset to use for the test print" ?K "Keep heaters on when done" ?L "Layer height to use for the test" ?O "Ooze amount (otherwise 0.3mm)" ?P "Prime Length" ?Q "Retraction multiplier" ?R "Number of G26 Repetitions (otherwise 999)" ?S "Nozzle size (otherwise 0.4mm)" ?U "Random deviation" ?X "X position (otherwise, current X position)" ?Y "Y position (otherwise, current Y position)")
  ("G27" "Park toolhead" ?P "Parking behavior")
  ("G28" "Auto Home" ?A "Flag to home the A axis" ?B "Flag to home the B axis" ?C "Flag to home the C axis" ?H "Flag to hold the current X/Y position" ?L "Flag to restore bed leveling state after homing" ?O "Flag to skip homing if the position is already trusted" ?R "The distance to raise the nozzle before homing" ?U "Flag to home the U axis" ?V "Flag to home the V axis" ?W "Flag to home the W axis" ?X "Flag to home the X axis" ?Y "Flag to home the Y axis" ?Z "Flag to home the Z axis")
  ("G29" "Bed Leveling")
  ("G29" "Bed Leveling (3-Point)" ?A "Abort leveling procedure in-progress (PROBE_MANUALLY)" ?C "Create fake points for testing" ?D "Dry-Run mode" ?E "" ?J "Jettison the leveling data stored in SRAM and turn off leveling compensation" ?O "Optional" ?Q "Query the current leveling state (PROBE_MANUALLY, DEBUG_LEVELING_FEATURE)" ?V "Set the verbose level")
  ("G29" "Bed Leveling (Bilinear)" ?A "Abort leveling procedure in-progress (PROBE_MANUALLY)" ?B "Set the back limit of the probing grid" ?C "Create a fake grid for testing" ?D "Dry-Run mode" ?E "" ?F "Set the front limit of the probing grid" ?H "Set the square width and height of the area to probe" ?J "(Without W) Jettison the leveling data stored in SRAM and turn off leveling compensation" ?L "Set the left limit of the probing grid" ?O "Optional" ?Q "Query the current leveling state (PROBE_MANUALLY, DEBUG_LEVELING_FEATURE)" ?R "Set the right limit of the probing grid" ?S "Set the XY travel speed between probe points" ?V "Set the verbose level" ?W "Write a mesh Z offset" ?X "Specify X when setting a mesh value (PROBE_MANUALLY)" ?Y "Specify Y when setting a mesh value" ?Z "Specify the Z offset when setting a mesh value")
  ("G29" "Bed Leveling (Linear)" ?A "Abort leveling procedure in-progress (PROBE_MANUALLY)" ?B "Set the back limit of the probing grid" ?C "Create a fake grid for testing" ?D "Dry-Run mode" ?E "" ?F "Set the front limit of the probing grid" ?H "Set the square width and height of the area to probe" ?J "Jettison the leveling data stored in SRAM and turn off leveling compensation" ?L "Set the left limit of the probing grid" ?O "Optional" ?P "Set the size of the square grid that will be probed - P x P points" ?Q "Query the current leveling state (PROBE_MANUALLY, DEBUG_LEVELING_FEATURE)" ?R "Set the right limit of the probing grid" ?S "Set the XY travel speed between probe points" ?T "Generate a Bed Topology Report" ?V "Set the verbose level" ?X "Set the number of columns (in X) that will be probed" ?Y "Set the number of rows (in Y) that will be probed")
  ("G29" "Bed Leveling (Manual)" ?I "With S3, the (0...n-1) X index of the mesh value to modify" ?J "With S3, the (0...n-1) Y index of the mesh value to modify" ?S nil ?X "With S3, the (1...n) X count of the mesh value to modify" ?Y "With S3, the (1...n) Y count of the mesh value to modify" ?Z "With S3, the new mesh Z value")
  ("G29" "Bed Leveling (Unified)" ?A "*Activate* Unified Bed Leveling (i.e., M420 S1)" ?B "*Business Card* mode (P2 only)" ?C "" ?D "Disable Unified Bed Leveling (i.e., M420 S0)" ?E "Stow probe after probing Each point (P1 only)" ?F "*Fade* height" ?H "*Height*:" ?I "*Invalidate* a number of mesh points (default 1)" ?J "*Grid* (or 3-Point) leveling:" ?K "*Kompare*: Subtract (diff) the stored mesh with this index from the current mesh" ?L "*Load* a mesh" ?P "*Phase*: The Phase commands are used for the bulk of the work to setup a Mesh" ?Q "Test Pattern" ?R "Repeat count" ?S "*Save* the mesh to EEPROM in the given slot" ?T "*Topology*: Include a Topology Map in the output in one of two styles" ?U "*Unlevel*: Probe the outer perimeter to assist bed tramming" ?V "Verbosity Level (0-4)" ?W "*_What?_*: Display valuable UBL data" ?X "*X position* for all phases and commands (Default: current X)" ?Y "*Y position* for all phases and commands (Default: current Y)")
  ("G29.1" "Set Z probe head offset")
  ("G29.2" "Set Z probe head offset calculated from toolhead position")
  ("G30" "Single Z-Probe" ?C "Probe with temperature compensation enabled (PTC_PROBE, PTC_BED, PTC_HOTEND)" ?E "Engage the probe for each point" ?X "X probe position" ?Y "Y probe position")
  ("G31" "Dock Sled")
  ("G32" "Undock Sled")
  ("G33" "Delta Auto Calibration" ?C "Calibration precision" ?E "Engage the probe for each point" ?F "Run (\"force\") this number of iterations and take the best result" ?O "Probe at probe-offset-relative positions instead of the required kinematic points" ?P "Number of probe points" ?R "Temporarily reduce the size of the probe grid by the specified amount" ?S "Save offset_sensorless_adj" ?T "Disable tower angle corrections calibration (P3-P7)" ?V "Set the verbose level" ?X "Don't activate stallguard on X" ?Y "Don't activate stallguard on Y" ?Z "Don't activate stallguard on Z")
  ("G34" "Mechanical Gantry Calibration" ?S "Current value to use for the raise move" ?Z "Extra distance past Z_MAX_POS to move the Z axis")
  ("G34" "Z Steppers Auto-Alignment" ?A "Amplification - must be between 0.5 - 2.0" ?E "Stow probe after probing each point" ?I "Iterations - must be between 1 - 30" ?L "Unlock all Z stepper motors" ?R "Recalculate points based on current probe offsets" ?S "Lock state; 0=UNLOCKED 1=LOCKED" ?T "Target accuracy - must be between 0.01 - 1.0" ?Z "Target specific Z stepper to lock/unlock (1-4)")
  ("G35" "Tramming Assistant" ?S "Screw thread type")
  ("G38" "Straight Probe (CNC specific)")
  ("G38.2" "Probe target" ?F "Feedrate for the move" ?X "Target X" ?Y "Target Y" ?Z "Target Z")
  ("G38.3" "Probe target" ?F "Feedrate for the move" ?X "Target X" ?Y "Target Y" ?Z "Target Z")
  ("G38.4" "Probe target" ?F "Feedrate for the move" ?X "Target X" ?Y "Target Y" ?Z "Target Z")
  ("G38.5" "Probe target" ?F "Feedrate for the move" ?X "Target X" ?Y "Target Y" ?Z "Target Z")
  ("G40" "Compensation Off (CNC specific)")
  ("G42" "Move to mesh coordinate" ?F "The maximum movement rate of the move between the start and end point" ?I "The column of the mesh coordinate" ?J "The row of the mesh coordinate" ?P "If there is a probe, move it to the given position")
  ("G53" "Move in Machine Coordinates")
  ("G54" "Select Workspace")
  ("G55" "Select Workspace")
  ("G56" "Select Workspace")
  ("G57" "Select Workspace")
  ("G58" "Select Workspace")
  ("G59" "Select Workspace")
  ("G59.1" "Select Workspace")
  ("G59.2" "Select Workspace")
  ("G59.3" "Select Workspace")
  ("G60" "Stored Positions" ?D "Delete stored position(s)" ?E "With G60 Q: Restore the E axis (with optional offset)" ?F "With G60 Q: Requested feedrate" ?Q "Restore (move to) a stored position" ?S "Memory slot" ?X "With G60 Q: Restore the X axis (with optional offset)" ?Y "With G60 Q: Restore the Y axis (with optional offset)" ?Z "With G60 Q: Restore the Z axis (with optional offset)")
  ("G61" "Return to Saved Position" ?E "Restore the E axis (with optional offset)" ?F "Requested feedrate" ?S "Memory slot (0 if omitted)" ?X "Restore the X axis (with optional offset)" ?Y "Restore the Y axis (with optional offset)" ?Z "Restore the Z axis (with optional offset)")
  ("G75" "Print temperature interpolation")
  ("G76" "Probe temperature calibration" ?B "Calibrate bed only" ?P "Calibrate probe only")
  ("G80" "Cancel Current Motion Mode")
  ("G81" "Mesh bed leveling status")
  ("G82" "Single Z probe at current location")
  ("G83" "Babystep in Z and store to EEPROM")
  ("G84" "UNDO Babystep Z (move Z axis back)")
  ("G85" "Pick best babystep")
  ("G86" "Disable babystep correction after home")
  ("G87" "Enable babystep correction after home")
  ("G88" "Reserved")
  ("G90" "Absolute Positioning")
  ("G91" "Relative Positioning")
  ("G92" "Set Position" ?A "New A axis position" ?B "New B axis position" ?C "New C axis position" ?E "New extruder position" ?U "New U axis position" ?V "New V axis position" ?W "New W axis position" ?X "New X axis position" ?Y "New Y axis position" ?Z "New Z axis position")
  ("G92.1" "Reset Coordinate System Offsets (CNC specific)")
  ("G92.2" "Reset Coordinate System Offsets (CNC specific)")
  ("G93" "Feed Rate Mode (Inverse Time Mode) (CNC specific)")
  ("G94" "Feed Rate Mode (Units per Minute) (CNC specific)")
  ("G98" "Activate farm mode")
  ("G99" "Deactivate farm mode")
  ("G100" "Calibrate floor or rod radius")
  ("G130" "Set digital potentiometer value")
  ("G131" "Remove offset")
  ("G132" "Calibrate endstop offsets")
  ("G133" "Measure steps to top")
  ("G161" "Home axes to minimum")
  ("G162" "Home axes to maximum")
  ("G425" "Backlash Calibration" ?B "Perform calibration of backlash only" ?T "Perform calibration of one toolhead only" ?U "Uncertainty: how far to start probe away from the cube (mm)" ?V "Probe cube and print position, error, backlash and hotend offset")
  ("M0" "Unconditional stop" ?P "Expire time, in milliseconds" ?S "Expire time, in seconds")
  ("M1" "Unconditional stop" ?P "Expire time, in milliseconds" ?S "Expire time, in seconds")
  ("M2" "Program End")
  ("M3" "Spindle CW / Laser On" ?I "Inline mode ON / OFF" ?O "Spindle speed or laser power in PWM 0-255 value range" ?S "Spindle speed or laser power in the configured value range (see CUTTER_POWER_DISPLAY)")
  ("M4" "Spindle CCW / Laser On" ?I "Inline mode ON / OFF" ?O "Spindle speed or laser power in PWM 0-255 value range" ?S "Spindle speed or laser power in the configured value range (see CUTTER_POWER_UNIT)")
  ("M5" "Spindle / Laser Off")
  ("M6" "Tool change")
  ("M7" "Coolant Controls")
  ("M8" "Coolant Controls")
  ("M9" "Coolant Controls")
  ("M10" "Vacuum / Blower Control")
  ("M11" "Vacuum / Blower Control")
  ("M13" "Spindle on (clockwise rotation) and coolant on (flood)")
  ("M16" "Expected Printer Check")
  ("M17" "Enable Steppers" ?A "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?B "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?C "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?E "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?U "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?V "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?W "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?X "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?Y "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?Z "Enable Axes such as X, Y, Z, E, A, B, C, U, V, W")
  ("M18" "Disable steppers" ?A "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?B "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?C "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?E "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?S "Set the inactivity timeout" ?U "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?V "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?W "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?X "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?Y "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?Z "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W")
  ("M20" "List SD Card" ?F "Only list BIN files" ?L "Include the long filename in the listing" ?T "Include the file timestamp in the listing")
  ("M21" "Init SD card")
  ("M22" "Release SD card")
  ("M23" "Select SD file")
  ("M24" "Start or Resume SD print" ?S "Position in file to resume from (requires POWER_LOSS_RECOVERY)" ?T "Elapsed time since start of print (requires POWER_LOSS_RECOVERY)")
  ("M25" "Pause SD print")
  ("M26" "Set SD position" ?S "Next file read position to set")
  ("M27" "Report SD print status" ?C "Report the filename and long filename of the current file" ?S "Interval between auto-reports")
  ("M28" "Start SD write")
  ("M29" "Stop SD write")
  ("M30" "Delete SD file")
  ("M31" "Report Print Time")
  ("M32" "Select and Start" ?P "Sub-program type" ?S "Starting file offset")
  ("M33" "Get Long Path")
  ("M34" "SDCard Sorting" ?F "Folder Sorting" ?S "Sorting Order")
  ("M35" "Upload firmware NEXTION from SD")
  ("M36" "Return file information")
  ("M37" "Simulation mode")
  ("M38" "Compute SHA1 hash of target file")
  ("M39" "Report SD card information")
  ("M40" "Eject")
  ("M41" "Loop")
  ("M42" "Set Pin State" ?I "Ignore protection on pins that Marlin is using" ?P "A digital pin number (even for analog pins) to write to" ?S "The state to set" ?T "Set the pin mode")
  ("M43" "Pins Debugging" ?E "Watch endstops" ?I "Ignore protection when reporting values" ?P "Digital Pin Number" ?S "Test BLTouch type servo probes" ?T "Toggle pins - see M43 T for options" ?W "Watch pins")
  ("M44" "Codes debug - report codes available")
  ("M44" "Reset the bed skew and offset calibration")
  ("M45" "Bed skew and offset with manual Z up")
  ("M46" "Show the assigned IP address")
  ("M47" "Show end stops dialog on the display")
  ("M48" "Probe Repeatability Test" ?C "Probe with temperature compensation enabled (PTC_PROBE, PTC_BED, PTC_HOTEND)" ?E "Engage for each probe" ?L "Number of legs to probe" ?P "Number of probes to do" ?S "Star/Schizoid probe" ?V "Verbose Level (0-4, default=1)" ?X "X Position" ?Y "Y Position")
  ("M49" "Set G26 debug flag")
  ("M70" "Display message")
  ("M72" "Play a tone or song")
  ("M73" "Set Print Progress" ?C "Set next interaction countdown" ?P "Set current print progress percentage (0-100)" ?R "Set remaining time")
  ("M75" "Start Print Job Timer")
  ("M76" "Pause Print Job Timer")
  ("M77" "Stop Print Job Timer")
  ("M78" "Print Job Stats")
  ("M80" "Power On" ?S "Report Power Supply state")
  ("M81" "Power Off")
  ("M82" "E Absolute")
  ("M83" "E Relative")
  ("M84" "Disable steppers" ?A "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?B "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?C "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?E "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?S "Set the inactivity timeout" ?U "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?V "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?W "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?X "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?Y "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W" ?Z "Disable Axes such as X, Y, Z, E, A, B, C, U, V, W")
  ("M85" "Inactivity Shutdown" ?S "Max inactive seconds")
  ("M86" "Hotend Idle Timeout" ?B "Bed idle temperature" ?E "Extruder idle temperature" ?S "Timeout period" ?T "Temperature trigger")
  ("M87" "Disable Hotend Idle Timeout")
  ("M92" "Set Axis Steps-per-unit" ?A "A steps per unit" ?B "B steps per unit" ?C "C steps per unit" ?E "E steps per unit" ?T "Target extruder" ?U "U steps per unit" ?V "V steps per unit" ?W "W steps per unit" ?X "X steps per unit" ?Y "Y steps per unit" ?Z "Z steps per unit")
  ("M93" "Send axis_steps_per_unit")
  ("M98" "Call Macro/Subprogram")
  ("M99" "Return from Macro/Subprogram")
  ("M100" "Free Memory" ?C "Corrupt 'n' locations in the free memory pool and report the locations of the corruption" ?D "Dump the free memory block from __brkval to the stack pointer" ?F "Return the number of free bytes in the memory pool along with other vital statistics that define the memory pool" ?I "Initialize the free memory pool so it can be watched and print vital statistics that define the free memory pool")
  ("M101" "Turn extruder 1 on (Forward), Undo Retraction")
  ("M102" "Configure Bed Distance Sensor" ?S "Set the Bed Distance Sensor state and trigger distance")
  ("M103" "Turn all extruders off, Extruder Retraction")
  ("M104" "Set Hotend Temperature" ?B "Maximum auto-temperature" ?F "Autotemp factor" ?I "Material preset index" ?S "Target temperature" ?T "Hotend index")
  ("M105" "Report Temperatures" ?R "Include the Redundant temperature sensor (if any)" ?T "Hotend index")
  ("M106" "Set Fan Speed" ?I "Material preset index" ?P "Fan index" ?S "Speed, from 0 to 255" ?T "Secondary speed for the given fan")
  ("M107" "Fan Off" ?P "Fan index")
  ("M108" "Break and Continue")
  ("M109" "Wait for Hotend Temperature" ?B "Maximum auto-temperature" ?F "Autotemp factor" ?I "Material preset index" ?R "Target temperature (wait for cooling or heating)" ?S "Target temperature (wait only when heating)" ?T "Hotend index")
  ("M110" "Set / Get Line Number" ?N "Line number")
  ("M111" "Debug Level" ?S "Debug flag bits")
  ("M112" "Full Shutdown")
  ("M113" "Host Keepalive" ?S "Keepalive interval (0-60)")
  ("M114" "Get Current Position" ?D "Report detailed information" ?E "Report E stepper position" ?R "Report real position information")
  ("M115" "Firmware Info")
  ("M116" "Wait")
  ("M117" "Set LCD Message")
  ("M118" "Serial print")
  ("M119" "Endstop States")
  ("M120" "Enable Endstops")
  ("M121" "Disable Endstops")
  ("M122" "TMC Debugging" ?E "Target E driver(s) only" ?I "Flag to re-initialize stepper drivers with current settings" ?P "Interval between continuous debug reports, in milliseconds" ?S "Flag to enable/disable continuous debug reporting" ?V "Report raw register data" ?X "Target X driver(s) only" ?Y "Target Y driver(s) only" ?Z "Target Z driver(s) only")
  ("M123" "Fan Tachometers")
  ("M124" "Immediate motor stop")
  ("M124" "Set Endstop Pullup")
  ("M125" "Park Head" ?L "Retract length (otherwise FILAMENT_CHANGE_RETRACT_LENGTH)" ?P "Always show a prompt and await a response (With an LCD menu)" ?X "X position to park at (otherwise FILAMENT_CHANGE_X_POS)" ?Y "Y position to park at (otherwise FILAMENT_CHANGE_Y_POS)" ?Z "Z raise before park (otherwise FILAMENT_CHANGE_Z_ADD)")
  ("M126" "Baricuda 1 Open" ?S "Valve pressure")
  ("M127" "Baricuda 1 Close")
  ("M128" "Baricuda 2 Open" ?S "Valve pressure")
  ("M129" "Baricuda 2 Close")
  ("M130" "Set PID P value")
  ("M131" "Set PID I value")
  ("M132" "Set PID D value")
  ("M133" "Set PID I limit value")
  ("M134" "Write PID values to EEPROM")
  ("M135" "Set PID sample interval")
  ("M136" "Print PID settings to host")
  ("M140" "Set Bed Temperature" ?I "Material preset index" ?S "Target temperature")
  ("M141" "Set Chamber Temperature" ?S "Target temperature")
  ("M142" "Holding Pressure")
  ("M142" "Set Cooler Temperature (Fast)")
  ("M143" "Set Laser Cooler Temperature" ?S "Target laser coolant temperature")
  ("M144" "Bed Standby")
  ("M145" "Set Material Preset" ?B "Bed temperature" ?F "Fan speed" ?H "Hotend temperature" ?S "Material index")
  ("M146" "Set Chamber Humidity")
  ("M149" "Set Temperature Units" ?C "Celsius" ?F "Fahrenheit" ?K "Kelvin")
  ("M150" "Set RGB(W) Color" ?B "Blue component from 0 to 255" ?I "NeoPixel pixel index (0" ?K "Keep all unspecified values unchanged" ?P "Brightness from 0 to 255" ?R "Red component from 0 to 255" ?S "NeoPixel strip index (0 or 1)" ?U "Green component from 0 to 255" ?W "White component from 0 to 255")
  ("M154" "Position Auto-Report" ?S "Interval in seconds between auto-reports")
  ("M155" "Temperature Auto-Report" ?S "Interval in seconds between auto-reports")
  ("M160" "Number of mixed materials")
  ("M163" "Set Mix Factor" ?P "Mix factor" ?S "Component index")
  ("M164" "Save Mix" ?S "Tool index (active virtual tool if omitted)")
  ("M165" "Set Mix" ?A "Mix factor 1" ?B "Mix factor 2" ?C "Mix factor 3" ?D "Mix factor 4" ?H "Mix factor 5" ?I "Mix factor 6")
  ("M166" "Gradient Mix" ?A "Starting Z Height" ?I "Starting Virtual Tool" ?J "Ending Virtual Tool" ?S "Enable/disable the gradient in manual mode" ?T "A tool index to reassign to the gradient" ?Z "Ending Z Height")
  ("M190" "Wait for Bed Temperature" ?I "Material preset index" ?R "Target temperature (wait for cooling or heating)" ?S "Target temperature (wait only when heating)" ?T "Cooling time in seconds to reach target temperature")
  ("M191" "Wait for Chamber Temperature" ?R "Target temperature (wait for cooling or heating)" ?S "Target temperature (wait only when heating)")
  ("M192" "Wait for Probe temperature" ?R "Temperature to wait for, whether heating or cooling" ?S "A minimum temperature to wait for")
  ("M193" "Wait For Laser Cooler Temperature" ?S "Target laser coolant temperature")
  ("M200" "Volumetric Extrusion Diameter" ?D "Filament diameter" ?L "Set volumetric extruder limit (in mm" ?S "Volumetric Extrusion On/Off" ?T "Extruder index")
  ("M201" "Print / Travel Move Limits" ?E "E axis max acceleration" ?F "Planner frequency limit" ?S "Planner XY frequency minimum speed percentage" ?T "Target extruder" ?X "X axis max acceleration" ?Y "Y axis max acceleration" ?Z "Z axis max acceleration")
  ("M202" "Set max travel acceleration")
  ("M203" "Set Max Feedrate" ?E "E axis max feedrate" ?T "Target extruder" ?X "X axis max feedrate" ?Y "Y axis max feedrate" ?Z "Z axis max feedrate")
  ("M204" "Set Starting Acceleration" ?P "Printing acceleration" ?R "Retract acceleration" ?S "Legacy parameter for move acceleration" ?T "Travel acceleration")
  ("M205" "Set Advanced Settings" ?B "Minimum segment time (µs)" ?E "E max jerk (units/s)" ?J "Junction deviation" ?S "Minimum feedrate for print moves (units/s)" ?T "Minimum feedrate for travel moves (units/s)" ?X "X max jerk (units/s)" ?Y "Y max jerk (units/s)" ?Z "Z max jerk (units/s)")
  ("M206" "Set Home Offsets" ?A "A home offset" ?B "B home offset" ?C "C home offset" ?P "SCARA Psi offset" ?T "SCARA Theta offset" ?U "U home offset" ?V "V home offset" ?W "W home offset" ?X "X home offset" ?Y "Y home offset" ?Z "Z home offset")
  ("M207" "Firmware Retraction Settings" ?F "Retract feedrate (units/min)" ?S "Retract length" ?W "Retract swap length (multi-extruder)" ?Z "Z lift on retraction")
  ("M208" "Firmware Recover Settings" ?F "Recover feedrate (units/min)" ?R "Swap recover feedrate (units/min)" ?S "Additional recover length" ?W "Additional recover swap length")
  ("M209" "Set Auto Retract" ?S "Set Auto-Retract on/off")
  ("M210" "Homing Feedrate" ?A "A homing feedrate" ?B "B homing feedrate" ?C "C homing feedrate" ?U "U homing feedrate" ?V "V homing feedrate" ?W "W homing feedrate" ?X "X homing feedrate" ?Y "Y homing feedrate" ?Z "Z homing feedrate")
  ("M211" "Software Endstops" ?S "Software endstops state")
  ("M212" "Set Bed Level Sensor Offset")
  ("M217" "Filament swap parameters" ?A "Migration Auto Mode" ?B "Extra resume" ?C "Park position for axis 7" ?E "Extra Prime Length" ?F "Fan speed (0-255)" ?G "Fan Time (seconds)" ?H "Park position for axis 8" ?I "Park position for axis 4" ?J "Park position for axis 5" ?K "Park position for axis 6" ?L "Last Migration" ?O "Park position for axis 9" ?P "Prime feedrate" ?Q "Prime active tool using TOOLCHANGE_FILAMENT_SWAP settings" ?R "Retract feedrate" ?S "Swap length" ?U "Unretract feedrate" ?V "Enable First Prime on uninitialized Nozzles" ?W "Enable Park Feature" ?X "Park X position" ?Y "Park Y position" ?Z "Z Raise")
  ("M218" "Set Hotend Offset" ?T "Hotend index" ?X "Hotend X offset" ?Y "Hotend Y offset" ?Z "Hotend Z offset")
  ("M220" "Set Feedrate Percentage" ?B "Back up current factor" ?R "Restore the last-saved factor" ?S "Feedrate percentage")
  ("M221" "Set Flow Percentage" ?S "Flow percentage" ?T "Target extruder (requires multi-extruder)")
  ("M222" "Set speed of fast XY moves")
  ("M223" "Set speed of fast Z moves")
  ("M224" "Enable extruder during fast moves")
  ("M225" "Disable on extruder during fast moves")
  ("M226" "Wait for Pin State" ?P "Pin number" ?S "State 0 or 1")
  ("M227" "Enable Automatic Reverse and Prime")
  ("M228" "Disable Automatic Reverse and Prime")
  ("M229" "Enable Automatic Reverse and Prime")
  ("M230" "Disable / Enable Wait for Temperature Change")
  ("M231" "Set OPS parameter")
  ("M232" "Read and reset max. advance values")
  ("M240" "Trigger Camera" ?A "Offset to the X return position" ?B "Offset to the Y return position" ?D "Duration to hold down the shutter switch" ?F "Feedrate for the main photo moves" ?I "Shutter switch X position" ?J "Shutter switch Y position" ?P "Delay after pressing the shutter switch" ?R "Retract/recover length" ?S "Retract/recover feedrate" ?X "Main photo move X position" ?Y "Main photo move Y position" ?Z "Main photo move Z raise")
  ("M241" "Stop conveyor belt motor / echo on")
  ("M245" "Start cooler")
  ("M246" "Stop cooler")
  ("M250" "LCD Contrast" ?C "Contrast value")
  ("M251" "Measure Z steps from homing stop (Delta printers)")
  ("M255" "LCD Sleep/Backlight Timeout" ?S "Timeout delay in minutes")
  ("M256" "LCD Brightness" ?B "Brightness value (0 - 255)")
  ("M260" "I2C Send" ?A "The bus address to send to" ?B "The byte to add to the buffer" ?R "Flag to reset and rewind the I2C buffer" ?S "Send flag")
  ("M261" "I2C Request" ?A "The bus address to request bytes from" ?B "The number of bytes to request" ?S "Output style")
  ("M265" "Scan I2C Bus")
  ("M280" "Servo Position" ?P "Servo index to set/report" ?S "Servo position to set")
  ("M281" "Edit Servo Angles" ?L "Deploy angle in degrees" ?P "Servo index to update / report" ?U "Stow angle in degrees")
  ("M282" "Detach Servo" ?P "Index of the servo to detach")
  ("M290" "Babystep" ?P "Use P0 to leave the Probe Z Offset unaffected" ?S "Alias for Z" ?X "A distance on the X axis" ?Y "A distance on the Y axis" ?Z "A distance on the Z axis")
  ("M291" "Display message and optionally wait for response")
  ("M292" "Acknowledge message")
  ("M300" "Play Tone" ?P "Duration (1ms)" ?S "Frequency (260Hz)")
  ("M301" "Set Hotend PID" ?C "C term (requires PID_EXTRUSION_SCALING)" ?D "Derivative value" ?E "Extruder index to set" ?F "F term (requires PID_FAN_SCALING)" ?I "Integral value" ?L "Extrusion scaling queue length (requires PID_EXTRUSION_SCALING)" ?P "Proportional value")
  ("M302" "Cold Extrude" ?P "Flag to allow extrusion at any temperature" ?S "Minimum temperature for safe extrusion")
  ("M303" "PID autotune" ?C "Cycles" ?D "Toggle PID debug output on / off (and take no further action)" ?E "Hotend index (-1 for heated bed)" ?S "Target temperature" ?U "Use PID result")
  ("M304" "Set Bed PID" ?D "Derivative value" ?I "Integral value" ?P "Proportional value")
  ("M305" "User Thermistor Parameters" ?B "Thermistor \"beta\" value" ?C "Steinhart-Hart Coefficient 'C'" ?P "Thermistor table index" ?R "Pullup resistor value" ?T "Resistance at 25C")
  ("M306" "Model Predictive Temp. Control" ?A "Ambient heat transfer coefficient (no fan)" ?C "Heatblock Capacity (joules/kelvin)" ?E "Extruder index" ?F "Ambient heat transfer coefficient (fan on full)" ?H "Filament Heat Capacity (joules/kelvin/mm)" ?P "Heater power in watts" ?R "Sensor responsiveness (= transfer coefficient / heat capacity)" ?S "Tuning method (with parameter 'T')" ?T "Autotune the selected extruder")
  ("M307" "Set or report heating process parameters")
  ("M308" "Set or report sensor parameters")
  ("M309" "Set Chamber PID" ?D "Derivative value" ?I "Integral value" ?P "Proportional value")
  ("M320" "Activate autolevel (Repetier)")
  ("M321" "Deactivate autolevel (Repetier)")
  ("M322" "Reset autolevel matrix (Repetier)")
  ("M323" "Distortion correction on/off (Repetier)")
  ("M340" "Control the servos")
  ("M350" "Set micro-stepping" ?A "Set micro-stepping for the A stepper driver" ?B "Set micro-stepping for the 5th stepper driver" ?C "Set micro-stepping for the C stepper driver" ?E "Set micro-stepping for the E0 stepper driver" ?S "Set micro-stepping for all 5 stepper drivers" ?U "Set micro-stepping for the U stepper driver" ?V "Set micro-stepping for the V stepper driver" ?W "Set micro-stepping for the W stepper driver" ?X "Set micro-stepping for the X stepper driver" ?Y "Set micro-stepping for the Y stepper driver" ?Z "Set micro-stepping for the Z stepper driver")
  ("M351" "Set Microstep Pins" ?B "Set the MS1/2 pin for the 5th stepper driver" ?E "Set the MS1/2 pin for the E stepper driver" ?S "Select the pin to set for all specified axes" ?X "Set the MS1/2 pin for the X stepper driver" ?Y "Set the MS1/2 pin for the Y stepper driver" ?Z "Set the MS1/2 pin for the Z stepper driver")
  ("M355" "Case Light Control" ?P "Set the brightness factor from 0 to 255" ?S "Turn the case light on or off")
  ("M360" "SCARA Theta A")
  ("M361" "SCARA Theta-B")
  ("M362" "SCARA Psi-A")
  ("M363" "SCARA Psi-B")
  ("M364" "SCARA Psi-C")
  ("M365" "SCARA scaling factor")
  ("M366" "SCARA convert trim")
  ("M370" "Morgan manual bed level - clear map")
  ("M371" "Move to next calibration position")
  ("M372" "Record calibration value, and move to next position")
  ("M373" "End bed level calibration mode")
  ("M374" "Save calibration grid")
  ("M375" "Display matrix / Load Matrix")
  ("M376" "Set bed compensation taper")
  ("M380" "Activate Solenoid" ?S "Solenoid index")
  ("M381" "Deactivate Solenoids" ?S "Solenoid index")
  ("M400" "Finish Moves")
  ("M401" "Deploy Probe" ?H "Report the current BLTouch High Speed (HS) Mode state and exit" ?R "Remain in place after deploying (and before activating) the probe" ?S "Set the BLTouch High Speed (HS) Mode state and exit without deploy")
  ("M402" "Stow Probe" ?R "Remain in place after stowing (and before deactivating) the probe")
  ("M403" "MMU2 Filament Type" ?E "The MMU2 slot [0..4] to set the material type for" ?F "The filament type")
  ("M404" "Filament Width Sensor Nominal Diameter" ?W "The new nominal width value")
  ("M405" "Filament Width Sensor On" ?D "Distance from measurement point to hot end")
  ("M406" "Filament Width Sensor Off")
  ("M407" "Read Filament Width")
  ("M408" "Report JSON-style response")
  ("M409" "Query object model")
  ("M410" "Quickstop")
  ("M412" "Filament Runout" ?D "For a filament sensor located in front of the extruder gears, set the distance from the runout sensor to the extruder gears" ?H "Flag to enable or disable host handling of a filament runout" ?L "Set the motion sensor runout length" ?R "Flag to reset the filament runout sensor" ?S "Flag to enable or disable Filament Runout Detection")
  ("M413" "Power-loss Recovery" ?S "Flag to enable or disable Power-loss Recovery")
  ("M414" "LCD language" ?S "Configured languages index")
  ("M415" "Host Rescue")
  ("M416" "Power loss")
  ("M420" "Bed Leveling State" ?C "Center the mesh on the mean of the lowest and highest points" ?L "Load mesh from EEPROM index" ?S "Set enabled or disabled" ?T "Format to print the mesh data" ?V "Verbose: Print the stored mesh / matrix data" ?Z "Set Z fade height")
  ("M421" "Set Mesh Value" ?C "Set the mesh point closest to the current nozzle position (AUTO_BED_LEVELING_UBL only)" ?I "X index into the mesh array" ?J "Y index into the mesh array" ?N "Set the mesh point to undefined (AUTO_BED_LEVELING_UBL only)" ?Q "A value to add to the existing Z value" ?X "X position (which should be very close to a grid line) (MESH_BED_LEVELING only)" ?Y "Y position (which should be very close to a grid line) (MESH_BED_LEVELING only)" ?Z "The new Z value to set")
  ("M422" "Set Z Motor XY" ?R "Reset alignment and known points to the defaults" ?S "One-based index of a Z-Stepper whose probing-point will be set" ?W "One-based index of a Z-Stepper whose known position will be set" ?X "X position" ?Y "Y position")
  ("M423" "X Twist Compensation" ?A "Set the X-Axis Twist Compensation starting X position" ?E "Set the X-Axis Twist Compensation ending X position" ?I "Set the X-Axis Twist Compensation X-spacing" ?R "Reset the Twist Compensation array to the configured default values" ?X "Zero-based index into the Twist Compensation array" ?Z "A Z-offset value to set in the Twist Compensation array")
  ("M425" "Backlash compensation" ?F "Enable or disables backlash correction, or sets an intermediate fade-out (0.0 = none; 1.0 = 100%)" ?S "Distance over which backlash correction is spread" ?X "Set the backlash distance on X (mm; 0 to disable)" ?Y "Set the backlash distance on Y (mm; 0 to disable)" ?Z "When MEASURE_BACKLASH_WHEN_PROBING is enabled, loads the measured backlash into the backlash distance parameter")
  ("M428" "Home Offsets Here")
  ("M430" "Power Monitor" ?I "display current (A) on LCD" ?V "toggle display voltage (V) on LCD" ?W "display power/watts (W) on LCD")
  ("M450" "Report Printer Mode")
  ("M451" "Select FFF Printer Mode")
  ("M452" "Select Laser Printer Mode")
  ("M453" "Select CNC Printer Mode")
  ("M460" "Define temperature range for thermistor-controlled fan")
  ("M470" "Create Directory on SD-Card")
  ("M471" "Rename File/Directory on SD-Card")
  ("M486" "Cancel Objects" ?C "Cancel the current object" ?P "Cancel the object with the given index" ?S "Set the index of the current object" ?T "Reset the state and set the number of objects" ?U "Un-cancel the object with the given index")
  ("M493" "Fixed-Time Motion" ?A "Set the Base Frequency for Input Shaping on the specified axes" ?C "Set the vibration compensator [input shaper] mode for the specified axes" ?D "Set the Dynamic Frequency mode" ?E "Flag to apply A,C,F,I,Q to the E axis" ?F "Set the Frequency Scaling factor for Input Shaping on the specified axes" ?I "Set the Zeta for Input Shaping on the specified axes" ?Q "Set the Vibration Tolerance for Input Shaping on the specified axes" ?S "Set Fixed-Time Motion mode enabled / disabled" ?T "Set the state for Axis Synchronization" ?X "Flag to apply A,C,F,I,Q to the X axis" ?Y "Flag to apply A,C,F,I,Q to the Y axis" ?Z "Flag to apply A,C,F,I,Q to the Z axis")
  ("M494" "FT Motion Trajectory Smoothing" ?E "Set smoothing time for the E axis" ?O "Set acceleration overshoot for POLY6 (only used when T=2)" ?T "Set trajectory generator type" ?X "Set smoothing time for the X axis" ?Y "Set smoothing time for the Y axis" ?Z "Set smoothing time for the Z axis")
  ("M500" "Save Settings")
  ("M501" "Restore Settings")
  ("M502" "Factory Reset")
  ("M503" "Report Settings" ?C "Save the embedded configuration ZIP file to the SD Card or Flash Drive" ?S "Detailed output flag")
  ("M504" "Validate EEPROM contents")
  ("M505" "Clear EEPROM and RESET Printer")
  ("M505" "Set configuration file folder")
  ("M509" "Force language selection")
  ("M510" "Lock Machine")
  ("M511" "Unlock Machine" ?P "The passcode to try")
  ("M512" "Set Passcode" ?P "Current passcode" ?S "If S is included the new passcode will be set to this value")
  ("M524" "Abort SD print")
  ("M530" "Enable printing mode")
  ("M531" "Set print name")
  ("M532" "Set print progress")
  ("M540" "Endstops Abort SD" ?S "Whether (1) or not (0) to abort SD printing on endstop hit")
  ("M550" "Machine Name" ?P "Set the Machine Name using a string parameter")
  ("M551" "Set Password")
  ("M552" "Ethernet IP Address, Network IF" ?P "Set IP Address" ?S "Reset, Disable, or Enable the Network Interface")
  ("M553" "Ethernet Subnet Mask" ?P "The IP Subnet Mask")
  ("M554" "Ethernet Gateway IP Address" ?P "The IP Gateway IP Address")
  ("M555" "Set compatibility")
  ("M556" "Axis compensation")
  ("M557" "Set Z probe point or define probing grid")
  ("M558" "Set Z probe type")
  ("M559" "Upload configuration file")
  ("M560" "Upload web page file")
  ("M561" "Set Identity Transform")
  ("M562" "Reset temperature fault")
  ("M563" "Define or remove a tool")
  ("M564" "Limit axes")
  ("M565" "Set Z probe offset")
  ("M566" "Set allowable instantaneous speed change")
  ("M567" "Set tool mix ratios")
  ("M568" "Turn off/on tool mix ratios (obsolete)")
  ("M569" "Set TMC Stepping Mode" ?E "Stepping mode for the E0 stepper" ?I "Index for multiple steppers" ?T "Index (tool) number for the E axis" ?X "Stepping mode for the X stepper" ?Y "Stepping mode for the Y stepper" ?Z "Stepping mode for the Z stepper")
  ("M569.1" "Stepper driver closed loop control")
  ("M570" "Configure heater fault detection")
  ("M571" "Set output on extrude")
  ("M572" "Set or report extruder pressure advance")
  ("M573" "Report heater PWM")
  ("M574" "Set endstop configuration")
  ("M575" "Serial baud rate" ?B "The baud rate to set" ?P "Serial Port index")
  ("M577" "Wait until endstop is triggered")
  ("M578" "Fire inkjet bits")
  ("M579" "Scale Cartesian axes")
  ("M580" "Select Roland")
  ("M581" "Configure external trigger")
  ("M582" "Check external trigger")
  ("M584" "Set drive mapping")
  ("M585" "Probe Tool")
  ("M586" "Configure network protocols")
  ("M587" "Store WiFi host network in list, or list stored networks")
  ("M588" "Forget WiFi host network")
  ("M589" "Configure access point parameters")
  ("M590" "Report current tool type and index")
  ("M591" "Configure filament monitoring")
  ("M592" "Nonlinear Extrusion Control" ?A "Set the Quadratic coefficient (Default 0.0)" ?B "Set the Linear coefficient (Default 0.0)" ?C "Set the Constant coefficient (Default 1.0)" ?S "Enable or disable Nonlinear Extrusion")
  ("M593" "ZV Input Shaping" ?D "Set the zeta/damping factor for the specified axes" ?F "Set the damping frequency for the specified axes" ?X "Flag to set the X axis value" ?Y "Flag to set the Y axis value" ?Z "Flag to set the Z axis value")
  ("M594" "Enter/Leave Height Following mode")
  ("M600" "Filament Change" ?B "Number of beeps to alert user of filament change (default FILAMENT_CHANGE_ALERT_BEEPS)" ?E "Retract before moving to change position (negative, default PAUSE_PARK_RETRACT_LENGTH)" ?L "Load length, longer for bowden (positive)" ?R "Resume temperature" ?T "Target extruder" ?U "Amount of retraction for unload (negative)" ?X "X position for filament change" ?Y "Y position for filament change" ?Z "Z relative lift for filament change position")
  ("M601" "Pause print")
  ("M602" "Resume print")
  ("M603" "Configure Filament Change" ?L "Load length, longer for bowden (positive)" ?T "Target extruder" ?U "Amount of retraction for unload (negative)")
  ("M605" "Multi Nozzle Mode" ?E "Last nozzle index to include in the duplication set" ?P "Bit-mask of nozzles to include in the duplication set" ?R "Temperature difference to apply to E1" ?S "Select the pin to set for all specified axes" ?X "X distance between dual X carriages")
  ("M650" "Set peel move parameters")
  ("M651" "execute peel move")
  ("M665" "Delta Configuration" ?A "Alpha (Tower 1) diagonal rod trim" ?B "Beta (Tower 2) diagonal rod trim" ?C "Gamma (Tower 3) diagonal rod trim" ?H "Delta height" ?L "Diagonal rod" ?R "Delta radius" ?S "Segments per second" ?X "Alpha (Tower 1) angle trim" ?Y "Beta (Tower 2) angle trim" ?Z "Gamma (Tower 3) angle trim")
  ("M665" "SCARA Configuration" ?A "Theta-Psi offset, alias for P" ?B "Theta offset, alias for T" ?P "Theta-Psi offset, added to the shoulder (A/X) angle" ?S "Segments per second" ?T "Theta offset, added to the elbow (B/Y) angle" ?X "Theta-Psi offset, alias for P" ?Y "Theta offset, alias for T")
  ("M666" "Dual endstop offsets" ?X "Offset for the X axis endstops" ?Y "Offset for the Y axis endstops" ?Z "Offset for the Z axis endstops")
  ("M666" "Set Delta endstop adjustments" ?X "Adjustment for the X actuator endstop" ?Y "Adjustment for the Y actuator endstop" ?Z "Adjustment for the Z actuator endstop")
  ("M667" "Select CoreXY mode")
  ("M668" "Set Z-offset compensations polynomial")
  ("M669" "Set kinematics type and kinematics parameters")
  ("M670" "Set IO port bit mapping")
  ("M671" "Define positions of Z leadscrews or bed leveling screws")
  ("M672" "Duet Smart Effector sensitivity" ?R "Revert sensitivity to factory settings" ?S "Set sensitivity (0-255)")
  ("M673" "Align plane on rotary axis")
  ("M674" "Set Z to center point")
  ("M675" "Find center of cavity")
  ("M700" "Level plate")
  ("M701" "Load filament" ?L "Extrude distance for insertion (positive value) (manual reload)" ?T "Optional extruder index" ?Z "Move the Z axis by this distance")
  ("M702" "Unload filament" ?T "Optional extruder number" ?U "Retract distance for removal (manual reload)" ?Z "Move the Z axis by this distance")
  ("M703" "Configure Filament")
  ("M710" "Controller Fan settings" ?A "Set whether the fan speed is set automatically" ?D "Set the extra duration to keep the fan speed high after motors are turned off" ?I "Set the speed of the controller fan when motors are off" ?R "Reset all settings to defaults" ?S "Set the speed of the controller fan when motors are active")
  ("M750" "Enable 3D scanner extension")
  ("M751" "Register 3D scanner extension over USB")
  ("M752" "Start 3D scan")
  ("M753" "Cancel current 3D scanner action")
  ("M754" "Calibrate 3D scanner")
  ("M755" "Set alignment mode for 3D scanner")
  ("M756" "Shutdown 3D scanner")
  ("M800" "Fire start print procedure")
  ("M801" "Fire end print procedure")
  ("M808" "Repeat Marker" ?L "Loop counter")
  ("M810" "G-code macros")
  ("M811" "G-code macros")
  ("M812" "G-code macros")
  ("M813" "G-code macros")
  ("M814" "G-code macros")
  ("M815" "G-code macros")
  ("M816" "G-code macros")
  ("M817" "G-code macros")
  ("M818" "G-code macros")
  ("M819" "G-code macros")
  ("M820" "Report G-code macros")
  ("M851" "XYZ Probe Offset" ?X "Z probe X offset" ?Y "Z probe Y offset" ?Z "Z probe Z offset")
  ("M852" "Bed Skew Compensation" ?I "Skew correction factor for XY axis" ?J "Skew correction factor for XZ axis" ?K "Skew correction factor for YZ axis" ?S "Alias for I when only XY skew correction is enabled")
  ("M860" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M861" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M862" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M862.1" "Check nozzle diameter")
  ("M862.2" "Check model code")
  ("M862.3" "Model name")
  ("M862.4" "Firmware version")
  ("M862.5" "Gcode level")
  ("M863" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M864" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M865" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M866" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M867" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M868" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M869" "I2C Position Encoders" ?E "Report on E axis encoder if present" ?I "Module index" ?O "Include homed zero-offset in returned position" ?P "Number of rePeats/iterations" ?R "Reset error counter" ?S "Enable/disable error correction" ?T "New error correction threshold" ?U "Units in mm or raw step count" ?X "Report on X axis encoder if present" ?Y "Report on Y axis encoder if present" ?Z "Report on Z axis encoder if present")
  ("M870" "Control Chamber vents")
  ("M871" "Probe temperature config" ?B "Store the value V as the Z adjustment at index I for the Bed" ?E "Store the value V as the Z adjustment at index I for the Extruder" ?I "Index at which to store the given Z adjustment value" ?P "Store the value V as the Z adjustment at index I for the Probe" ?R "Reset all Z adjustment values to factory defaults (zero)" ?V "Z adjustment value, in µm (micrometers)")
  ("M876" "Handle Prompt Response" ?S "Response to prompt")
  ("M890" "Run User Gcode")
  ("M900" "Linear Advance Factor" ?K "The K factor to set for the specified extruder" ?L "Set the second K factor for the specified extruder" ?S "Select slot and activate the last stored value" ?T "Extruder to which K, L, and S will apply")
  ("M905" "Set local date and time")
  ("M906" "Stepper Motor Current" ?E "Current for the E0 stepper" ?I "Index for multiple steppers" ?T "Index (tool) number for the E axis" ?X "Current for the X stepper" ?Y "Current for the Y stepper" ?Z "Current for the Z stepper")
  ("M907" "Trimpot Stepper Motor Current" ?B "Current for the E1 stepper" ?C "Current for the E2 stepper" ?D "Current for the E3 stepper" ?E "Current for the E0 stepper" ?I "Current for the I stepper" ?J "Current for the J stepper" ?K "Current for the K stepper" ?S "Set this current on all steppers" ?U "Current for the U stepper" ?V "Current for the V stepper" ?W "Current for the W stepper" ?X "Current for the X stepper (and the Y stepper with MOTOR_CURRENT_PWM_XY)" ?Y "Current for the Y stepper" ?Z "Current for the Z stepper")
  ("M908" "Set Trimpot Pins" ?P "Pin (i.e., Address, Channel)" ?S "Current value")
  ("M909" "Report DAC Stepper Current")
  ("M910" "Commit DAC to EEPROM")
  ("M911" "TMC OT Pre-Warn Condition")
  ("M912" "Clear TMC OT Pre-Warn" ?E "Clear all or one E stepper driver Over Temperature Pre-warn flag" ?I "Stepper number to set" ?X "Clear X and/or X2 stepper driver Over Temperature Pre-warn flag" ?Y "Clear Y and/or Y2 stepper driver Over Temperature Pre-warn flag" ?Z "Clear Z and/or Z2 and/or Z3 stepper driver Over Temperature Pre-warn flag")
  ("M913" "Set Hybrid Threshold Speed" ?A "Set Hybrid Threshold for A to the given value" ?B "Set Hybrid Threshold for B to the given value" ?C "Set Hybrid Threshold for C to the given value" ?E "Set Hybrid Threshold for E to the given value" ?I "Index for multiple steppers" ?T "Index (tool) number for the E axis" ?U "Set Hybrid Threshold for U to the given value" ?V "Set Hybrid Threshold for V to the given value" ?W "Set Hybrid Threshold for W to the given value" ?X "Set Hybrid Threshold for X to the given value" ?Y "Set Hybrid Threshold for Y to the given value" ?Z "Set Hybrid Threshold for Z to the given value")
  ("M914" "TMC Bump Sensitivity" ?A "Sensitivity of the A stepper driver" ?B "Sensitivity of the B stepper driver" ?C "Sensitivity of the C stepper driver" ?I "Index for multiple steppers" ?U "Sensitivity of the U stepper driver" ?V "Sensitivity of the V stepper driver" ?W "Sensitivity of the W stepper driver" ?X "Sensitivity of the X stepper driver" ?Y "Sensitivity of the Y stepper driver" ?Z "Sensitivity of the Z stepper driver")
  ("M915" "TMC Z axis calibration" ?S "Current value to use for the raise move" ?Z "Extra distance past Z_MAX_POS to move the Z axis")
  ("M916" "L6474 Thermal Warning Test" ?D "Time (in seconds) to run each setting of KVAL_HOLD/TVAL" ?E "Monitor E with the given displacement (1 - 255mm) on either side of the current position" ?F "Feedrate for the moves" ?J "Select which driver(s) to monitor on multi-driver axis" ?K "Value for KVAL_HOLD (0 - 255) (ignored for L6474)" ?T "Current (mA) setting for TVAL (0 - 4A in 31.25mA increments, rounds down) - L6474 only" ?X "Monitor X with the given displacement (1 - 255mm) on either side of the current position" ?Y "Monitor Y with the given displacement (1 - 255mm) on either side of the current position" ?Z "Monitor Z with the given displacement (1 - 255mm) on either side of the current position")
  ("M917" "L6474 Overcurrent Warning Test" ?A "Monitor A with the given displacement (1 - 255mm) on either side of the current position" ?B "Monitor B with the given displacement (1 - 255mm) on either side of the current position" ?C "Monitor C with the given displacement (1 - 255mm) on either side of the current position" ?E "Monitor E with the given displacement (1 - 255mm) on either side of the current position" ?F "Feedrate for the moves" ?I "Starting overcurrent threshold" ?J "Select which driver(s) to monitor on multi-driver axis" ?K "Value for KVAL_HOLD (0 - 255) (ignored for L6474)" ?T "Current (mA) setting for TVAL (0 - 4A in 31.25mA increments, rounds down) - L6474 only" ?U "Monitor U with the given displacement (1 - 255mm) on either side of the current position" ?V "Monitor V with the given displacement (1 - 255mm) on either side of the current position" ?W "Monitor W with the given displacement (1 - 255mm) on either side of the current position" ?X "Monitor X with the given displacement (1 - 255mm) on either side of the current position" ?Y "Monitor Y with the given displacement (1 - 255mm) on either side of the current position" ?Z "Monitor Z with the given displacement (1 - 255mm) on either side of the current position")
  ("M918" "L6474 Speed Warning Test" ?E "Monitor E with the given displacement (1 - 255mm) on either side of the current position" ?I "Overcurrent threshold" ?J "Select which driver(s) to monitor on a multi-driver axis" ?K "Value for KVAL_HOLD (0 - 255) (ignored for L6474)" ?M "Value for microsteps (1 - 128)" ?T "Current (mA) setting for TVAL (0 - 4A in 31.25mA increments, rounds down) - L6474 only" ?X "Monitor X with the given displacement (1 - 255mm) on either side of the current position" ?Y "Monitor Y with the given displacement (1 - 255mm) on either side of the current position" ?Z "Monitor Z with the given displacement (1 - 255mm) on either side of the current position")
  ("M919" "TMC Chopper Timing" ?A "Apply the given chopper timing to the A stepper" ?B "Apply the given chopper timing to the B stepper" ?C "Apply the given chopper timing to the C stepper" ?I "Index for multiple steppers" ?O "Time-Off value (1..15)" ?P "Hysteresis End value (-3..12)" ?S "Hysteresis Start value (1..8)" ?T "Index (tool) number for the E axis" ?U "Apply the given chopper timing to the U stepper" ?V "Apply the given chopper timing to the V stepper" ?W "Apply the given chopper timing to the W stepper" ?X "Apply the given chopper timing to the X stepper(s), if any" ?Y "Apply the given chopper timing to the Y stepper(s), if any" ?Z "Apply the given chopper timing to the Z stepper(s), if any")
  ("M920" "TMC Homing Current" ?A "Set the Homing Current (in milliamps) for the A axis stepper driver(s)" ?B "Set the Homing Current (in milliamps) for the B axis stepper driver(s)" ?C "Set the Homing Current (in milliamps) for the C axis stepper driver(s)" ?I "Index for multiple steppers" ?U "Set the Homing Current (in milliamps) for the U axis stepper driver(s)" ?V "Set the Homing Current (in milliamps) for the V axis stepper driver(s)" ?W "Set the Homing Current (in milliamps) for the W axis stepper driver(s)" ?X "Set the Homing Current (in milliamps) for the X axis stepper driver(s)" ?Y "Set the Homing Current (in milliamps) for the Y axis stepper driver(s)" ?Z "Set the Homing Current (in milliamps) for the Z axis stepper driver(s)")
  ("M928" "Start SD Logging")
  ("M929" "Start/stop event logging to SD card")
  ("M950" "Create heater, fan or GPIO/servo device")
  ("M951" "Magnetic Parking Extruder" ?C "Set compensation factor" ?D "Set travel feedrate" ?H "Set fast feedrate" ?I "Set grab distance" ?J "Set slow feedrate" ?L "Set X[0] position" ?R "Set X[1] position")
  ("M952" "Set CAN expansion board address and/or normal data rate")
  ("M953" "Set CAN-FD bus fast data rate")
  ("M993" "Back up flash settings to SD")
  ("M994" "Restore flash from SD")
  ("M995" "Touch Screen Calibration")
  ("M997" "Firmware update")
  ("M998" "Request resend of line")
  ("M999" "STOP Restart" ?S "Resume without flushing the command buffer")
  ("M7219" "MAX7219 Control" ?C "Set the column specified by C to bit pattern V" ?D "Directly set a Max7219 native row (on the unit specified by U) to the 8-bit pattern V" ?F "Fill the matrix by turning on all LEDs" ?I "Initialize (clear) all matrixes" ?P "Print the LED array state for debugging" ?R "Set the row specified by R to bit pattern V" ?U "Used with D to specify which matrix unit to set" ?V "Value to apply when using the C, R, or X/Y parameters" ?X "Set a matrix LED at the given X position to the V value" ?Y "Set a matrix LED at the given Y position to the V value")
  ("P0" "Park tool")
  ("T0" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T1" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T2" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T3" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T4" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T5" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T6" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("T7" "Select or Report Tool" ?F "Movement feedrate for the tool-change" ?S "Specify movement in XY after the tool-change")
  ("Tc" "MMU2 Special Commands")
))

(provide 'gcode-mode-doc)
