;;; kixtart-docstrings.el --- Docstrings for KiXtart -*- lexical-binding: t; -*-

;;; Commentary:

;; Loading this file will register the default documentation entries with
;; `kixtart-mode'.

;;; Code:

(require 'kixtart-mode)

(kixtart-doc-register kixtart-make-doc-command
  (\? :syntax "?" :final t)
  (BEEP :syntax "BEEP" :final t)
  (BIG :syntax "BIG" :final t)
  (BREAK :syntax "BREAK <ON | OFF>")
  (CALL :syntax "CALL \"script name\"")
  (CD :syntax "CD \"directory\"")
  (CLS :syntax "CLS" :final t)
  (COLOR :syntax "COLOR X[+]/Y[+]")
  (COOKIE1 :syntax "COOKIE1" :final t)
  (COPY :syntax "COPY \"source\" \"destination\" [/c] [/h] [/r] [/s]")
  (DEBUG :syntax "DEBUG \"ON\" | \"OFF\"")
  (DEL :syntax "DEL \"filename\" [/c] [/f] [/h] [/p] [/s]")
  (DIM :syntax "DIM $variable1[, $variable2]")
  (DISPLAY :syntax "DISPLAY \"filename\"")
  ((DO UNTIL) :syntax "DO ... UNTIL expression")
  (EXIT :syntax "EXIT [exit code]")
  (FLUSHKB :syntax "FLUSHKB" :final t)
  ((FOR EACH IN NEXT) :syntax "FOR EACH $element IN group ... NEXT" :final 'last)
  ((FOR TO STEP NEXT) :syntax "FOR $counter = start TO end [STEP step] ... NEXT" :final 'last)
  ((FUNCTION ENDFUNCTION) :syntax "FUNCTION name [(argument1, [OPTIONAL] argument2)] ... ENDFUNCTION" :final 'last)
  (GET :syntax "GET $x")
  (GETS :syntax "GETS $x")
  (GLOBAL :syntax "GLOBAL $variable1[, $variable2]...")
  (GO :syntax "[GO] drive")
  (GOSUB :syntax "GOSUB label")
  (GOTO :syntax "GOTO label")
  ((IF ELSE ENDIF) :syntax "IF expression ... ELSE ... ENDIF" :final 'last)
  (INCLUDE :syntax "INCLUDE \"script name\"")
  (MD :syntax "MD \"directory\"")
  (MOVE :syntax "MOVE \"source\" \"destination\" [/c] [/h] [/p] [/r] [/s]")
  (PASSWORD :syntax "PASSWORD \"password\"")
  (PLAY :syntax "PLAY <FILE \"filename.spk\"] | [FILE] \"filename.wav\" | \"string\">")
  (QUIT :syntax "QUIT [exit code]")
  (RD :syntax "RD \"directory\" [/s]")
  ((REDIM PRESERVE) :syntax "REDIM [PRESERVE] $variable1[, [PRESERVE] $variable2]")
  (RETURN :syntax "RETURN" :final t)
  (RUN :syntax "RUN \"command\"")
  ((SELECT CASE ENDSELECT) :syntax "SELECT CASE expression ... ENDSELECT" :final 'last)
  (SET :syntax "SET \"variable=string\"")
  (SETL :syntax "SETL \"variable=string\"")
  (SETM :syntax "SETM \"variable=string\"")
  (SETTIME :syntax "SETTIME \"source\"")
  (SHELL :syntax "SHELL \"command\"")
  (SLEEP :syntax "SLEEP seconds")
  (SMALL :syntax "SMALL" :final t)
  (USE :syntax "USE <* | \"device\" | \"resource\"> /DELETE [/PERSISTENT]
USE [\"device\"] \"resource\" [/USER:\"user\"] [/PASSWORD:\"password\"] [/PERSISTENT]")
  ((WHILE LOOP) :syntax "WHILE expression ... LOOP" :final 'last))

(kixtart-doc-register kixtart-make-doc-function
  (ABS :syntax "ABS (expression)")
  (ADDKEY :syntax "ADDKEY (\"subkey\")")
  (ADDPRINTERCONNECTION :syntax "ADDPRINTERCONNECTION (\"printer share\")")
  (ADDPROGRAMITEM :syntax "ADDPROGRAMITEM (\"command line\", \"name\", \"icon path\", icon index, \"default directory\", minimize, replace, run in own space)")
  (ADDPROGRAMGROUP :syntax "ADDPROGRAMGROUP (\"group name\", groupflag)")
  (ASC :syntax "ASC (character)")
  (ASCAN :syntax "ASCAN (array, expression[, start[, length[, flags]]])")
  (AT :syntax "AT (row, column)")
  (BACKUPEVENTLOG :syntax "BACKUPEVENTLOG (\"eventlog\", \"backupfile\")")
  (BOX :syntax "BOX (top left row, top left column, bottom right row, bottom right column, \"line style\")")
  (CDBL :syntax "CDBL (expression)")
  (CHR :syntax "CHR (character code)")
  (CINT :syntax "CINT (expression)")
  (CLEAREVENTLOG :syntax "CLEAREVENTLOG (\"eventlog\")")
  (CLOSE :syntax "CLOSE (file handle)")
  (COMPAREFILETIMES :syntax "COMPAREFILETIMES (\"file1\", \"file2\")")
  (CREATEOBJECT :syntax "CREATEOBJECT (\"serverclassname.typename\")")
  (CSTR :syntax "CSTR (expression)")
  (DECTOHEX :syntax "DECTOHEX (decimal value)")
  (DELKEY :syntax "DELKEY (\"subkey\")")
  (DELPRINTERCONNECTION :syntax "DELPRINTERCONNECTION (\"printer name\")")
  (DELPROGRAMGROUP :syntax "DELPROGRAMGROUP (\"group name\", common group flag)")
  (DELPROGRAMITEM :syntax "DELPROGRAMITEM (\"item name\")")
  (DELTREE :syntax "DELTREE (\"subkey\")")
  (DELVALUE :syntax "DELVALUE (\"subkey\", \"entry\")")
  (DIR :syntax "DIR (\"path\", index)")
  (ENUMGROUP :syntax "ENUMGROUP (index)")
  (ENUMIPINFO :syntax "ENUMIPINFO (index, type, mode)")
  (ENUMKEY :syntax "ENUMKEY (\"subkey\", index)")
  (ENUMLOCALGROUP :syntax "ENUMLOCALGROUP (index, \"source\")")
  (ENUMVALUE :syntax "ENUMVALUE (\"subkey\", index)")
  (EXECUTE :syntax "EXECUTE (\"script\")")
  (EXIST :syntax "EXIST (\"filename\")")
  (EXISTKEY :syntax "EXPANDENVIRONMENTVARS (\"string\")")
  (FIX :syntax "FIX (expression)")
  (FORMATNUMBER :syntax "FORMATNUMBER (expression, decimal places, leading digit, parentheses, group)")
  (FREEFILEHANDLE :syntax "FREEFILEHANDLE ()" :final t)
  (GETCOMMANDLINE :syntax "GETCOMMANDLINE (mode)")
  (GETDISKSPACE :syntax "GETDISKSPACE (\"drive\")")
  (GETFILEATTR :syntax "GETFILEATTR (\"filename\")")
  (GETFILESIZE :syntax "GETFILESIZE (\"filename\")")
  (GETFILETIME :syntax "GETFILETIME (\"filename\", mode)")
  (GETFILEVERSION :syntax "GETFILEVERSION (\"filename\",\"version field\")")
  (GETOBJECT :syntax "GETOBJECT (\"object name\" )")
  (IIF :syntax "IIF (expression, value1, value2)")
  (INGROUP :syntax "INGROUP (\"group name\" [, \"group name 2\"], mode)")
  (INSTR :syntax "INSTR (\"string1\", \"string2\")")
  (INSTRREV :syntax "INSTRREV (\"string1\", \"string2\")")
  (INT :syntax "INT (expression)")
  (ISDECLARED :syntax "ISDECLARED (variable)")
  (JOIN :syntax "JOIN (array, \"delimiter\", count)")
  (KBHIT :syntax "KBHIT ()" :final t)
  (KEYEXIST :syntax "KEYEXIST (\"subkey\")")
  (LCASE :syntax "LCASE (\"string\")")
  (LEFT :syntax "LEFT (\"string\", length)")
  (LEN :syntax "LEN (\"string\")")
  (LOADHIVE :syntax "LOADHIVE (\"key\", \"filename\")")
  (LOADKEY :syntax "LOADKEY (\"subkey\", \"filename\")")
  (LOGEVENT :syntax "LOGEVENT (type, ID, message, target, source)")
  (LOGOFF :syntax "LOGOFF (force)")
  (LTRIM :syntax "LTRIM (\"string\")")
  (MEMORYSIZE :syntax "MEMORYSIZE (type)")
  (MESSAGEBOX :syntax "MESSAGEBOX (\"message\", \"title\", style, time-out)")
  (OPEN :syntax "OPEN (file handle, \"filename\", mode)")
  (READLINE :syntax "READLINE (file handle)")
  (READPROFILESTRING :syntax "READPROFILESTRING (\"filename\", \"section\", \"key\")")
  (READTYPE :syntax "READTYPE (\"subkey\", \"entry\")")
  (READVALUE :syntax "READVALUE (\"subkey\", \"entry\")")
  (REDIRECTOUTPUT :syntax "REDIRECTOUTPUT (\"filename\", overwrite)")
  (REPLACE :syntax "REPLACE (\"string\", \"find\", \"replace with\"[, offset[, count]])")
  (RIGHT :syntax "RIGHT (\"string\", length)")
  (RND :syntax "RND (range)")
  (ROUND :syntax "ROUND (expression, decimal places)")
  (RTRIM :syntax "RTRIM (\"string\")")
  (SAVEKEY :syntax "SAVEKEY (\"subkey\", \"filename\")")
  (SENDKEYS :syntax "SENDKEYS (\"keys\")")
  (SENDMESSAGE :syntax "SENDMESSAGE (\"recipient\", \"message\")")
  (SETASCII :syntax "SETASCII (\"mode\")")
  (SETCONSOLE :syntax "SETCONSOLE (\"mode\")")
  (SETDEFAULTPRINTER :syntax "SETDEFAULTPRINTER (\"printer name\")")
  (SETFILEATTR :syntax "SETFILEATTR (\"filename\", attributes)")
  (SETFOCUS :syntax "SETFOCUS (\"title\")")
  (SETOPTION :syntax "SETOPTION (\"option\"[, \"value\"])")
  (SETSYSTEMSTATE :syntax "SETSYSTEMSTATE (mode, force)")
  (SETTITLE :syntax "SETTITLE (\"title\")")
  (SETWALLPAPER :syntax "SETWALLPAPER (\"wallpaper name\", mode)")
  (SHOWPROGRAMGROUP :syntax "SHOWPROGRAMGROUP (\"group name\", show command, common group flag)")
  (SHUTDOWN :syntax "SHUTDOWN (\"computer\", \"message\", wait, force, options)")
  (SIDTONAME :syntax "SIDTONAME (\"sid\")")
  (SPLIT :syntax "SPLIT (\"string\", \"delimiter\", count)")
  (SRND :syntax "SRND (seed)")
  (SUBSTR :syntax "SUBSTR (\"string\", start, length)")
  (TRIM :syntax "TRIM (\"string\")")
  (UBOUND :syntax "UBOUND (array, dimension)")
  (UCASE :syntax "UCASE (\"string\")")
  (UNLOADHIVE :syntax "UNLOADHIVE (\"key\")")
  (VAL :syntax "VAL (\"string\")")
  (VARTYPE :syntax "VARTYPE ($variable)")
  (VARTYPENAME :syntax "VARTYPENAME ($variable)")
  (WRITELINE :syntax "WRITELINE (file handle, \"line\")")
  (WRITEPROFILESTRING :syntax "WRITEPROFILESTRING (\"filename\", \"section\", \"key\", \"string\")")
  (WRITEVALUE :syntax "WRITEVALUE (\"subkey\", \"entry\", \"expression\", \"data type\")"))

(kixtart-doc-register kixtart-make-doc-macro
  (@ADDRESS :description "Address of the network adapter" :type 8 :final t)
  (@BUILD :description "Build number of the operating system" :type 3 :final t)
  (@COLOR :description "Current console colour setting" :type 8 :final t)
  (@COMMENT :description "User comment" :type 8 :final t)
  (@CPU :description "Name of the CPU" :type 8 :final t)
  (@CRLF :description "Carriage-return + Line-feed" :type 8 :final t)
  (@CSD :description "CSD information (e.g. \"Service Pack 1\")" :type 8 :final t)
  (@CURDIR :description "Current directory" :type 8 :final t)
  (@DATE :description "Date in the format YYYY/MM/DD" :type 8 :final t)
  (@DAY :description "Day of the week" :type 8 :final t)
  (@DOMAIN :description "Domain or Workgroup" :type 8 :final t)
  (@DOS :description "Windows version" :type 8 :final t)
  (@ERROR :description "Return code of the most recent command or function" :type 3 :final t)
  (@FULLNAME :description "Full name of current user" :type 8 :final t)
  (@HOMEDIR :description "Short name of the directory component of the home directory" :type 8 :final t)
  (@HOMEDRIVE :description "Drive letter of drive containing the home directory" :type 8 :final t)
  (@HOMESHR :description "Server and share name component of the home directory" :type 8 :final t)
  (@HOSTNAME :description "Fully qualified host name" :type 8 :final t)
  (@INUDF :description "Name of the current user-defined function" :type 8 :final t)
  (@INWIN :description "Operating system (1 is Windows NT, 2 is Windows 9x)" :type 3 :final t)
  ((@IPADDRESS0 @IPADDRESS1 @IPADDRESS2 @IPADDRESS3) :description "TCP/IP address" :type 8 :final t)
  (@KIX :description "KiXtart product name and version" :type 8 :final t)
  (@LANROOT :description "Directory where network software resides (usually Systemroot\\System32)" :type 8 :final t)
  (@LDOMAIN :description "Logon domain" :type 8 :final t)
  (@LDRIVE :description "Drive that is redirected to \\\\logonserver\\NETLOGON" :type 8 :final t)
  (@LM :description "Version of network software" :type 8 :final t)
  (@LOGONMODE :description "If 1, KiXtart is assumed to be running during the logon sequence" :type 3 :final t)
  (@LONGHOMEDIR :description "Long name of the directory component of the home directory" :type 8 :final t)
  (@LSERVER :description "Logon server" :type 8 :final t)
  (@MAXPWAGE :description "Maximum password age" :type 3 :final t)
  (@MDAYNO :description "Day of the month (1 - 31)" :type 3 :final t)
  (@MHZ :description "Approximation of the CPU speed" :type 3 :final t)
  (@MONTHNO :description "Months since January (1 - 12)" :type 3 :final t)
  (@MONTH :description "Name of the month" :type 8 :final t)
  (@MSECS :description "Milliseconds component of the current time" :type 3 :final t)
  (@ONWOW64 :description "If 1, KiXtart is running in the WOW64 environment on a Windows x64 system" :type 3 :final t)
  (@PID :description "Process ID of the KiXtart process" :type 3 :final t)
  (@PRIMARYGROUP :description "Current user's primary group" :type 8 :final t)
  (@PRIV :description "User's privilege level (GUEST, USER, or ADMIN)" :type 8 :final t)
  (@PRODUCTSUITE :description "OS suite ID" :type 3 :final t)
  (@PRODUCTTYPE :description "OS type" :type 8 :final t)
  (@PROGRAMFILESX86 :description "X86 Program Files directory" :type 8 :final t)
  (@PWAGE :description "Password age" :type 3 :final t)
  (@RAS :description "Number of active Remote Access Service (RAS) connections" :type 3 :final t)
  (@RESULT :description "Command specific information (e.g. the drive letter of an automatic redirection command)" :type 8 :final t)
  (@RELEASEID :description "Windows release ID (e.g. 1909, 2003, etc)" :type 3 :final t)
  (@RELEASENAME :description "Windows release name (e.g. 21H2)" :type 8 :final t)
  (@RSERVER :description "KXRPC server used for the current session" :type 8 :final t)
  (@SCRIPTDIR :description "Directory of the current script" :type 8 :final t)
  (@SCRIPTEXE :description "Name of the KiXtart executable" :type 8 :final t)
  (@SCRIPTNAME :description "Name of the current script" :type 8 :final t)
  (@SERROR :description "Error text corresponding with @ERROR" :type 8 :final t)
  (@SID :description "Current user's Windows Security Identifier (SID)" :type 8 :final t)
  (@SITE :description "Name of the site in which the system resides" :type 8 :final t)
  (@STARTDIR :description "Directory from which KiXtart was started" :type 8 :final t)
  (@SYSLANG :description "Language used by the operating system in ISO 639 format" :type 8 :final t)
  (@TICKS :description "Number of milliseconds that have elapsed since the system was started" :type 3 :final t)
  (@TIME :description "Current time in the format HH:MM:SS" :type 8 :final t)
  (@TSSESSION :description "If 1, KiXtart is running in a Terminal Server session" :type 3 :final t)
  (@USERID :description "Current user's Windows user ID" :type 8 :final t)
  (@USERLANG :description "Language selected by the current user in ISO 639 format" :type 8 :final t)
  (@WDAYNO :description "Day of the week as a number (1 - 7, 1 is Monday)" :type 3 :final t)
  (@WKSTA :description "Computer name" :type 8 :final t)
  (@WUSERID :description "Current user's Windows user ID" :type 8 :final t)
  (@YDAYNO :description "Day of the year as a number (1 - 365)" :type 3 :final t)
  (@YEAR :description "Current year" :type 3 :final t))

(provide 'kixtart-docstrings)
;;; kixtart-docstrings.el ends here
