/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLExtensions;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;

final class EncryptedExtensions {
    static final HandshakeProducer handshakeProducer = new EncryptedExtensionsProducer();
    static final SSLConsumer handshakeConsumer = new EncryptedExtensionsConsumer();

    EncryptedExtensions() {
    }

    private static final class EncryptedExtensionsConsumer
    implements SSLConsumer {
        private EncryptedExtensionsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.ENCRYPTED_EXTENSIONS.id);
            EncryptedExtensionsMessage encryptedExtensionsMessage = new EncryptedExtensionsMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming EncryptedExtensions handshake message", encryptedExtensionsMessage);
            }
            SSLExtension[] sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.ENCRYPTED_EXTENSIONS);
            encryptedExtensionsMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            encryptedExtensionsMessage.extensions.consumeOnTrade(clientHandshakeContext, sSLExtensionArray);
        }
    }

    static final class EncryptedExtensionsMessage
    extends SSLHandshake.HandshakeMessage {
        private final SSLExtensions extensions;

        EncryptedExtensionsMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            this.extensions = new SSLExtensions(this);
        }

        EncryptedExtensionsMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 2) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid EncryptedExtensions handshake message: no sufficient data");
            }
            SSLExtension[] sSLExtensionArray = handshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.ENCRYPTED_EXTENSIONS);
            this.extensions = new SSLExtensions(this, byteBuffer, sSLExtensionArray);
        }

        @Override
        SSLHandshake handshakeType() {
            return SSLHandshake.ENCRYPTED_EXTENSIONS;
        }

        @Override
        int messageLength() {
            int n = this.extensions.length();
            if (n == 0) {
                n = 2;
            }
            return n;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            if (this.extensions.length() == 0) {
                handshakeOutStream.putInt16(0);
            } else {
                this.extensions.send(handshakeOutStream);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"EncryptedExtensions\": [\n{0}\n]", Locale.ENGLISH);
            Object[] objectArray = new Object[]{Utilities.indent(this.extensions.toString())};
            return messageFormat.format(objectArray);
        }
    }

    private static final class EncryptedExtensionsProducer
    implements HandshakeProducer {
        private EncryptedExtensionsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            EncryptedExtensionsMessage encryptedExtensionsMessage = new EncryptedExtensionsMessage(serverHandshakeContext);
            SSLExtension[] sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.ENCRYPTED_EXTENSIONS, serverHandshakeContext.negotiatedProtocol);
            encryptedExtensionsMessage.extensions.produce(serverHandshakeContext, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced EncryptedExtensions message", encryptedExtensionsMessage);
            }
            encryptedExtensionsMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }
}

