/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.RSAKeyExchange;
import sun.security.ssl.RSASignature;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class RSAServerKeyExchange {
    static final SSLConsumer rsaHandshakeConsumer = new RSAServerKeyExchangeConsumer();
    static final HandshakeProducer rsaHandshakeProducer = new RSAServerKeyExchangeProducer();

    RSAServerKeyExchange() {
    }

    private static final class RSAServerKeyExchangeConsumer
    implements SSLConsumer {
        private RSAServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            RSAPublicKey rSAPublicKey;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            RSAServerKeyExchangeMessage rSAServerKeyExchangeMessage = new RSAServerKeyExchangeMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming RSA ServerKeyExchange handshake message", rSAServerKeyExchangeMessage);
            }
            try {
                KeyFactory keyFactory = JsseJce.getKeyFactory("RSA");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, rSAServerKeyExchangeMessage.modulus), new BigInteger(1, rSAServerKeyExchangeMessage.exponent));
                rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (GeneralSecurityException generalSecurityException) {
                clientHandshakeContext.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "Could not generate RSAPublicKey", generalSecurityException);
                return;
            }
            if (!clientHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), rSAPublicKey)) {
                clientHandshakeContext.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "RSA ServerKeyExchange does not comply to algorithm constraints");
            }
            clientHandshakeContext.handshakeCredentials.add(new RSAKeyExchange.EphemeralRSACredentials(rSAPublicKey));
        }
    }

    private static final class RSAServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] modulus;
        private final byte[] exponent;
        private final byte[] paramsSignature;

        private RSAServerKeyExchangeMessage(HandshakeContext handshakeContext, X509Authentication.X509Possession x509Possession, RSAKeyExchange.EphemeralRSAPossession ephemeralRSAPossession) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            RSAPublicKey rSAPublicKey = ephemeralRSAPossession.popPublicKey;
            RSAPublicKeySpec rSAPublicKeySpec = JsseJce.getRSAPublicKeySpec(rSAPublicKey);
            this.modulus = Utilities.toByteArray(rSAPublicKeySpec.getModulus());
            this.exponent = Utilities.toByteArray(rSAPublicKeySpec.getPublicExponent());
            byte[] byArray = null;
            try {
                Signature signature = RSASignature.getInstance();
                signature.initSign(x509Possession.popPrivateKey, serverHandshakeContext.sslContext.getSecureRandom());
                this.updateSignature(signature, serverHandshakeContext.clientHelloRandom.randomBytes, serverHandshakeContext.serverHelloRandom.randomBytes);
                byArray = signature.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
                serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ephemeral RSA parameters", generalSecurityException);
            }
            this.paramsSignature = byArray;
        }

        RSAServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            this.modulus = Record.getBytes16(byteBuffer);
            this.exponent = Record.getBytes16(byteBuffer);
            this.paramsSignature = Record.getBytes16(byteBuffer);
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials sSLCredentials : clientHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)sSLCredentials;
                break;
            }
            if (x509Credentials == null) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No RSA credentials negotiated for server key exchange");
            }
            try {
                Signature signature = RSASignature.getInstance();
                signature.initVerify(x509Credentials.popPublicKey);
                this.updateSignature(signature, clientHandshakeContext.clientHelloRandom.randomBytes, clientHandshakeContext.serverHelloRandom.randomBytes);
                if (!signature.verify(this.paramsSignature)) {
                    clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature of RSA ServerKeyExchange message");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
                clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ephemeral RSA parameters", generalSecurityException);
            }
        }

        @Override
        SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        int messageLength() {
            return 6 + this.modulus.length + this.exponent.length + this.paramsSignature.length;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.modulus);
            handshakeOutStream.putBytes16(this.exponent);
            handshakeOutStream.putBytes16(this.paramsSignature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"RSA ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"rsa_modulus\": '{'\n{0}\n    '}',\n    \"rsa_exponent\": '{'\n{1}\n    '}'\n  '}',\n  \"digital signature\":  '{'\n    \"signature\": '{'\n{2}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.modulus), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.exponent), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "      ")};
            return messageFormat.format(objectArray);
        }

        private void updateSignature(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            signature.update((byte)(this.modulus.length >> 8));
            signature.update((byte)(this.modulus.length & 0xFF));
            signature.update(this.modulus);
            signature.update((byte)(this.exponent.length >> 8));
            signature.update((byte)(this.exponent.length & 0xFF));
            signature.update(this.exponent);
        }
    }

    private static final class RSAServerKeyExchangeProducer
    implements HandshakeProducer {
        private RSAServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            RSAKeyExchange.EphemeralRSAPossession ephemeralRSAPossession = null;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : serverHandshakeContext.handshakePossessions) {
                if (sSLPossession instanceof RSAKeyExchange.EphemeralRSAPossession) {
                    ephemeralRSAPossession = (RSAKeyExchange.EphemeralRSAPossession)sSLPossession;
                    if (x509Possession == null) continue;
                    break;
                }
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                if (ephemeralRSAPossession == null) continue;
                break;
            }
            if (ephemeralRSAPossession == null) {
                return null;
            }
            if (x509Possession == null) {
                serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No RSA certificate negotiated for server key exchange");
            } else if (!"RSA".equals(x509Possession.popPrivateKey.getAlgorithm())) {
                serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No X.509 possession can be used for ephemeral RSA ServerKeyExchange");
            }
            RSAServerKeyExchangeMessage rSAServerKeyExchangeMessage = new RSAServerKeyExchangeMessage(serverHandshakeContext, x509Possession, ephemeralRSAPossession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced RSA ServerKeyExchange handshake message", rSAServerKeyExchangeMessage);
            }
            rSAServerKeyExchangeMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }
}

