/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;

final class SupportedVersionsExtension {
    static final HandshakeProducer chNetworkProducer = new CHSupportedVersionsProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHSupportedVersionsConsumer();
    static final SSLStringizer chStringizer = new CHSupportedVersionsStringizer();
    static final HandshakeProducer shNetworkProducer = new SHSupportedVersionsProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHSupportedVersionsConsumer();
    static final SSLStringizer shStringizer = new SHSupportedVersionsStringizer();
    static final HandshakeProducer hrrNetworkProducer = new HRRSupportedVersionsProducer();
    static final SSLExtension.ExtensionConsumer hrrOnLoadConsumer = new HRRSupportedVersionsConsumer();
    static final HandshakeProducer hrrReproducer = new HRRSupportedVersionsReproducer();
    static final SSLStringizer hrrStringizer = new SHSupportedVersionsStringizer();

    SupportedVersionsExtension() {
    }

    private static final class CHSupportedVersionsConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHSupportedVersionsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CHSupportedVersionsSpec cHSupportedVersionsSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.CH_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return;
            }
            try {
                cHSupportedVersionsSpec = new CHSupportedVersionsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SUPPORTED_VERSIONS, cHSupportedVersionsSpec);
        }
    }

    private static final class CHSupportedVersionsProducer
    implements HandshakeProducer {
        private CHSupportedVersionsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.CH_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return null;
            }
            int[] nArray = new int[clientHandshakeContext.activeProtocols.size()];
            int n = nArray.length * 2;
            byte[] byArray = new byte[n + 1];
            byArray[0] = (byte)(n & 0xFF);
            int n2 = 0;
            int n3 = 1;
            for (ProtocolVersion protocolVersion : clientHandshakeContext.activeProtocols) {
                nArray[n2++] = protocolVersion.id;
                byArray[n3++] = protocolVersion.major;
                byArray[n3++] = protocolVersion.minor;
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SUPPORTED_VERSIONS, new CHSupportedVersionsSpec(nArray));
            return byArray;
        }
    }

    static final class CHSupportedVersionsSpec
    implements SSLExtension.SSLExtensionSpec {
        final int[] requestedProtocols;

        private CHSupportedVersionsSpec(int[] nArray) {
            this.requestedProtocols = nArray;
        }

        private CHSupportedVersionsSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 3) {
                throw new SSLProtocolException("Invalid supported_versions extension: insufficient data");
            }
            byte[] byArray = Record.getBytes8(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                throw new SSLProtocolException("Invalid supported_versions extension: unknown extra data");
            }
            if (byArray == null || byArray.length == 0 || (byArray.length & 1) != 0) {
                throw new SSLProtocolException("Invalid supported_versions extension: incomplete data");
            }
            int[] nArray = new int[byArray.length >> 1];
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                byte by = byArray[n++];
                byte by2 = byArray[n++];
                nArray[n2++] = (by & 0xFF) << 8 | by2 & 0xFF;
            }
            this.requestedProtocols = nArray;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"versions\": '['{0}']'", Locale.ENGLISH);
            if (this.requestedProtocols == null || this.requestedProtocols.length == 0) {
                Object[] objectArray = new Object[]{"<no supported version specified>"};
                return messageFormat.format(objectArray);
            }
            StringBuilder stringBuilder = new StringBuilder(512);
            boolean bl = true;
            for (int n : this.requestedProtocols) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(ProtocolVersion.nameOf(n));
            }
            Object[] objectArray = new Object[]{stringBuilder.toString()};
            return messageFormat.format(objectArray);
        }
    }

    private static final class CHSupportedVersionsStringizer
    implements SSLStringizer {
        private CHSupportedVersionsStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CHSupportedVersionsSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    private static final class HRRSupportedVersionsConsumer
    implements SSLExtension.ExtensionConsumer {
        private HRRSupportedVersionsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SHSupportedVersionsSpec sHSupportedVersionsSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.HRR_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return;
            }
            try {
                sHSupportedVersionsSpec = new SHSupportedVersionsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.HRR_SUPPORTED_VERSIONS, sHSupportedVersionsSpec);
        }
    }

    private static final class HRRSupportedVersionsProducer
    implements HandshakeProducer {
        private HRRSupportedVersionsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.HRR_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{serverHandshakeContext.negotiatedProtocol.major, serverHandshakeContext.negotiatedProtocol.minor};
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.HRR_SUPPORTED_VERSIONS, new SHSupportedVersionsSpec(serverHandshakeContext.negotiatedProtocol));
            return byArray;
        }
    }

    private static final class HRRSupportedVersionsReproducer
    implements HandshakeProducer {
        private HRRSupportedVersionsReproducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("[Reproduce] Ignore unavailable extension: " + SSLExtension.HRR_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{serverHandshakeContext.negotiatedProtocol.major, serverHandshakeContext.negotiatedProtocol.minor};
            return byArray;
        }
    }

    private static final class SHSupportedVersionsConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHSupportedVersionsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SHSupportedVersionsSpec sHSupportedVersionsSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.SH_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.SH_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return;
            }
            try {
                sHSupportedVersionsSpec = new SHSupportedVersionsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.SH_SUPPORTED_VERSIONS, sHSupportedVersionsSpec);
        }
    }

    private static final class SHSupportedVersionsProducer
    implements HandshakeProducer {
        private SHSupportedVersionsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            CHSupportedVersionsSpec cHSupportedVersionsSpec = (CHSupportedVersionsSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SUPPORTED_VERSIONS);
            if (cHSupportedVersionsSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Ignore unavailable supported_versions extension", new Object[0]);
                }
                return null;
            }
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.SH_SUPPORTED_VERSIONS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.SH_SUPPORTED_VERSIONS.name, new Object[0]);
                }
                return null;
            }
            byte[] byArray = new byte[]{serverHandshakeContext.negotiatedProtocol.major, serverHandshakeContext.negotiatedProtocol.minor};
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_SUPPORTED_VERSIONS, new SHSupportedVersionsSpec(serverHandshakeContext.negotiatedProtocol));
            return byArray;
        }
    }

    static final class SHSupportedVersionsSpec
    implements SSLExtension.SSLExtensionSpec {
        final int selectedVersion;

        private SHSupportedVersionsSpec(ProtocolVersion protocolVersion) {
            this.selectedVersion = protocolVersion.id;
        }

        private SHSupportedVersionsSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() != 2) {
                throw new SSLProtocolException("Invalid supported_versions: insufficient data");
            }
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            this.selectedVersion = (by & 0xFF) << 8 | by2 & 0xFF;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"selected version\": '['{0}']'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{ProtocolVersion.nameOf(this.selectedVersion)};
            return messageFormat.format(objectArray);
        }
    }

    private static final class SHSupportedVersionsStringizer
    implements SSLStringizer {
        private SHSupportedVersionsStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SHSupportedVersionsSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }
}

