/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AnnotationDefault;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.BootstrapMethods;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantModule;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPackage;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.EnclosingMethod;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTypeTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.MethodParameters;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.util.Stack;

public class DescendingVisitor
implements Visitor {
    private final JavaClass clazz;
    private final Visitor visitor;
    private final Stack<Object> stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int n) {
        int n2 = this.stack.size();
        if (n2 < 2 || n < 0) {
            return null;
        }
        return this.stack.elementAt(n2 - (n + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass javaClass, Visitor visitor) {
        this.clazz = javaClass;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitJavaClass(JavaClass javaClass) {
        this.stack.push(javaClass);
        javaClass.accept(this.visitor);
        Field[] fieldArray = javaClass.getFields();
        for (Field field : fieldArray) {
            field.accept(this);
        }
        FieldOrMethod[] fieldOrMethodArray = javaClass.getMethods();
        Cloneable[] cloneableArray = fieldOrMethodArray;
        int n = cloneableArray.length;
        for (int i = 0; i < n; ++i) {
            FieldOrMethod fieldOrMethod = cloneableArray[i];
            ((Method)fieldOrMethod).accept(this);
        }
        for (Cloneable cloneable : cloneableArray = javaClass.getAttributes()) {
            ((Attribute)cloneable).accept(this);
        }
        javaClass.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitAnnotation(Annotations annotations) {
        AnnotationEntry[] annotationEntryArray;
        this.stack.push(annotations);
        annotations.accept(this.visitor);
        for (AnnotationEntry annotationEntry : annotationEntryArray = annotations.getAnnotationEntries()) {
            annotationEntry.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(Field field) {
        Attribute[] attributeArray;
        this.stack.push(field);
        field.accept(this.visitor);
        for (Attribute attribute : attributeArray = field.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(ConstantValue constantValue) {
        this.stack.push(constantValue);
        constantValue.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(Method method) {
        Attribute[] attributeArray;
        this.stack.push(method);
        method.accept(this.visitor);
        for (Attribute attribute : attributeArray = method.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(ExceptionTable exceptionTable) {
        this.stack.push(exceptionTable);
        exceptionTable.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] codeExceptionArray = code.getExceptionTable();
        Cloneable[] cloneableArray = codeExceptionArray;
        int n = cloneableArray.length;
        for (int i = 0; i < n; ++i) {
            CodeException codeException = cloneableArray[i];
            codeException.accept(this);
        }
        for (Cloneable cloneable : cloneableArray = code.getAttributes()) {
            ((Attribute)cloneable).accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitCodeException(CodeException codeException) {
        this.stack.push(codeException);
        codeException.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(LineNumberTable lineNumberTable) {
        LineNumber[] lineNumberArray;
        this.stack.push(lineNumberTable);
        lineNumberTable.accept(this.visitor);
        for (LineNumber lineNumber : lineNumberArray = lineNumberTable.getLineNumberTable()) {
            lineNumber.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(LineNumber lineNumber) {
        this.stack.push(lineNumber);
        lineNumber.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        LocalVariable[] localVariableArray;
        this.stack.push(localVariableTable);
        localVariableTable.accept(this.visitor);
        for (LocalVariable localVariable : localVariableArray = localVariableTable.getLocalVariableTable()) {
            localVariable.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMap(StackMap stackMap) {
        StackMapEntry[] stackMapEntryArray;
        this.stack.push(stackMap);
        stackMap.accept(this.visitor);
        for (StackMapEntry stackMapEntry : stackMapEntryArray = stackMap.getStackMap()) {
            stackMapEntry.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(StackMapEntry stackMapEntry) {
        this.stack.push(stackMapEntry);
        stackMapEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(LocalVariable localVariable) {
        this.stack.push(localVariable);
        localVariable.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
        this.stack.push(constantPool);
        constantPool.accept(this.visitor);
        Constant[] constantArray = constantPool.getConstantPool();
        for (int i = 1; i < constantArray.length; ++i) {
            if (constantArray[i] == null) continue;
            constantArray[i].accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(ConstantClass constantClass) {
        this.stack.push(constantClass);
        constantClass.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(ConstantDouble constantDouble) {
        this.stack.push(constantDouble);
        constantDouble.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(ConstantFieldref constantFieldref) {
        this.stack.push(constantFieldref);
        constantFieldref.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(ConstantFloat constantFloat) {
        this.stack.push(constantFloat);
        constantFloat.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(ConstantInteger constantInteger) {
        this.stack.push(constantInteger);
        constantInteger.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
        this.stack.push(constantInterfaceMethodref);
        constantInterfaceMethodref.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(ConstantInvokeDynamic constantInvokeDynamic) {
        this.stack.push(constantInvokeDynamic);
        constantInvokeDynamic.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(ConstantLong constantLong) {
        this.stack.push(constantLong);
        constantLong.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(ConstantMethodref constantMethodref) {
        this.stack.push(constantMethodref);
        constantMethodref.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this.stack.push(constantNameAndType);
        constantNameAndType.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantString(ConstantString constantString) {
        this.stack.push(constantString);
        constantString.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        this.stack.push(constantUtf8);
        constantUtf8.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(InnerClasses innerClasses) {
        InnerClass[] innerClassArray;
        this.stack.push(innerClasses);
        innerClasses.accept(this.visitor);
        for (InnerClass innerClass : innerClassArray = innerClasses.getInnerClasses()) {
            innerClass.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(InnerClass innerClass) {
        this.stack.push(innerClass);
        innerClass.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods bootstrapMethods) {
        this.stack.push(bootstrapMethods);
        bootstrapMethods.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(Deprecated deprecated) {
        this.stack.push(deprecated);
        deprecated.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(Signature signature) {
        this.stack.push(signature);
        signature.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(SourceFile sourceFile) {
        this.stack.push(sourceFile);
        sourceFile.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(Synthetic synthetic) {
        this.stack.push(synthetic);
        synthetic.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(Unknown unknown) {
        this.stack.push(unknown);
        unknown.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(AnnotationDefault annotationDefault) {
        this.stack.push(annotationDefault);
        annotationDefault.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(EnclosingMethod enclosingMethod) {
        this.stack.push(enclosingMethod);
        enclosingMethod.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(LocalVariableTypeTable localVariableTypeTable) {
        this.stack.push(localVariableTypeTable);
        localVariableTypeTable.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations parameterAnnotations) {
        this.stack.push(parameterAnnotations);
        parameterAnnotations.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(MethodParameters methodParameters) {
        this.stack.push(methodParameters);
        methodParameters.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(ConstantMethodType constantMethodType) {
        this.stack.push(constantMethodType);
        constantMethodType.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(ConstantMethodHandle constantMethodHandle) {
        this.stack.push(constantMethodHandle);
        constantMethodHandle.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(ParameterAnnotationEntry parameterAnnotationEntry) {
        this.stack.push(parameterAnnotationEntry);
        parameterAnnotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPackage(ConstantPackage constantPackage) {
        this.stack.push(constantPackage);
        constantPackage.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantModule(ConstantModule constantModule) {
        this.stack.push(constantModule);
        constantModule.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDynamic(ConstantDynamic constantDynamic) {
        this.stack.push(constantDynamic);
        constantDynamic.accept(this.visitor);
        this.stack.pop();
    }
}

