/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnumElementValue
extends ElementValue {
    private final int typeIdx;
    private final int valueIdx;

    public EnumElementValue(int n, int n2, int n3, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor - type specified: " + n);
        }
        this.typeIdx = n2;
        this.valueIdx = n3;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getType());
        dataOutputStream.writeShort(this.typeIdx);
        dataOutputStream.writeShort(this.valueIdx);
    }

    @Override
    public String stringifyValue() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return constantUtf8.getBytes();
    }

    public String getEnumTypeString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.typeIdx, (byte)1);
        return constantUtf8.getBytes();
    }

    public String getEnumValueString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

