/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;

public final class Field
extends FieldOrMethod {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            Field field = (Field)object;
            Field field2 = (Field)object2;
            return Objects.equals(field.getName(), field2.getName()) && Objects.equals(field.getSignature(), field2.getSignature());
        }

        @Override
        public int hashCode(Object object) {
            Field field = (Field)object;
            return field.getSignature().hashCode() ^ field.getName().hashCode();
        }
    };

    public Field(Field field) {
        super(field);
    }

    Field(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFormatException {
        super(dataInput, constantPool);
    }

    public Field(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        for (Attribute attribute : super.getAttributes()) {
            if (attribute.getTag() != 1) continue;
            return (ConstantValue)attribute;
        }
        return null;
    }

    public final String toString() {
        String string = Utility.accessToString(super.getAccessFlags());
        string = string.isEmpty() ? "" : string + " ";
        String string2 = Utility.signatureToString(this.getSignature());
        String string3 = this.getName();
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(string).append(string2).append(" ").append(string3);
        ConstantValue constantValue = this.getConstantValue();
        if (constantValue != null) {
            stringBuilder.append(" = ").append(constantValue);
        }
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof ConstantValue) continue;
            stringBuilder.append(" [").append(attribute).append("]");
        }
        return stringBuilder.toString();
    }

    public final Field copy(ConstantPool constantPool) {
        return (Field)this.copy_(constantPool);
    }

    public Type getType() {
        return Type.getReturnType(this.getSignature());
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

