/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ClassElementValue;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassElementValueGen
extends ElementValueGen {
    private int idx;

    protected ClassElementValueGen(int n, ConstantPoolGen constantPoolGen) {
        super(99, constantPoolGen);
        this.idx = n;
    }

    public ClassElementValueGen(ObjectType objectType, ConstantPoolGen constantPoolGen) {
        super(99, constantPoolGen);
        this.idx = constantPoolGen.addUtf8(objectType.getSignature());
    }

    @Override
    public ElementValue getElementValue() {
        return new ClassElementValue(super.getElementValueType(), this.idx, this.getConstantPool().getConstantPool());
    }

    public ClassElementValueGen(ClassElementValue classElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(99, constantPoolGen);
        this.idx = bl ? constantPoolGen.addUtf8(classElementValue.getClassString()) : classElementValue.getIndex();
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return constantUtf8.getBytes();
    }

    @Override
    public String stringifyValue() {
        return this.getClassString();
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getElementValueType());
        dataOutputStream.writeShort(this.idx);
    }
}

