/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.Type;

public abstract class ReferenceType
extends Type {
    protected ReferenceType(byte by, String string) {
        super(by, string);
    }

    ReferenceType() {
        super((byte)14, "<null object>");
    }

    public boolean isCastableTo(Type type) throws ClassNotFoundException {
        if (this.equals(Type.NULL)) {
            return type instanceof ReferenceType;
        }
        return this.isAssignmentCompatibleWith(type);
    }

    public boolean isAssignmentCompatibleWith(Type type) throws ClassNotFoundException {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        ReferenceType referenceType = (ReferenceType)type;
        if (this.equals(Type.NULL)) {
            return true;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesClassExact()) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClassExact()) {
                if (this.equals(referenceType)) {
                    return true;
                }
                if (Repository.instanceOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                    return true;
                }
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterfaceExact() && Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                return true;
            }
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterfaceExact()) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClassExact() && referenceType.equals(Type.OBJECT)) {
                return true;
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterfaceExact()) {
                if (this.equals(referenceType)) {
                    return true;
                }
                if (Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                    return true;
                }
            }
        }
        if (this instanceof ArrayType) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClassExact() && referenceType.equals(Type.OBJECT)) {
                return true;
            }
            if (referenceType instanceof ArrayType) {
                Type type2 = ((ArrayType)this).getElementType();
                Type object = ((ArrayType)referenceType).getElementType();
                if (type2 instanceof BasicType && object instanceof BasicType && type2.equals(object)) {
                    return true;
                }
                if (object instanceof ReferenceType && type2 instanceof ReferenceType && ((ReferenceType)type2).isAssignmentCompatibleWith(object)) {
                    return true;
                }
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterfaceExact()) {
                for (String string : Const.getInterfacesImplementedByArrays()) {
                    if (!referenceType.equals(ObjectType.getInstance(string))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ReferenceType getFirstCommonSuperclass(ReferenceType referenceType) throws ClassNotFoundException {
        ReferenceType referenceType2;
        ReferenceType referenceType3;
        if (this.equals(Type.NULL)) {
            return referenceType;
        }
        if (referenceType.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(referenceType)) {
            return this;
        }
        if (this instanceof ArrayType && referenceType instanceof ArrayType) {
            referenceType3 = (ArrayType)this;
            referenceType2 = (ArrayType)referenceType;
            if (((ArrayType)referenceType3).getDimensions() == ((ArrayType)referenceType2).getDimensions() && ((ArrayType)referenceType3).getBasicType() instanceof ObjectType && ((ArrayType)referenceType2).getBasicType() instanceof ObjectType) {
                return new ArrayType(((ObjectType)((ArrayType)referenceType3).getBasicType()).getFirstCommonSuperclass((ObjectType)((ArrayType)referenceType2).getBasicType()), ((ArrayType)referenceType3).getDimensions());
            }
        }
        if (this instanceof ArrayType || referenceType instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterfaceExact() || referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterfaceExact()) {
            return Type.OBJECT;
        }
        referenceType3 = (ObjectType)this;
        referenceType2 = (ObjectType)referenceType;
        JavaClass[] javaClassArray = Repository.getSuperClasses(((ObjectType)referenceType3).getClassName());
        JavaClass[] javaClassArray2 = Repository.getSuperClasses(((ObjectType)referenceType2).getClassName());
        if (javaClassArray == null || javaClassArray2 == null) {
            return null;
        }
        JavaClass[] javaClassArray3 = new JavaClass[javaClassArray.length + 1];
        JavaClass[] javaClassArray4 = new JavaClass[javaClassArray2.length + 1];
        System.arraycopy(javaClassArray, 0, javaClassArray3, 1, javaClassArray.length);
        System.arraycopy(javaClassArray2, 0, javaClassArray4, 1, javaClassArray2.length);
        javaClassArray3[0] = Repository.lookupClass(((ObjectType)referenceType3).getClassName());
        javaClassArray4[0] = Repository.lookupClass(((ObjectType)referenceType2).getClassName());
        for (JavaClass javaClass : javaClassArray4) {
            for (JavaClass javaClass2 : javaClassArray3) {
                if (!javaClass2.equals(javaClass)) continue;
                return ObjectType.getInstance(javaClass2.getClassName());
            }
        }
        return null;
    }

    @Deprecated
    public ReferenceType firstCommonSuperclass(ReferenceType referenceType) throws ClassNotFoundException {
        if (this.equals(Type.NULL)) {
            return referenceType;
        }
        if (referenceType.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(referenceType)) {
            return this;
        }
        if (this instanceof ArrayType || referenceType instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface() || referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
            return Type.OBJECT;
        }
        ObjectType objectType = (ObjectType)this;
        ObjectType objectType2 = (ObjectType)referenceType;
        JavaClass[] javaClassArray = Repository.getSuperClasses(objectType.getClassName());
        JavaClass[] javaClassArray2 = Repository.getSuperClasses(objectType2.getClassName());
        if (javaClassArray == null || javaClassArray2 == null) {
            return null;
        }
        JavaClass[] javaClassArray3 = new JavaClass[javaClassArray.length + 1];
        JavaClass[] javaClassArray4 = new JavaClass[javaClassArray2.length + 1];
        System.arraycopy(javaClassArray, 0, javaClassArray3, 1, javaClassArray.length);
        System.arraycopy(javaClassArray2, 0, javaClassArray4, 1, javaClassArray2.length);
        javaClassArray3[0] = Repository.lookupClass(objectType.getClassName());
        javaClassArray4[0] = Repository.lookupClass(objectType2.getClassName());
        for (JavaClass javaClass : javaClassArray4) {
            for (JavaClass javaClass2 : javaClassArray3) {
                if (!javaClass2.equals(javaClass)) continue;
                return ObjectType.getInstance(javaClass2.getClassName());
            }
        }
        return null;
    }
}

