/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.SimpleElementValue;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimpleElementValueGen
extends ElementValueGen {
    private int idx;

    protected SimpleElementValueGen(int n, int n2, ConstantPoolGen constantPoolGen) {
        super(n, constantPoolGen);
        this.idx = n2;
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, int n2) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addInteger(n2);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, long l) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addLong(l);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, double d) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addDouble(d);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, float f) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addFloat(f);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, short s) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addInteger(s);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, byte by) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addInteger(by);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, char c) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addInteger(c);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, boolean bl) {
        super(n, constantPoolGen);
        this.idx = bl ? this.getConstantPool().addInteger(1) : this.getConstantPool().addInteger(0);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, String string) {
        super(n, constantPoolGen);
        this.idx = this.getConstantPool().addUtf8(string);
    }

    public SimpleElementValueGen(SimpleElementValue simpleElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(simpleElementValue.getElementValueType(), constantPoolGen);
        if (!bl) {
            this.idx = simpleElementValue.getIndex();
        } else {
            switch (simpleElementValue.getElementValueType()) {
                case 115: {
                    this.idx = constantPoolGen.addUtf8(simpleElementValue.getValueString());
                    break;
                }
                case 73: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueInt());
                    break;
                }
                case 66: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueByte());
                    break;
                }
                case 67: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueChar());
                    break;
                }
                case 74: {
                    this.idx = constantPoolGen.addLong(simpleElementValue.getValueLong());
                    break;
                }
                case 70: {
                    this.idx = constantPoolGen.addFloat(simpleElementValue.getValueFloat());
                    break;
                }
                case 68: {
                    this.idx = constantPoolGen.addDouble(simpleElementValue.getValueDouble());
                    break;
                }
                case 90: {
                    if (simpleElementValue.getValueBoolean()) {
                        this.idx = constantPoolGen.addInteger(1);
                        break;
                    }
                    this.idx = constantPoolGen.addInteger(0);
                    break;
                }
                case 83: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueShort());
                    break;
                }
                default: {
                    throw new RuntimeException("SimpleElementValueGen class does not know how to copy this type " + super.getElementValueType());
                }
            }
        }
    }

    @Override
    public ElementValue getElementValue() {
        return new SimpleElementValue(super.getElementValueType(), this.idx, this.getConstantPool().getConstantPool());
    }

    public int getIndex() {
        return this.idx;
    }

    public String getValueString() {
        if (super.getElementValueType() != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return constantUtf8.getBytes();
    }

    public int getValueInt() {
        if (super.getElementValueType() != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
        return constantInteger.getBytes();
    }

    @Override
    public String stringifyValue() {
        switch (super.getElementValueType()) {
            case 73: {
                ConstantInteger constantInteger = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)this.getConstantPool().getConstant(this.idx);
                return Long.toString(constantLong.getBytes());
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)this.getConstantPool().getConstant(this.idx);
                return Double.toString(constantDouble.getBytes());
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)this.getConstantPool().getConstant(this.idx);
                return Float.toString(constantFloat.getBytes());
            }
            case 83: {
                ConstantInteger constantInteger = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 66: {
                ConstantInteger constantInteger = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 67: {
                ConstantInteger constantInteger = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 90: {
                ConstantInteger constantInteger = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                if (constantInteger.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
                return constantUtf8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + super.getElementValueType());
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getElementValueType());
        switch (super.getElementValueType()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataOutputStream.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen doesnt know how to write out type " + super.getElementValueType());
            }
        }
    }
}

