/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.AttributeHTML;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class MethodHTML {
    private final String class_name;
    private final PrintWriter file;
    private final ConstantHTML constant_html;
    private final AttributeHTML attribute_html;

    MethodHTML(String string, String string2, Method[] methodArray, Field[] fieldArray, ConstantHTML constantHTML, AttributeHTML attributeHTML) throws IOException {
        this.class_name = string2;
        this.attribute_html = attributeHTML;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_methods.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        this.file.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
        for (Field field : fieldArray) {
            this.writeField(field);
        }
        this.file.println("</TABLE>");
        this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
        for (int i = 0; i < methodArray.length; ++i) {
            this.writeMethod(methodArray[i], i);
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    private void writeField(Field field) throws IOException {
        int n;
        String string = Utility.signatureToString(field.getSignature());
        String string2 = field.getName();
        String string3 = Utility.accessToString(field.getAccessFlags());
        string3 = Utility.replace(string3, " ", "&nbsp;");
        this.file.print("<TR><TD><FONT COLOR=\"#FF0000\">" + string3 + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(string) + "</TD><TD><A NAME=\"field" + string2 + "\">" + string2 + "</A></TD>");
        Attribute[] attributeArray = field.getAttributes();
        for (n = 0; n < attributeArray.length; ++n) {
            this.attribute_html.writeAttribute(attributeArray[n], string2 + "@" + n);
        }
        for (n = 0; n < attributeArray.length; ++n) {
            if (attributeArray[n].getTag() != 1) continue;
            String string4 = ((ConstantValue)attributeArray[n]).toString();
            this.file.print("<TD>= <A HREF=\"" + this.class_name + "_attributes.html#" + string2 + "@" + n + "\" TARGET=\"Attributes\">" + string4 + "</TD>\n");
            break;
        }
        this.file.println("</TR>");
    }

    private void writeMethod(Method method, int n) {
        int n2;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributeArray = method.getAttributes();
        string4 = Utility.replace(string4, " ", "&nbsp;");
        String string5 = Class2HTML.toHTML(string3);
        this.file.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + n + ">" + string4 + "</A></FONT></TD>");
        this.file.print("<TD>" + Class2HTML.referenceType(string2) + "</TD><TD><A HREF=" + this.class_name + "_code.html#method" + n + " TARGET=Code>" + string5 + "</A></TD>\n<TD>(");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.file.print(Class2HTML.referenceType(stringArray[n2]));
            if (n2 >= stringArray.length - 1) continue;
            this.file.print(", ");
        }
        this.file.print(")</TD></TR>");
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            int n3;
            Object[] objectArray;
            this.attribute_html.writeAttribute(attributeArray[n2], "method" + n + "@" + n2, n);
            byte by = attributeArray[n2].getTag();
            if (by == 3) {
                this.file.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                objectArray = ((ExceptionTable)attributeArray[n2]).getExceptionIndexTable();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    this.file.print(this.constant_html.referenceConstant((int)objectArray[n3]));
                    if (n3 >= objectArray.length - 1) continue;
                    this.file.print(", ");
                }
                this.file.println("</TD></TR>");
                continue;
            }
            if (by != 2) continue;
            objectArray = ((Code)attributeArray[n2]).getAttributes();
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.attribute_html.writeAttribute(objectArray[n3], "method" + n + "@" + n2 + "@" + n3, n);
            }
        }
    }
}

