/*
 * Part of the contents for this file has been generated by
 * https://github.com/zevlg/py-scripts/gen-telega-emoji-trie.py
 *
 */
#include <sys/types.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>

struct emoji_trie {
#define EMOJI_MATCH_ANY 0xffffffff
        const uint32_t match;
        bool is_terminal;

        const struct emoji_trie* childs;
};

struct emoji_match_table {
        const uint32_t min_match;
        const uint32_t max_match;

        /* In case MATCH, matches in the middle
         * Maximum number of backward chars to backtrack
         */
        size_t max_backtrack;

        /* Use `any_emoji' (see below) to match any char between
         * min_match&max_match
         */
        const struct emoji_trie* match_trie;
};

struct emoji_backtrack {
        /* Number of valid starts and offsets */
        size_t size;

#define EMOJI_BACKTRACK_SIZE 3
        /* Start positions in the telega_dat structure */
        size_t starts[EMOJI_BACKTRACK_SIZE];

        /* Offsets in utf16 chars */
        size_t offsets[EMOJI_BACKTRACK_SIZE];
};

struct emoji_trie any_emoji[] = {{EMOJI_MATCH_ANY, true, NULL},
{0, true, NULL}};


/** Generated sequences **/
/* FE0F Sequences */
struct emoji_trie fe0f2[] = {{0xfe0f, true, NULL},
{0, true, NULL}};

struct emoji_trie fe0f210[] = {{0x20e3, true, NULL},
{0, true, NULL}};

struct emoji_trie fe0f209[] = {{0xfe0f, true, fe0f210},
{0, true, NULL}};

struct emoji_trie fe0f1[] = {{0xa9, false, fe0f2},
{0xae, false, fe0f2},
{0x203c, false, fe0f2},
{0x2049, false, fe0f2},
{0x2122, false, fe0f2},
{0x2139, false, fe0f2},
{0x2194, false, fe0f2},
{0x2195, false, fe0f2},
{0x2196, false, fe0f2},
{0x2197, false, fe0f2},
{0x2198, false, fe0f2},
{0x2199, false, fe0f2},
{0x21a9, false, fe0f2},
{0x21aa, false, fe0f2},
{0x2328, false, fe0f2},
{0x23cf, false, fe0f2},
{0x23ed, false, fe0f2},
{0x23ee, false, fe0f2},
{0x23ef, false, fe0f2},
{0x23f1, false, fe0f2},
{0x23f2, false, fe0f2},
{0x23f8, false, fe0f2},
{0x23f9, false, fe0f2},
{0x23fa, false, fe0f2},
{0x24c2, false, fe0f2},
{0x25aa, false, fe0f2},
{0x25ab, false, fe0f2},
{0x25b6, false, fe0f2},
{0x25c0, false, fe0f2},
{0x25fb, false, fe0f2},
{0x25fc, false, fe0f2},
{0x2600, false, fe0f2},
{0x2601, false, fe0f2},
{0x2602, false, fe0f2},
{0x2603, false, fe0f2},
{0x2604, false, fe0f2},
{0x260e, false, fe0f2},
{0x2611, false, fe0f2},
{0x2618, false, fe0f2},
{0x261d, false, fe0f2},
{0x2620, false, fe0f2},
{0x2622, false, fe0f2},
{0x2623, false, fe0f2},
{0x2626, false, fe0f2},
{0x262a, false, fe0f2},
{0x262e, false, fe0f2},
{0x262f, false, fe0f2},
{0x2638, false, fe0f2},
{0x2639, false, fe0f2},
{0x263a, false, fe0f2},
{0x2640, false, fe0f2},
{0x2642, false, fe0f2},
{0x265f, false, fe0f2},
{0x2660, false, fe0f2},
{0x2663, false, fe0f2},
{0x2665, false, fe0f2},
{0x2666, false, fe0f2},
{0x2668, false, fe0f2},
{0x267b, false, fe0f2},
{0x267e, false, fe0f2},
{0x2692, false, fe0f2},
{0x2694, false, fe0f2},
{0x2695, false, fe0f2},
{0x2696, false, fe0f2},
{0x2697, false, fe0f2},
{0x2699, false, fe0f2},
{0x269b, false, fe0f2},
{0x269c, false, fe0f2},
{0x26a0, false, fe0f2},
{0x26a7, false, fe0f2},
{0x26b0, false, fe0f2},
{0x26b1, false, fe0f2},
{0x26c8, false, fe0f2},
{0x26cf, false, fe0f2},
{0x26d1, false, fe0f2},
{0x26d3, false, fe0f2},
{0x26e9, false, fe0f2},
{0x26f0, false, fe0f2},
{0x26f1, false, fe0f2},
{0x26f4, false, fe0f2},
{0x26f7, false, fe0f2},
{0x26f8, false, fe0f2},
{0x26f9, false, fe0f2},
{0x2702, false, fe0f2},
{0x2708, false, fe0f2},
{0x2709, false, fe0f2},
{0x270c, false, fe0f2},
{0x270d, false, fe0f2},
{0x270f, false, fe0f2},
{0x2712, false, fe0f2},
{0x2714, false, fe0f2},
{0x2716, false, fe0f2},
{0x271d, false, fe0f2},
{0x2721, false, fe0f2},
{0x2733, false, fe0f2},
{0x2734, false, fe0f2},
{0x2744, false, fe0f2},
{0x2747, false, fe0f2},
{0x2763, false, fe0f2},
{0x2764, false, fe0f2},
{0x27a1, false, fe0f2},
{0x2934, false, fe0f2},
{0x2935, false, fe0f2},
{0x2b05, false, fe0f2},
{0x2b06, false, fe0f2},
{0x2b07, false, fe0f2},
{0x3030, false, fe0f2},
{0x303d, false, fe0f2},
{0x3297, false, fe0f2},
{0x3299, false, fe0f2},
{0x1f170, false, fe0f2},
{0x1f171, false, fe0f2},
{0x1f17e, false, fe0f2},
{0x1f17f, false, fe0f2},
{0x1f202, false, fe0f2},
{0x1f237, false, fe0f2},
{0x1f321, false, fe0f2},
{0x1f324, false, fe0f2},
{0x1f325, false, fe0f2},
{0x1f326, false, fe0f2},
{0x1f327, false, fe0f2},
{0x1f328, false, fe0f2},
{0x1f329, false, fe0f2},
{0x1f32a, false, fe0f2},
{0x1f32b, false, fe0f2},
{0x1f32c, false, fe0f2},
{0x1f336, false, fe0f2},
{0x1f37d, false, fe0f2},
{0x1f396, false, fe0f2},
{0x1f397, false, fe0f2},
{0x1f399, false, fe0f2},
{0x1f39a, false, fe0f2},
{0x1f39b, false, fe0f2},
{0x1f39e, false, fe0f2},
{0x1f39f, false, fe0f2},
{0x1f3cb, false, fe0f2},
{0x1f3cc, false, fe0f2},
{0x1f3cd, false, fe0f2},
{0x1f3ce, false, fe0f2},
{0x1f3d4, false, fe0f2},
{0x1f3d5, false, fe0f2},
{0x1f3d6, false, fe0f2},
{0x1f3d7, false, fe0f2},
{0x1f3d8, false, fe0f2},
{0x1f3d9, false, fe0f2},
{0x1f3da, false, fe0f2},
{0x1f3db, false, fe0f2},
{0x1f3dc, false, fe0f2},
{0x1f3dd, false, fe0f2},
{0x1f3de, false, fe0f2},
{0x1f3df, false, fe0f2},
{0x1f3f3, false, fe0f2},
{0x1f3f5, false, fe0f2},
{0x1f3f7, false, fe0f2},
{0x1f43f, false, fe0f2},
{0x1f441, false, fe0f2},
{0x1f4fd, false, fe0f2},
{0x1f549, false, fe0f2},
{0x1f54a, false, fe0f2},
{0x1f56f, false, fe0f2},
{0x1f570, false, fe0f2},
{0x1f573, false, fe0f2},
{0x1f574, false, fe0f2},
{0x1f575, false, fe0f2},
{0x1f576, false, fe0f2},
{0x1f577, false, fe0f2},
{0x1f578, false, fe0f2},
{0x1f579, false, fe0f2},
{0x1f587, false, fe0f2},
{0x1f58a, false, fe0f2},
{0x1f58b, false, fe0f2},
{0x1f58c, false, fe0f2},
{0x1f58d, false, fe0f2},
{0x1f590, false, fe0f2},
{0x1f5a5, false, fe0f2},
{0x1f5a8, false, fe0f2},
{0x1f5b1, false, fe0f2},
{0x1f5b2, false, fe0f2},
{0x1f5bc, false, fe0f2},
{0x1f5c2, false, fe0f2},
{0x1f5c3, false, fe0f2},
{0x1f5c4, false, fe0f2},
{0x1f5d1, false, fe0f2},
{0x1f5d2, false, fe0f2},
{0x1f5d3, false, fe0f2},
{0x1f5dc, false, fe0f2},
{0x1f5dd, false, fe0f2},
{0x1f5de, false, fe0f2},
{0x1f5e1, false, fe0f2},
{0x1f5e3, false, fe0f2},
{0x1f5e8, false, fe0f2},
{0x1f5ef, false, fe0f2},
{0x1f5f3, false, fe0f2},
{0x1f5fa, false, fe0f2},
{0x1f6cb, false, fe0f2},
{0x1f6cd, false, fe0f2},
{0x1f6ce, false, fe0f2},
{0x1f6cf, false, fe0f2},
{0x1f6e0, false, fe0f2},
{0x1f6e1, false, fe0f2},
{0x1f6e2, false, fe0f2},
{0x1f6e3, false, fe0f2},
{0x1f6e4, false, fe0f2},
{0x1f6e5, false, fe0f2},
{0x1f6e9, false, fe0f2},
{0x1f6f0, false, fe0f2},
{0x1f6f3, false, fe0f2},

{0x23, false, fe0f209},
{0x2a, false, fe0f209},
{0x30, false, fe0f209},
{0x31, false, fe0f209},
{0x32, false, fe0f209},
{0x33, false, fe0f209},
{0x34, false, fe0f209},
{0x35, false, fe0f209},
{0x36, false, fe0f209},
{0x37, false, fe0f209},
{0x38, false, fe0f209},
{0x39, false, fe0f209},
{0, true, NULL}};

/* NOTE: treat <digit>⃣ also as emoji as in official client */
struct emoji_trie emoji_keycaps_no_fe0f[] = {
{0x23, false, fe0f210},
{0x2a, false, fe0f210},
{0x30, false, fe0f210},
{0x31, false, fe0f210},
{0x32, false, fe0f210},
{0x33, false, fe0f210},
{0x34, false, fe0f210},
{0x35, false, fe0f210},
{0x36, false, fe0f210},
{0x37, false, fe0f210},
{0x38, false, fe0f210},
{0x39, false, fe0f210},
{0, true, NULL}};

struct emoji_trie emoji_12_1_basic1_fe0f[] = {
{0x231a, false, fe0f2},
{0x231b, false, fe0f2},
{0x23e9, false, fe0f2},
{0x23ea, false, fe0f2},
{0x23f3, false, fe0f2},
{0x25fd, false, fe0f2},
{0x25fe, false, fe0f2},
{0x2614, false, fe0f2},
{0x2615, false, fe0f2},
{0x2648, false, fe0f2},
{0x2649, false, fe0f2},
{0x264a, false, fe0f2},
{0x264b, false, fe0f2},
{0x264c, false, fe0f2},
{0x264d, false, fe0f2},
{0x264e, false, fe0f2},
{0x264f, false, fe0f2},
{0x2650, false, fe0f2},
{0x2651, false, fe0f2},
{0x2652, false, fe0f2},
{0x2653, false, fe0f2},
{0x267f, false, fe0f2},
{0x2693, false, fe0f2},
{0x26a1, false, fe0f2},
{0x26aa, false, fe0f2},
{0x26ab, false, fe0f2},
{0x26bd, false, fe0f2},
{0x26be, false, fe0f2},
{0x26c4, false, fe0f2},
{0x26c5, false, fe0f2},
{0x26d4, false, fe0f2},
{0x26ea, false, fe0f2},
{0x26f2, false, fe0f2},
{0x26f3, false, fe0f2},
{0x26f5, false, fe0f2},
{0x26fa, false, fe0f2},
{0x26fd, false, fe0f2},
{0x2753, false, fe0f2},
{0x2757, false, fe0f2},
{0x2b1b, false, fe0f2},
{0x2b1c, false, fe0f2},
{0x2b50, false, fe0f2},
{0x2b55, false, fe0f2},
{0, true, NULL}};

struct emoji_trie emoji_12_1_basic2_fe0f[] = {
{0x1f004, false, fe0f2},
{0x1f21a, false, fe0f2},
{0x1f22f, false, fe0f2},
{0x1f30d, false, fe0f2},
{0x1f30e, false, fe0f2},
{0x1f30f, false, fe0f2},
{0x1f315, false, fe0f2},
{0x1f31c, false, fe0f2},
{0x1f378, false, fe0f2},
{0x1f393, false, fe0f2},
{0x1f3a7, false, fe0f2},
{0x1f3ac, false, fe0f2},
{0x1f3ad, false, fe0f2},
{0x1f3ae, false, fe0f2},
{0x1f3c2, false, fe0f2},
{0x1f3c4, false, fe0f2},
{0x1f3c6, false, fe0f2},
{0x1f3ca, false, fe0f2},
{0x1f3e0, false, fe0f2},
{0x1f3ed, false, fe0f2},
{0x1f408, false, fe0f2},
{0x1f415, false, fe0f2},
{0x1f41f, false, fe0f2},
{0x1f426, false, fe0f2},
{0x1f442, false, fe0f2},
{0x1f446, false, fe0f2},
{0x1f447, false, fe0f2},
{0x1f448, false, fe0f2},
{0x1f449, false, fe0f2},
{0x1f44d, false, fe0f2},
{0x1f44e, false, fe0f2},
{0x1f453, false, fe0f2},
{0x1f46a, false, fe0f2},
{0x1f47d, false, fe0f2},
{0x1f4a3, false, fe0f2},
{0x1f4b0, false, fe0f2},
{0x1f4b3, false, fe0f2},
{0x1f4bb, false, fe0f2},
{0x1f4bf, false, fe0f2},
{0x1f4cb, false, fe0f2},
{0x1f4da, false, fe0f2},
{0x1f4df, false, fe0f2},
{0x1f4e4, false, fe0f2},
{0x1f4e5, false, fe0f2},
{0x1f4e6, false, fe0f2},
{0x1f4ea, false, fe0f2},
{0x1f4eb, false, fe0f2},
{0x1f4ec, false, fe0f2},
{0x1f4ed, false, fe0f2},
{0x1f4f7, false, fe0f2},
{0x1f4f9, false, fe0f2},
{0x1f4fa, false, fe0f2},
{0x1f4fb, false, fe0f2},
{0x1f508, false, fe0f2},
{0x1f50d, false, fe0f2},
{0x1f512, false, fe0f2},
{0x1f513, false, fe0f2},
{0x1f550, false, fe0f2},
{0x1f551, false, fe0f2},
{0x1f552, false, fe0f2},
{0x1f553, false, fe0f2},
{0x1f554, false, fe0f2},
{0x1f555, false, fe0f2},
{0x1f556, false, fe0f2},
{0x1f557, false, fe0f2},
{0x1f558, false, fe0f2},
{0x1f559, false, fe0f2},
{0x1f55a, false, fe0f2},
{0x1f55b, false, fe0f2},
{0x1f55c, false, fe0f2},
{0x1f55d, false, fe0f2},
{0x1f55e, false, fe0f2},
{0x1f55f, false, fe0f2},
{0x1f560, false, fe0f2},
{0x1f561, false, fe0f2},
{0x1f562, false, fe0f2},
{0x1f563, false, fe0f2},
{0x1f564, false, fe0f2},
{0x1f565, false, fe0f2},
{0x1f566, false, fe0f2},
{0x1f567, false, fe0f2},
{0x1f610, false, fe0f2},
{0x1f687, false, fe0f2},
{0x1f68d, false, fe0f2},
{0x1f691, false, fe0f2},
{0x1f694, false, fe0f2},
{0x1f698, false, fe0f2},
{0x1f6ad, false, fe0f2},
{0x1f6b2, false, fe0f2},
{0x1f6b9, false, fe0f2},
{0x1f6ba, false, fe0f2},
{0x1f6bc, false, fe0f2},
{0, true, NULL}};

/* RGI_Emoji_Flag_Sequence */
struct emoji_trie flags2[] = {{0x1f1e8, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f6, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fd, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags3[] = {{0x1f1e6, true, NULL},
{0x1f1e7, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1ef, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f6, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fb, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fe, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags4[] = {{0x1f1e6, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f5, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1fb, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fd, true, NULL},
{0x1f1fe, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags5[] = {{0x1f1ea, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ef, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags6[] = {{0x1f1e6, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fa, true, NULL},
{0, true, NULL}};

struct emoji_trie flags7[] = {{0x1f1ee, true, NULL},
{0x1f1ef, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f7, true, NULL},
{0, true, NULL}};

struct emoji_trie flags8[] = {{0x1f1e6, true, NULL},
{0x1f1e7, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f5, true, NULL},
{0x1f1f6, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fe, true, NULL},
{0, true, NULL}};

struct emoji_trie flags9[] = {{0x1f1f0, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fa, true, NULL},
{0, true, NULL}};

struct emoji_trie flags10[] = {{0x1f1e8, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f6, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0, true, NULL}};

struct emoji_trie flags11[] = {{0x1f1ea, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f5, true, NULL},
{0, true, NULL}};

struct emoji_trie flags12[] = {{0x1f1ea, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f5, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fe, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags13[] = {{0x1f1e6, true, NULL},
{0x1f1e7, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1fb, true, NULL},
{0x1f1fe, true, NULL},
{0, true, NULL}};

struct emoji_trie flags14[] = {{0x1f1e6, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f5, true, NULL},
{0x1f1f6, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1fb, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fd, true, NULL},
{0x1f1fe, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags15[] = {{0x1f1e6, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f5, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags16[] = {{0x1f1f2, true, NULL},
{0, true, NULL}};

struct emoji_trie flags17[] = {{0x1f1e6, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1fe, true, NULL},
{0, true, NULL}};

struct emoji_trie flags18[] = {{0x1f1e6, true, NULL},
{0, true, NULL}};

struct emoji_trie flags19[] = {{0x1f1ea, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1fa, true, NULL},
{0x1f1fc, true, NULL},
{0, true, NULL}};

struct emoji_trie flags20[] = {{0x1f1e6, true, NULL},
{0x1f1e7, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1ef, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fb, true, NULL},
{0x1f1fd, true, NULL},
{0x1f1fe, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags21[] = {{0x1f1e6, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1e9, true, NULL},
{0x1f1eb, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ed, true, NULL},
{0x1f1ef, true, NULL},
{0x1f1f0, true, NULL},
{0x1f1f1, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f4, true, NULL},
{0x1f1f7, true, NULL},
{0x1f1f9, true, NULL},
{0x1f1fb, true, NULL},
{0x1f1fc, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags22[] = {{0x1f1e6, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1f8, true, NULL},
{0x1f1fe, true, NULL},
{0x1f1ff, true, NULL},
{0, true, NULL}};

struct emoji_trie flags23[] = {{0x1f1e6, true, NULL},
{0x1f1e8, true, NULL},
{0x1f1ea, true, NULL},
{0x1f1ec, true, NULL},
{0x1f1ee, true, NULL},
{0x1f1f3, true, NULL},
{0x1f1fa, true, NULL},
{0, true, NULL}};

struct emoji_trie flags24[] = {{0x1f1eb, true, NULL},
{0x1f1f8, true, NULL},
{0, true, NULL}};

struct emoji_trie flags25[] = {{0x1f1f0, true, NULL},
{0, true, NULL}};

struct emoji_trie flags26[] = {{0x1f1ea, true, NULL},
{0x1f1f9, true, NULL},
{0, true, NULL}};

struct emoji_trie flags27[] = {{0x1f1e6, true, NULL},
{0x1f1f2, true, NULL},
{0x1f1fc, true, NULL},
{0, true, NULL}};

struct emoji_trie flags1[] = {{0x1f1e6, false, flags2},
{0x1f1e7, false, flags3},
{0x1f1e8, false, flags4},
{0x1f1e9, false, flags5},
{0x1f1ea, false, flags6},
{0x1f1eb, false, flags7},
{0x1f1ec, false, flags8},
{0x1f1ed, false, flags9},
{0x1f1ee, false, flags10},
{0x1f1ef, false, flags11},
{0x1f1f0, false, flags12},
{0x1f1f1, false, flags13},
{0x1f1f2, false, flags14},
{0x1f1f3, false, flags15},
{0x1f1f4, false, flags16},
{0x1f1f5, false, flags17},
{0x1f1f6, false, flags18},
{0x1f1f7, false, flags19},
{0x1f1f8, false, flags20},
{0x1f1f9, false, flags21},
{0x1f1fa, false, flags22},
{0x1f1fb, false, flags23},
{0x1f1fc, false, flags24},
{0x1f1fd, false, flags25},
{0x1f1fe, false, flags26},
{0x1f1ff, false, flags27},
{0, true, NULL}};

/* RGI_Emoji_Tag_Sequence */
struct emoji_trie tags7[] = {{0xe007f, true, NULL},
{0, true, NULL}};

struct emoji_trie tags6[] = {{0xe0067, false, tags7},
{0, true, NULL}};

struct emoji_trie tags5[] = {{0xe006e, false, tags6},
{0, true, NULL}};

struct emoji_trie tags9[] = {{0xe0074, false, tags7},
{0, true, NULL}};

struct emoji_trie tags8[] = {{0xe0063, false, tags9},
{0, true, NULL}};

struct emoji_trie tags12[] = {{0xe0073, false, tags7},
{0, true, NULL}};

struct emoji_trie tags11[] = {{0xe006c, false, tags12},
{0, true, NULL}};

struct emoji_trie tags4[] = {{0xe0065, false, tags5},
{0xe0073, false, tags8},
{0xe0077, false, tags11},
{0, true, NULL}};

struct emoji_trie tags3[] = {{0xe0062, false, tags4},
{0, true, NULL}};

struct emoji_trie tags2[] = {{0xe0067, false, tags3},
{0, true, NULL}};

struct emoji_trie tags1[] = {{0x1f3f4, false, tags2},
{0, true, NULL}};

/* RGI_Emoji_Modifier_Sequence */
struct emoji_trie modifiers2[] = {
{0x1f3fb, true, NULL},
{0x1f3fc, true, NULL},
{0x1f3fd, true, NULL},
{0x1f3fe, true, NULL},
{0x1f3ff, true, NULL},
{0, true, NULL}};

struct emoji_trie modifiers1[] = {
{0x261d, false, modifiers2},
{0x26f9, false, modifiers2},
{0x270a, false, modifiers2},
{0x270b, false, modifiers2},
{0x270c, false, modifiers2},
{0x270d, false, modifiers2},
{0x1f385, false, modifiers2},
{0x1f3c2, false, modifiers2},
{0x1f3c3, false, modifiers2},
{0x1f3c4, false, modifiers2},
{0x1f3c7, false, modifiers2},
{0x1f3ca, false, modifiers2},
{0x1f3cb, false, modifiers2},
{0x1f3cc, false, modifiers2},
{0x1f442, false, modifiers2},
{0x1f443, false, modifiers2},
{0x1f446, false, modifiers2},
{0x1f447, false, modifiers2},
{0x1f448, false, modifiers2},
{0x1f449, false, modifiers2},
{0x1f44a, false, modifiers2},
{0x1f44b, false, modifiers2},
{0x1f44c, false, modifiers2},
{0x1f44d, false, modifiers2},
{0x1f44e, false, modifiers2},
{0x1f44f, false, modifiers2},
{0x1f450, false, modifiers2},
{0x1f466, false, modifiers2},
{0x1f467, false, modifiers2},
{0x1f468, false, modifiers2},
{0x1f469, false, modifiers2},
{0x1f46b, false, modifiers2},
{0x1f46c, false, modifiers2},
{0x1f46d, false, modifiers2},
{0x1f46e, false, modifiers2},
{0x1f470, false, modifiers2},
{0x1f471, false, modifiers2},
{0x1f472, false, modifiers2},
{0x1f473, false, modifiers2},
{0x1f474, false, modifiers2},
{0x1f475, false, modifiers2},
{0x1f476, false, modifiers2},
{0x1f477, false, modifiers2},
{0x1f478, false, modifiers2},
{0x1f47c, false, modifiers2},
{0x1f481, false, modifiers2},
{0x1f482, false, modifiers2},
{0x1f483, false, modifiers2},
{0x1f485, false, modifiers2},
{0x1f486, false, modifiers2},
{0x1f487, false, modifiers2},
{0x1f4aa, false, modifiers2},
{0x1f574, false, modifiers2},
{0x1f575, false, modifiers2},
{0x1f57a, false, modifiers2},
{0x1f590, false, modifiers2},
{0x1f595, false, modifiers2},
{0x1f596, false, modifiers2},
{0x1f645, false, modifiers2},
{0x1f646, false, modifiers2},
{0x1f647, false, modifiers2},
{0x1f64b, false, modifiers2},
{0x1f64c, false, modifiers2},
{0x1f64d, false, modifiers2},
{0x1f64e, false, modifiers2},
{0x1f64f, false, modifiers2},
{0x1f6a3, false, modifiers2},
{0x1f6b4, false, modifiers2},
{0x1f6b5, false, modifiers2},
{0x1f6b6, false, modifiers2},
{0x1f6c0, false, modifiers2},
{0x1f6cc, false, modifiers2},
{0x1f90c, false, modifiers2},
{0x1f90f, false, modifiers2},
{0x1f918, false, modifiers2},
{0x1f919, false, modifiers2},
{0x1f91a, false, modifiers2},
{0x1f91b, false, modifiers2},
{0x1f91c, false, modifiers2},
{0x1f91e, false, modifiers2},
{0x1f91f, false, modifiers2},
{0x1f926, false, modifiers2},
{0x1f930, false, modifiers2},
{0x1f931, false, modifiers2},
{0x1f932, false, modifiers2},
{0x1f933, false, modifiers2},
{0x1f934, false, modifiers2},
{0x1f935, false, modifiers2},
{0x1f936, false, modifiers2},
{0x1f937, false, modifiers2},
{0x1f938, false, modifiers2},
{0x1f939, false, modifiers2},
{0x1f93d, false, modifiers2},
{0x1f93e, false, modifiers2},
{0x1f977, false, modifiers2},
{0x1f9b5, false, modifiers2},
{0x1f9b6, false, modifiers2},
{0x1f9b8, false, modifiers2},
{0x1f9b9, false, modifiers2},
{0x1f9bb, false, modifiers2},
{0x1f9cd, false, modifiers2},
{0x1f9ce, false, modifiers2},
{0x1f9cf, false, modifiers2},
{0x1f9d1, false, modifiers2},
{0x1f9d2, false, modifiers2},
{0x1f9d3, false, modifiers2},
{0x1f9d4, false, modifiers2},
{0x1f9d5, false, modifiers2},
{0x1f9d6, false, modifiers2},
{0x1f9d7, false, modifiers2},
{0x1f9d8, false, modifiers2},
{0x1f9d9, false, modifiers2},
{0x1f9da, false, modifiers2},
{0x1f9db, false, modifiers2},
{0x1f9dc, false, modifiers2},
{0x1f9dd, false, modifiers2},
{0, true, NULL}};

/* RGI_Emoji_ZWJ_Sequence */
struct emoji_trie zwj8[] = {{0x1f468, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj7[] = {{0x200d, false, zwj8},
{0, true, NULL}};

struct emoji_trie zwj6[] = {{0x1f468, true, NULL},
{0x1f48b, false, zwj7},
{0, true, NULL}};

struct emoji_trie zwj5[] = {{0x200d, false, zwj6},
{0, true, NULL}};

struct emoji_trie zwj4[] = {{0xfe0f, false, zwj5},
{0, true, NULL}};

struct emoji_trie zwj10[] = {{0x1f466, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj9[] = {{0x200d, false, zwj10},
{0, true, NULL}};

struct emoji_trie zwj12[] = {{0x1f466, true, NULL},
{0x1f467, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj11[] = {{0x200d, false, zwj12},
{0, true, NULL}};

struct emoji_trie zwj14[] = {{0x1f466, true, zwj9},
{0x1f467, true, zwj11},
{0, true, NULL}};

struct emoji_trie zwj13[] = {{0x200d, false, zwj14},
{0, true, NULL}};

struct emoji_trie zwj25[] = {{0xfe0f, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj3[] = {{0x2764, false, zwj4},
{0x1f466, true, zwj9},
{0x1f467, true, zwj11},
{0x1f468, false, zwj13},
{0x1f469, false, zwj13},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj32[] = {{0x1f3fc, true, NULL},
{0x1f3fd, true, NULL},
{0x1f3fe, true, NULL},
{0x1f3ff, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj31[] = {{0x1f468, false, zwj32},
{0, true, NULL}};

struct emoji_trie zwj30[] = {{0x200d, false, zwj31},
{0, true, NULL}};

struct emoji_trie zwj29[] = {{0x1f91d, false, zwj30},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj28[] = {{0x200d, false, zwj29},
{0, true, NULL}};

struct emoji_trie zwj40[] = {{0x1f3fb, true, NULL},
{0x1f3fd, true, NULL},
{0x1f3fe, true, NULL},
{0x1f3ff, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj39[] = {{0x1f468, false, zwj40},
{0, true, NULL}};

struct emoji_trie zwj38[] = {{0x200d, false, zwj39},
{0, true, NULL}};

struct emoji_trie zwj37[] = {{0x1f91d, false, zwj38},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj36[] = {{0x200d, false, zwj37},
{0, true, NULL}};

struct emoji_trie zwj48[] = {{0x1f3fb, true, NULL},
{0x1f3fc, true, NULL},
{0x1f3fe, true, NULL},
{0x1f3ff, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj47[] = {{0x1f468, false, zwj48},
{0, true, NULL}};

struct emoji_trie zwj46[] = {{0x200d, false, zwj47},
{0, true, NULL}};

struct emoji_trie zwj45[] = {{0x1f91d, false, zwj46},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj44[] = {{0x200d, false, zwj45},
{0, true, NULL}};

struct emoji_trie zwj56[] = {{0x1f3fb, true, NULL},
{0x1f3fc, true, NULL},
{0x1f3fd, true, NULL},
{0x1f3ff, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj55[] = {{0x1f468, false, zwj56},
{0, true, NULL}};

struct emoji_trie zwj54[] = {{0x200d, false, zwj55},
{0, true, NULL}};

struct emoji_trie zwj53[] = {{0x1f91d, false, zwj54},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj52[] = {{0x200d, false, zwj53},
{0, true, NULL}};

struct emoji_trie zwj64[] = {{0x1f3fb, true, NULL},
{0x1f3fc, true, NULL},
{0x1f3fd, true, NULL},
{0x1f3fe, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj63[] = {{0x1f468, false, zwj64},
{0, true, NULL}};

struct emoji_trie zwj62[] = {{0x200d, false, zwj63},
{0, true, NULL}};

struct emoji_trie zwj61[] = {{0x1f91d, false, zwj62},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj60[] = {{0x200d, false, zwj61},
{0, true, NULL}};

struct emoji_trie zwj2[] = {{0x200d, false, zwj3},
{0x1f3fb, false, zwj28},
{0x1f3fc, false, zwj36},
{0x1f3fd, false, zwj44},
{0x1f3fe, false, zwj52},
{0x1f3ff, false, zwj60},
{0, true, NULL}};

struct emoji_trie zwj74[] = {{0x1f468, true, NULL},
{0x1f469, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj73[] = {{0x200d, false, zwj74},
{0, true, NULL}};

struct emoji_trie zwj72[] = {{0x1f468, true, NULL},
{0x1f469, true, NULL},
{0x1f48b, false, zwj73},
{0, true, NULL}};

struct emoji_trie zwj71[] = {{0x200d, false, zwj72},
{0, true, NULL}};

struct emoji_trie zwj70[] = {{0xfe0f, false, zwj71},
{0, true, NULL}};

struct emoji_trie zwj69[] = {{0x2764, false, zwj70},
{0x1f466, true, zwj9},
{0x1f467, true, zwj11},
{0x1f469, false, zwj13},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj91[] = {{0x1f468, false, zwj32},
{0x1f469, false, zwj32},
{0, true, NULL}};

struct emoji_trie zwj90[] = {{0x200d, false, zwj91},
{0, true, NULL}};

struct emoji_trie zwj89[] = {{0x1f91d, false, zwj90},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj88[] = {{0x200d, false, zwj89},
{0, true, NULL}};

struct emoji_trie zwj100[] = {{0x1f468, false, zwj40},
{0x1f469, false, zwj40},
{0, true, NULL}};

struct emoji_trie zwj99[] = {{0x200d, false, zwj100},
{0, true, NULL}};

struct emoji_trie zwj98[] = {{0x1f91d, false, zwj99},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj97[] = {{0x200d, false, zwj98},
{0, true, NULL}};

struct emoji_trie zwj109[] = {{0x1f468, false, zwj48},
{0x1f469, false, zwj48},
{0, true, NULL}};

struct emoji_trie zwj108[] = {{0x200d, false, zwj109},
{0, true, NULL}};

struct emoji_trie zwj107[] = {{0x1f91d, false, zwj108},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj106[] = {{0x200d, false, zwj107},
{0, true, NULL}};

struct emoji_trie zwj118[] = {{0x1f468, false, zwj56},
{0x1f469, false, zwj56},
{0, true, NULL}};

struct emoji_trie zwj117[] = {{0x200d, false, zwj118},
{0, true, NULL}};

struct emoji_trie zwj116[] = {{0x1f91d, false, zwj117},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj115[] = {{0x200d, false, zwj116},
{0, true, NULL}};

struct emoji_trie zwj127[] = {{0x1f468, false, zwj64},
{0x1f469, false, zwj64},
{0, true, NULL}};

struct emoji_trie zwj126[] = {{0x200d, false, zwj127},
{0, true, NULL}};

struct emoji_trie zwj125[] = {{0x1f91d, false, zwj126},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj124[] = {{0x200d, false, zwj125},
{0, true, NULL}};

struct emoji_trie zwj68[] = {{0x200d, false, zwj69},
{0x1f3fb, false, zwj88},
{0x1f3fc, false, zwj97},
{0x1f3fd, false, zwj106},
{0x1f3fe, false, zwj115},
{0x1f3ff, false, zwj124},
{0, true, NULL}};

struct emoji_trie zwj136[] = {{0x1f9d1, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj135[] = {{0x200d, false, zwj136},
{0, true, NULL}};

struct emoji_trie zwj134[] = {{0x1f91d, false, zwj135},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0x1f384, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj144[] = {{0x1f3fb, true, NULL},
{0x1f3fc, true, NULL},
{0x1f3fd, true, NULL},
{0x1f3fe, true, NULL},
{0x1f3ff, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj143[] = {{0x1f9d1, false, zwj144},
{0, true, NULL}};

struct emoji_trie zwj142[] = {{0x200d, false, zwj143},
{0, true, NULL}};

struct emoji_trie zwj141[] = {{0x1f384, true, NULL},
{0x1f91d, false, zwj142},
{0x2695, false, zwj25},
{0x2696, false, zwj25},
{0x2708, false, zwj25},
{0x1f33e, true, NULL},
{0x1f373, true, NULL},
{0x1f37c, true, NULL},
{0x1f393, true, NULL},
{0x1f3a4, true, NULL},
{0x1f3a8, true, NULL},
{0x1f3eb, true, NULL},
{0x1f3ed, true, NULL},
{0x1f4bb, true, NULL},
{0x1f4bc, true, NULL},
{0x1f527, true, NULL},
{0x1f52c, true, NULL},
{0x1f680, true, NULL},
{0x1f692, true, NULL},
{0x1f9af, true, NULL},
{0x1f9bc, true, NULL},
{0x1f9bd, true, NULL},
{0x1f9b0, true, NULL},
{0x1f9b1, true, NULL},
{0x1f9b2, true, NULL},
{0x1f9b3, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj140[] = {{0x200d, false, zwj141},
{0, true, NULL}};

struct emoji_trie zwj133[] = {{0x200d, false, zwj134},
{0x1f3fb, false, zwj140},
{0x1f3fc, false, zwj140},
{0x1f3fd, false, zwj140},
{0x1f3fe, false, zwj140},
{0x1f3ff, false, zwj140},
{0, true, NULL}};

struct emoji_trie zwj182[] = {{0x2640, false, zwj25},
{0x2642, false, zwj25},
{0, true, NULL}};

struct emoji_trie zwj181[] = {{0x200d, false, zwj182},
{0, true, NULL}};

struct emoji_trie zwj180[] = {{0x1f3fb, false, zwj181},
{0x1f3fc, false, zwj181},
{0x1f3fd, false, zwj181},
{0x1f3fe, false, zwj181},
{0x1f3ff, false, zwj181},
{0xfe0f, false, zwj181},
{0, true, NULL}};

struct emoji_trie zwj205[] = {{0x200d, false, zwj182},
{0x1f3fb, false, zwj181},
{0x1f3fc, false, zwj181},
{0x1f3fd, false, zwj181},
{0x1f3fe, false, zwj181},
{0x1f3ff, false, zwj181},
{0, true, NULL}};

struct emoji_trie zwj1306[] = {{0x26a7, false, zwj25},
{0x1f308, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj1305[] = {{0x200d, false, zwj1306},
{0, true, NULL}};

struct emoji_trie zwj1304[] = {{0xfe0f, false, zwj1305},
{0, true, NULL}};

struct emoji_trie zwj1309[] = {{0x2620, false, zwj25},
{0, true, NULL}};

struct emoji_trie zwj1308[] = {{0x200d, false, zwj1309},
{0, true, NULL}};

struct emoji_trie zwj1312[] = {{0x2b1b, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj1311[] = {{0x200d, false, zwj1312},
{0, true, NULL}};

struct emoji_trie zwj1314[] = {{0x1f9ba, true, NULL},
{0, true, NULL}};

struct emoji_trie zwj1313[] = {{0x200d, false, zwj1314},
{0, true, NULL}};

struct emoji_trie zwj1316[] = {{0x2744, false, zwj25},
{0, true, NULL}};

struct emoji_trie zwj1315[] = {{0x200d, false, zwj1316},
{0, true, NULL}};

struct emoji_trie zwj1320[] = {{0x1f5e8, false, zwj25},
{0, true, NULL}};

struct emoji_trie zwj1319[] = {{0x200d, false, zwj1320},
{0, true, NULL}};

struct emoji_trie zwj1318[] = {{0xfe0f, false, zwj1319},
{0, true, NULL}};

struct emoji_trie zwj1[] = {{0x1f468, false, zwj2},
{0x1f469, false, zwj68},
{0x1f9d1, false, zwj133},
{0x26f9, false, zwj180},
{0x1f3c3, false, zwj205},
{0x1f3c4, false, zwj205},
{0x1f3ca, false, zwj205},
{0x1f3cb, false, zwj180},
{0x1f3cc, false, zwj180},
{0x1f46e, false, zwj205},
{0x1f46f, false, zwj181},
{0x1f470, false, zwj205},
{0x1f471, false, zwj205},
{0x1f473, false, zwj205},
{0x1f477, false, zwj205},
{0x1f481, false, zwj205},
{0x1f482, false, zwj205},
{0x1f486, false, zwj205},
{0x1f487, false, zwj205},
{0x1f575, false, zwj180},
{0x1f645, false, zwj205},
{0x1f646, false, zwj205},
{0x1f647, false, zwj205},
{0x1f64b, false, zwj205},
{0x1f64d, false, zwj205},
{0x1f64e, false, zwj205},
{0x1f6a3, false, zwj205},
{0x1f6b4, false, zwj205},
{0x1f6b5, false, zwj205},
{0x1f6b6, false, zwj205},
{0x1f926, false, zwj205},
{0x1f935, false, zwj205},
{0x1f937, false, zwj205},
{0x1f938, false, zwj205},
{0x1f939, false, zwj205},
{0x1f93c, false, zwj181},
{0x1f93d, false, zwj205},
{0x1f93e, false, zwj205},
{0x1f9b8, false, zwj205},
{0x1f9b9, false, zwj205},
{0x1f9cd, false, zwj205},
{0x1f9ce, false, zwj205},
{0x1f9cf, false, zwj205},
{0x1f9d6, false, zwj205},
{0x1f9d7, false, zwj205},
{0x1f9d8, false, zwj205},
{0x1f9d9, false, zwj205},
{0x1f9da, false, zwj205},
{0x1f9db, false, zwj205},
{0x1f9dc, false, zwj205},
{0x1f9dd, false, zwj205},
{0x1f9de, false, zwj181},
{0x1f9df, false, zwj181},
{0x1f3f3, false, zwj1304},
{0x1f3f4, false, zwj1308},
{0x1f408, false, zwj1311},
{0x1f415, false, zwj1313},
{0x1f43b, false, zwj1315},
{0x1f441, false, zwj1318},
{0, true, NULL}};

/* For heart-on-fire emoji */
struct emoji_trie heart_on_fire_0[] = {
        {0x1f525, true, NULL},
        {0, true, NULL}};

struct emoji_trie heart_on_fire_1[] = {
        {0x200d, false, heart_on_fire_0},
        {0, true, NULL}};

struct emoji_trie heart_fe0f_or_on_fire[] = {
        {0xfe0f, true, heart_on_fire_1},
        {0, true, NULL}};

/*
 * NOTE: Chars treated as emojis, but not in the emojis specification
 * See https://t.me/tdlibchat/42441
 */
struct emoji_trie emoji_exceptions[] = {
        {0x2764, true, heart_fe0f_or_on_fire},  /* ❤ */
        {0, true, NULL}
};


/** Emoji lookup table **/
/* 0x231A <= X <= 0x2B55 */
struct emoji_match_table emoji_basic1_tables[] = {
        /*
         * From emoji-variation-sequences.txt v12.1
         * See https://github.com/zevlg/telega.el/issues/179
         */
        {0x231a, 0x2b55, 0, emoji_12_1_basic1_fe0f},

        {0x231A, 0x231B, 0, any_emoji},
        {0x23E9, 0x23EC, 0, any_emoji},
        {0x23F0, 0x23F0, 0, any_emoji},
        {0x23F3, 0x23F3, 0, any_emoji},
        {0x25FD, 0x25FE, 0, any_emoji},
        {0x2614, 0x2615, 0, any_emoji},
        {0x2648, 0x2653, 0, any_emoji},
        {0x267F, 0x267F, 0, any_emoji},
        {0x2693, 0x2693, 0, any_emoji},
        {0x26A1, 0x26A1, 0, any_emoji},
        {0x26AA, 0x26AB, 0, any_emoji},
        {0x26BD, 0x26BE, 0, any_emoji},
        {0x26C4, 0x26C5, 0, any_emoji},
        {0x26CE, 0x26CE, 0, any_emoji},
        {0x26D4, 0x26D4, 0, any_emoji},
        {0x26EA, 0x26EA, 0, any_emoji},
        {0x26F2, 0x26F3, 0, any_emoji},
        {0x26F5, 0x26F5, 0, any_emoji},
        {0x26FA, 0x26FA, 0, any_emoji},
        {0x26FD, 0x26FD, 0, any_emoji},
        {0x2705, 0x2705, 0, any_emoji},
        {0x270A, 0x270B, 0, any_emoji},
        {0x2728, 0x2728, 0, any_emoji},
        {0x274C, 0x274C, 0, any_emoji},
        {0x274E, 0x274E, 0, any_emoji},
        {0x2753, 0x2755, 0, any_emoji},
        {0x2757, 0x2757, 0, any_emoji},
        {0x2764, 0x2764, 0, emoji_exceptions},
        {0x2795, 0x2797, 0, any_emoji},
        {0x27B0, 0x27B0, 0, any_emoji},
        {0x27BF, 0x27BF, 0, any_emoji},
        {0x2B1B, 0x2B1C, 0, any_emoji},
        {0x2B50, 0x2B50, 0, any_emoji},
        {0x2B55, 0x2B55, 0, any_emoji},
        {0, 0, 0, NULL}
};

/* 0x1F004 <= X <= 0x1FAD6 */
struct emoji_match_table emoji_basic2_tables[] =
{
        /*
         * From emoji-variation-sequences.txt v12.1
         * See https://github.com/zevlg/telega.el/issues/179
         */
        {0x1f004, 0x1f6bc, 0, emoji_12_1_basic2_fe0f},

        {0x1F004, 0x1F004, 0, any_emoji},
        {0x1F0CF, 0x1F0CF, 0, any_emoji},
        {0x1F18E, 0x1F18E, 0, any_emoji},
        {0x1F191, 0x1F19A, 0, any_emoji},
        {0x1F201, 0x1F201, 0, any_emoji},
        {0x1F21A, 0x1F21A, 0, any_emoji},
        {0x1F22F, 0x1F22F, 0, any_emoji},
        {0x1F232, 0x1F23A, 0, any_emoji},
        {0x1F250, 0x1F251, 0, any_emoji},
        {0x1F300, 0x1F320, 0, any_emoji},
        {0x1F32D, 0x1F393, 0, any_emoji},
        {0x1F3A0, 0x1F3CA, 0, any_emoji},
        {0x1F3CF, 0x1F3D3, 0, any_emoji},
        {0x1F3E0, 0x1F3F0, 0, any_emoji},
        {0x1F3F4, 0x1F3F4, 0, any_emoji},
        {0x1F3F8, 0x1F567, 0, any_emoji},
        {0x1F57A, 0x1F57A, 0, any_emoji},
        {0x1F595, 0x1F596, 0, any_emoji},
        {0x1F5A4, 0x1F5A4, 0, any_emoji},
        {0x1F5FB, 0x1F7EB, 0, any_emoji},
        {0x1F90C, 0x1F9FF, 0, any_emoji},
        {0x1FA70, 0x1FA74, 0, any_emoji},
        {0x1FA78, 0x1FA86, 0, any_emoji},
        {0x1FA90, 0x1FAA8, 0, any_emoji},
        {0x1FAB0, 0x1FAB6, 0, any_emoji},
        {0x1FAC0, 0x1FAC2, 0, any_emoji},
        {0x1FAD0, 0x1FAD6, 0, any_emoji},
        {0, 0, 0, NULL}
};

struct emoji_match_table emoji_other_tables[] =
{
        /* With FE0F, includes Emoji_Keycap_Sequence */
        {0xFE0F, 0xFE0F, 1, fe0f1},

        /*
         * Emoji keycap sequences without FE0F, they are treated as
         * emojis in official client
         */
        {0x20E3, 0x20E3, 1, emoji_keycaps_no_fe0f},

        /* Flags */
        {0x1F1E6, 0x1F1FF, 0, flags1},

        /* Tag sequences */
        {0x1F3F4, 0x1F3F4, 0, tags1},

        /* Modifiers */
        {0x1F3FB, 0x1F3FF, 1, modifiers1},

        /* ZWJ */
        {0x200D, 0x200D, 2, zwj1},

        {0, 0, 0, NULL}
};

struct emoji_match_table emoji_null_tables[] =
{
        {0, 0, 0, NULL}
};
